/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.enums;

import java.util.Objects;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum DimsionEnums {
    ORG("fpm_orgimport", "Org", "fpm_member", new MultiLangEnumBridge("\u7f16\u62a5\u4e3b\u4f53", "DimsionEnums_0", "tmc-fpm-common"), new String[]{"number", "name", "description", "modifier", "modifytime"}, "id,number,name,description,modifier.name as modifier,modifytime,parent,isleaf,enable"),
    SUBJECT("fpm_subjectmemberimport", "Subjects", "fpm_membersubject", new MultiLangEnumBridge("\u8ba1\u5212\u79d1\u76ee", "DimsionEnums_1", "tmc-fpm-common"), new String[]{"number", "name", "description", "modifier", "modifytime"}, "id,number,name,description,modifier.name as modifier,modifytime,parent,isleaf,enable"),
    PERIOD("fpm_periodimport", "Period", "fpm_member", new MultiLangEnumBridge("\u671f\u95f4", "DimsionEnums_2", "tmc-fpm-common"), new String[]{"number", "name", "reporttype", "startdate", "enddate", "declarestatus", "modifytime", "modifier"}, "id,number,name,description,modifier.name as modifier,modifytime,parent,isleaf,enable"),
    SETLTMENT("fpm_setimport", "Settlement Method", "fpm_member", new MultiLangEnumBridge("\u7ed3\u7b97\u65b9\u5f0f", "DimsionEnums_3", "tmc-fpm-common"), new String[]{"number", "name", "description", "modifier", "modifytime"}, "id,number,name,description,modifier.name as modifier,modifytime,parent,isleaf,enable"),
    CURRENCY("fpm_currencyimport", "Currency", "fpm_member", new MultiLangEnumBridge("\u5e01\u79cd", "DimsionEnums_4", "tmc-fpm-common"), new String[]{"number", "name", "description", "modifier", "modifytime"}, "id,number,name,description,modifier.name as modifier,modifytime,parent,isleaf,enable"),
    COMPANY("fpm_companyimport", "Company", "fpm_member", new MultiLangEnumBridge("\u516c\u53f8", "DimsionEnums_5", "tmc-fpm-common"), new String[]{"number", "name", "description", "modifier", "modifytime"}, "id,number,name,description,modifier.name as modifier,modifytime,parent,isleaf,enable"),
    METRIC("fpm_metricimport", "Metric", "fpm_member", new MultiLangEnumBridge("\u5ea6\u91cf\u6307\u6807", "DimsionEnums_6", "tmc-fpm-common"), new String[]{"number", "name", "description", "modifier", "modifytime"}, "id,number,name,description,modifier.name as modifier,modifytime,parent,isleaf,enable"),
    CUSTOM("", "Custom", "fpm_member", new MultiLangEnumBridge("\u81ea\u5b9a\u4e49", "DimsionEnums_7", "tmc-fpm-common"), new String[0], "");

    private String importMatedata;
    private String number;
    private String matedata;
    private MultiLangEnumBridge name;
    private String[] showlist;
    private String selectFields;

    private DimsionEnums(String importMatedata, String number, String matedata, MultiLangEnumBridge name, String[] showlist, String selectFields) {
        this.importMatedata = importMatedata;
        this.number = number;
        this.matedata = matedata;
        this.name = name;
        this.showlist = showlist;
        this.selectFields = selectFields;
    }

    public String getNumber() {
        return this.number;
    }

    public String getMetadata() {
        return this.matedata;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getSelectFields() {
        return this.selectFields;
    }

    public String[] getShowlist() {
        return this.showlist;
    }

    public String getImportMatedata() {
        return this.importMatedata;
    }

    public static DimsionEnums getDimsionByNumber(String number) {
        for (DimsionEnums de : DimsionEnums.values()) {
            if (!number.equalsIgnoreCase(de.getNumber())) continue;
            return de;
        }
        return CUSTOM;
    }

    public static DimsionEnums getDimsionByMD(String mD) {
        for (DimsionEnums de : DimsionEnums.values()) {
            if (!mD.equalsIgnoreCase(de.getMetadata())) continue;
            return de;
        }
        return null;
    }

    public static boolean isMainDim(String dimType) {
        return DimsionEnums.isMainDim(DimsionEnums.getDimsionByNumber(dimType));
    }

    public static boolean isMainDim(DimsionEnums dimsionEnums) {
        if (Objects.isNull((Object)dimsionEnums)) {
            return false;
        }
        switch (dimsionEnums) {
            case ORG: 
            case PERIOD: 
            case SUBJECT: 
            case CURRENCY: 
            case METRIC: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSubject(DimsionEnums dimsionEnums) {
        return dimsionEnums == SUBJECT;
    }

    public static boolean isOrg(DimsionEnums dimsionEnums) {
        return dimsionEnums == ORG;
    }
}

