/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.enums;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import org.apache.commons.lang3.StringUtils;

public enum InoutCycleEnum {
    NULL("", 0, 0, false, false, new MultiLangEnumBridge("", "InoutCycleEnum_0", "tmc-fpm-common")),
    MONTH("Month", 2, 1, false, true, new MultiLangEnumBridge("\u6309\u6708", "InoutCycleEnum_1", "tmc-fpm-common")),
    WEEK("Week", 3, 1, false, false, new MultiLangEnumBridge("\u6309\u5468", "InoutCycleEnum_2", "tmc-fpm-common")),
    DAY("Day", 6, 1, false, false, new MultiLangEnumBridge("\u6309\u65e5", "InoutCycleEnum_3", "tmc-fpm-common")),
    HALF_YEAR("HalfYear", 2, 6, false, true, new MultiLangEnumBridge("\u6309\u534a\u5e74", "InoutCycleEnum_4", "tmc-fpm-common")),
    YEAR("Year", 1, 1, false, true, new MultiLangEnumBridge("\u6309\u5e74", "InoutCycleEnum_5", "tmc-fpm-common"));

    private String code;
    private MultiLangEnumBridge name;
    private int type;
    private int period;
    private boolean monthEnd;
    private boolean needReset;

    private InoutCycleEnum(String code, int type, int period, boolean monthEnd, boolean needReset, MultiLangEnumBridge name) {
        this.code = code;
        this.name = name;
        this.type = type;
        this.period = period;
        this.monthEnd = monthEnd;
        this.needReset = needReset;
    }

    public String getCode() {
        return this.code;
    }

    public MultiLangEnumBridge getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getPeriod() {
        return this.period;
    }

    public boolean isMonthEnd() {
        return this.monthEnd;
    }

    public boolean isNeedReset() {
        return this.needReset;
    }

    public static InoutCycleEnum getByCode(String code) {
        InoutCycleEnum[] values;
        for (InoutCycleEnum val : values = InoutCycleEnum.values()) {
            if (!StringUtils.equals((CharSequence)val.getCode(), (CharSequence)code)) continue;
            return val;
        }
        return NULL;
    }

    public static final class InoutCycleDay {
        private InoutCycleEnum inoutCycleEnum;
        private int day;
        private int repeatCycle;

        public InoutCycleDay(InoutCycleEnum inoutCycleEnum, int day, int repeatCycle) {
            this.inoutCycleEnum = inoutCycleEnum;
            this.day = day;
            this.repeatCycle = repeatCycle;
        }

        public InoutCycleEnum getInoutCycleEnum() {
            return this.inoutCycleEnum;
        }

        public void setInoutCycleEnum(InoutCycleEnum inoutCycleEnum) {
            this.inoutCycleEnum = inoutCycleEnum;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int day) {
            this.day = day;
        }

        public int getRepeatCycle() {
            return this.repeatCycle;
        }

        public void setRepeatCycle(int repeatCycle) {
            this.repeatCycle = repeatCycle;
        }

        public Date getExpectDate(Date firstDate, AtomicReference<Date> currentDateRef, Calendar calendar) {
            this.checkInoutCycle();
            Date currentDate = currentDateRef.get();
            calendar.setTime(firstDate);
            boolean monthEnd = this.inoutCycleEnum.isMonthEnd();
            boolean isMonthEnd = false;
            if (monthEnd) {
                int month = calendar.get(2);
                calendar.add(5, 1);
                int nextMonth = calendar.get(2);
                if (month != nextMonth) {
                    isMonthEnd = true;
                }
                calendar.add(5, -1);
            }
            if (firstDate.compareTo(currentDate) >= 0) {
                calendar.add(5, 1);
                currentDateRef.set(calendar.getTime());
                return firstDate;
            }
            int type = this.inoutCycleEnum.getType();
            int period = this.inoutCycleEnum.getPeriod();
            while (currentDate.after(calendar.getTime())) {
                for (int i = 0; i < this.repeatCycle; ++i) {
                    calendar.add(type, period);
                }
            }
            if (isMonthEnd) {
                calendar.add(2, 1);
                calendar.set(5, 1);
                calendar.add(5, -1);
            }
            this.notMonthEnd(calendar);
            Date nextTime = calendar.getTime();
            calendar.add(6, 1);
            currentDateRef.set(calendar.getTime());
            return nextTime;
        }

        private void notMonthEnd(Calendar calendar) {
            if (this.inoutCycleEnum.monthEnd) {
                return;
            }
            if (!this.inoutCycleEnum.isNeedReset()) {
                return;
            }
            calendar.add(2, 1);
            calendar.set(5, 1);
            calendar.add(5, -1);
            int lastDayOfMonth = calendar.get(5);
            if (lastDayOfMonth >= this.day) {
                calendar.set(5, this.day);
            }
        }

        private void checkInoutCycle() {
            if (this.inoutCycleEnum == NULL) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6536\u652f\u5468\u671f", (String)"InoutCycleEnum_6", (String)"tmc-fpm-common", (Object[])new Object[0]));
            }
        }
    }
}

