/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.bean.UserAuthModel;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ModelHelper {
    private static final Log logger = LogFactory.getLog(ModelHelper.class);

    public static List<Long> getAuthModelId() {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_bodysysmanage", (QFilter[])ModelHelper.getAuthQFilter().toArray(), null, (int)-1);
        return ids.stream().map(d -> (Long)d).collect(Collectors.toList());
    }

    @Deprecated
    public static DynamicObject getAuthDefaultModelData() {
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_bodysysmanage", (QFilter[])ModelHelper.getAuthQFilter().toArray(), (String)"number", (int)1);
        if (EmptyUtil.isEmpty((Collection)idList)) {
            return null;
        }
        return TmcDataServiceHelper.loadSingle(idList.get(0), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"));
    }

    public static DynamicObject[] getAuthModelData(String selectProps) {
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)selectProps, (QFilter[])ModelHelper.getAuthQFilter().toArray(), (String)"number");
        return (DynamicObject[])colls.toArray((Object[])new DynamicObject[0]);
    }

    public static QFilter getAuthQFilter() {
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        return enableQFilter.and(ModelHelper.getAllAuthQFilter());
    }

    public static QFilter getAllAuthQFilter() {
        Long userId = RequestContext.get().getCurrUserId();
        boolean adminUser = PermissionServiceHelper.isSuperUser((long)userId);
        if (adminUser) {
            return new QFilter("1", "=", (Object)1);
        }
        QFilter creatorQFilter = new QFilter("creatormanage.id", "=", (Object)userId);
        QFilter userQFilter = new QFilter("usermanage.fbasedataid.id", "=", (Object)userId);
        QFilter userGQFilter = new QFilter("usergroupmanage.fbasedataid.entryentity.userfield.id", "in", (Object)new Object[]{userId});
        return creatorQFilter.or(userQFilter).or(userGQFilter);
    }

    public static QFilter getOrgAuthFilter(String appId, String entityId) {
        QFilter authFilter = new QFilter("1", "=", (Object)1);
        List<Long> orgAuthScope = ModelHelper.getOrgAuthScope(appId, entityId);
        if (!CollectionUtils.isEmpty(orgAuthScope)) {
            authFilter.and(new QFilter("id", "in", orgAuthScope));
        }
        return authFilter;
    }

    public static QFilter getOrgAuthWithCheckManagerFilter(String appId, String entityId) {
        QFilter authFilter = new QFilter("1", "=", (Object)1);
        List<Long> orgAuthScope = ModelHelper.getOrgAuthScopeWithCheckManager(appId, entityId);
        if (!CollectionUtils.isEmpty(orgAuthScope)) {
            authFilter.and(new QFilter("id", "in", orgAuthScope));
        }
        return authFilter;
    }

    public static QFilter getSystemAuthFilter(String appId, String entityId) {
        QFilter authFilter = new QFilter("1", "=", (Object)1);
        List<Long> bodySysIdList = ModelHelper.getSystemAuthScope(appId, entityId);
        if (!CollectionUtils.isEmpty(bodySysIdList)) {
            authFilter.and(new QFilter("id", "in", bodySysIdList));
        }
        return authFilter;
    }

    public static QFilter getSystemAuthWithCheckManagerFilter(String appId, String entityId) {
        QFilter authFilter = new QFilter("1", "=", (Object)1);
        List<Long> bodySysIdList = ModelHelper.getSystemAuthScopeWithCheckManager(appId, entityId);
        if (!CollectionUtils.isEmpty(bodySysIdList)) {
            authFilter.and(new QFilter("id", "in", bodySysIdList));
        }
        return authFilter;
    }

    public static UserAuthModel getAuthScopeModel(String appId, String entityId) {
        return ModelHelper.loadAuthScopeBySystemBizType(appId, entityId);
    }

    public static UserAuthModel getAuthScopeModelWithCheckManager(String appId, String entityId) {
        return ModelHelper.loadAuthScopeWithCheckSystemManager(appId, entityId);
    }

    public static List<Long> getOrgAuthScope(String appId, String entityId) {
        UserAuthModel authModel = ModelHelper.loadAuthScopeBySystemBizType(appId, entityId);
        return authModel.getOrgIds();
    }

    public static List<Long> getOrgAuthScopeWithCheckManager(String appId, String entityId) {
        UserAuthModel authModel = ModelHelper.loadAuthScopeWithCheckSystemManager(appId, entityId);
        return authModel.getOrgIds();
    }

    public static List<Long> getOrgAuthScopeBySystemId(String appId, String entityId, Long systemId) {
        UserAuthModel userAuthModel = ModelHelper.loadAuthScopeBySystemId(appId, entityId, systemId);
        return userAuthModel.getOrgIds();
    }

    public static List<Long> getSystemAuthScope(String appId, String entityId) {
        UserAuthModel authModel = ModelHelper.loadAuthScopeBySystemBizType(appId, entityId);
        return authModel.getSystemIds();
    }

    public static List<Long> getSystemAuthScopeWithCheckManager(String appId, String entityId) {
        UserAuthModel authModel = ModelHelper.loadAuthScopeWithCheckSystemManager(appId, entityId);
        return authModel.getSystemIds();
    }

    private static UserAuthModel loadAuthScopeWithCheckSystemManager(String appId, String entityId) {
        List<Long> systemIds = ModelHelper.getAuthModelId();
        UserAuthModel userAuthByBizType = ModelHelper.loadAuthScopeBySystemBizType(appId, entityId);
        UserAuthModel result = new UserAuthModel();
        QFilter sysFilter = new QFilter("bodysystem", "in", systemIds).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber());
        List orgMemberIdList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])sysFilter.toArray(), null, (int)-1);
        List<Long> orgMemberIds = orgMemberIdList.stream().map(o -> (Long)o).collect(Collectors.toList());
        systemIds.addAll(userAuthByBizType.getSystemIds());
        orgMemberIds.addAll(userAuthByBizType.getOrgIds());
        systemIds = systemIds.stream().distinct().collect(Collectors.toList());
        orgMemberIds = orgMemberIds.stream().distinct().collect(Collectors.toList());
        result.setSystemIds(systemIds);
        result.setOrgIds(orgMemberIds);
        result.setHasAllOrgPerm(userAuthByBizType.isHasAllOrgPerm());
        return result;
    }

    private static UserAuthModel loadAuthScopeBySystemId(String appId, String entityId, Long systemId) {
        UserAuthModel result = new UserAuthModel();
        List<Long> systemIds = ModelHelper.getAuthModelId();
        if (!systemIds.contains(systemId)) {
            return result;
        }
        QFilter sysFilter = new QFilter("bodysystem", "=", (Object)systemId).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber());
        List orgMemberIdList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])sysFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)orgMemberIdList)) {
            return result;
        }
        List<Long> orgIdList = orgMemberIdList.stream().map(i -> Long.parseLong(i.toString())).collect(Collectors.toList());
        UserAuthModel userAuthByBizType = ModelHelper.loadAuthScopeBySystemBizType(appId, entityId);
        if (!userAuthByBizType.isHasAllOrgPerm()) {
            List<Long> orgIds = userAuthByBizType.getOrgIds();
            orgIdList.retainAll(orgIds);
        }
        result.setSystemIds(Collections.singletonList(systemId));
        result.setOrgIds(orgIdList);
        result.setHasAllOrgPerm(userAuthByBizType.isHasAllOrgPerm());
        return result;
    }

    public static UserAuthModel loadAuthScopeBySystemBizType(String appId, String entityId) {
        QFilter enableFilter = new QFilter("bodysystem.enable", "=", (Object)"1");
        enableFilter.and("basedata", "=", (Object)DimsionEnums.ORG.getNumber());
        String prop = String.join((CharSequence)",", "basedatabiz", "bodysystem.id");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_dimension", (String)prop, (QFilter[])new QFilter[]{enableFilter});
        Map<String, List<DynamicObject>> bizTypeSystemIdGroup = query.stream().collect(Collectors.groupingBy(i -> i.getString("basedatabiz")));
        int bizTypeSize = bizTypeSystemIdGroup.size();
        if (bizTypeSize == 1) {
            String bizType = bizTypeSystemIdGroup.entrySet().iterator().next().getKey();
            return ModelHelper.getAuthByBizType(appId, entityId, bizType);
        }
        if (bizTypeSize == 2) {
            HashSet systemIdSet = new HashSet(8);
            HashSet orgIdSet = new HashSet(16);
            UserAuthModel model = new UserAuthModel();
            for (String bizType : bizTypeSystemIdGroup.keySet()) {
                UserAuthModel authModel = ModelHelper.getAuthByBizType(appId, entityId, bizType);
                List<List<Long>> authScope = authModel.getAuthScope();
                if (CollectionUtils.isEmpty(authScope)) continue;
                for (int i2 = 0; i2 < authScope.size(); ++i2) {
                    if (i2 == 0) {
                        systemIdSet.addAll(authScope.get(i2));
                    }
                    if (i2 != 1) continue;
                    orgIdSet.addAll(authScope.get(i2));
                }
            }
            model.setSystemIds(new ArrayList<Long>(systemIdSet));
            model.setOrgIds(new ArrayList<Long>(orgIdSet));
            return model;
        }
        UserAuthModel userAuthModel = ModelHelper.getAuthByBizType(appId, entityId, null);
        String adminBizType = Integer.valueOf("01").toString();
        boolean hasAdminAuth = bizTypeSystemIdGroup.containsKey(adminBizType);
        if (hasAdminAuth) {
            List<Long> systemIds = userAuthModel.getSystemIds();
            List<Long> orgIds = userAuthModel.getOrgIds();
            UserAuthModel authModel = ModelHelper.getAuthByBizType(appId, entityId, "01");
            if (!CollectionUtils.isEmpty(authModel.getSystemIds())) {
                systemIds.addAll(authModel.getSystemIds());
                systemIds = systemIds.stream().distinct().collect(Collectors.toList());
                userAuthModel.setSystemIds(systemIds);
            }
            if (!CollectionUtils.isEmpty(authModel.getOrgIds())) {
                orgIds.addAll(authModel.getOrgIds());
                orgIds = orgIds.stream().distinct().collect(Collectors.toList());
                userAuthModel.setOrgIds(orgIds);
            }
        }
        return userAuthModel;
    }

    private static UserAuthModel getAuthByBizType(String appId, String entityId, String bizType) {
        UserAuthModel model = new UserAuthModel();
        if (bizType != null && bizType.length() == 1) {
            bizType = "0" + bizType;
        }
        HasPermOrgResult userPermOrgResult = ModelHelper.getUserPermOrgResult(RequestContext.get().getCurrUserId(), bizType, appId, entityId, "47150e89000000ac");
        model.setHasAllOrgPerm(userPermOrgResult.hasAllOrgPerm());
        if (userPermOrgResult.hasAllOrgPerm()) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber());
            filter.and("bodysystem.enable", "=", (Object)"1");
            DynamicObjectCollection orgMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,bodysystem", (QFilter[])new QFilter[]{filter});
            List<Long> systemIds = orgMemberColl.stream().map(item -> item.getLong("bodysystem")).distinct().collect(Collectors.toList());
            List<Long> orgMemberIds = orgMemberColl.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            model.setSystemIds(systemIds);
            model.setOrgIds(orgMemberIds);
            return model;
        }
        List orgIdList = userPermOrgResult.getHasPermOrgs();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("id", "in", (Object)orgIdList));
        List orgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])filter.toArray(), null, (int)-1);
        List sourceIdList = orgIds.stream().map(o -> (Long)o).collect(Collectors.toList());
        QFilter qFilter = new QFilter("sourceid", "in", sourceIdList).and("bodysystem.enable", "=", (Object)"1").and("enable", "=", (Object)"1").and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber());
        DynamicObjectCollection orgMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,bodysystem", (QFilter[])new QFilter[]{qFilter});
        List<Long> systemIds = orgMemberColl.stream().map(item -> item.getLong("bodysystem")).distinct().collect(Collectors.toList());
        List<Long> orgMemberIds = orgMemberColl.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        model.setSystemIds(systemIds);
        model.setOrgIds(orgMemberIds);
        return model;
    }

    public static Pair<Boolean, String> reReportTypeEnableValidator(List<DynamicObject> dataList) {
        for (DynamicObject dy : dataList) {
            if (dy.getBoolean("rerporttype.enable")) continue;
            Object name = dy.get("rerporttype.name");
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u7f16\u62a5\u7c7b\u578b\u201c%1$s\u201d\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u7981\u7528\u3002", (String)"ModelHelper_0", (String)"tmc-fpm-common", (Object[])new Object[0]), name));
        }
        return Pair.of((Object)Boolean.TRUE, null);
    }

    public static Pair<Boolean, String> reReportTypeDisableValidator(Object bodysystem, List<DynamicObject> dataList) {
        Date nowDate = new Date();
        for (DynamicObject selected : dataList) {
            DynamicObject rerporttype = selected.getDynamicObject("rerporttype");
            if (rerporttype == null) continue;
            if ("disable".equals(selected.getString("rereporttypestatus"))) {
                return Pair.of((Object)Boolean.TRUE, null);
            }
            QFilter tQFilter = new QFilter("bodysys", "=", bodysystem);
            tQFilter.and("declarestartdate", "<=", (Object)nowDate);
            tQFilter.and("declaredeadline", ">=", (Object)nowDate);
            tQFilter.and("reportperiod.reporttype", "=", rerporttype.getPkValue());
            DynamicObject reportperiod = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"reportperiod", (QFilter[])new QFilter[]{tQFilter});
            if (reportperiod == null) continue;
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5df2\u5f00\u542f\u7533\u62a5\uff0c\u6682\u4e0d\u53ef\u8fdb\u884c\u7981\u7528\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"ModelHelper_1", (String)"tmc-fpm-common", (Object[])new Object[0]), rerporttype.getString("name"), reportperiod.getString("reportperiod.name")));
        }
        return Pair.of((Object)Boolean.TRUE, null);
    }

    @Deprecated
    public static Boolean reReportTypeOpenValidator(List<DynamicObject> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return Boolean.TRUE;
        }
        List enableList = dataList.stream().filter(i -> "enable".equals(i.get("rereporttypestatus"))).collect(Collectors.toList());
        if (enableList.size() > 0) {
            // empty if block
        }
        return Boolean.TRUE;
    }

    @Deprecated
    public static Boolean reReportTypeCloseValidator(List<DynamicObject> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return Boolean.TRUE;
        }
        List enableList = dataList.stream().filter(i -> "enable".equals(i.get("rereporttypestatus"))).collect(Collectors.toList());
        if (enableList.size() > 0) {
            // empty if block
        }
        return Boolean.TRUE;
    }

    @Deprecated
    public static List<Long> getAuthorizedOrgAndViewType(Long userID, String appId, String entityID, String permissionItem) {
        return ModelHelper.getAuthorizedOrgAndViewType(userID, appId, entityID, permissionItem, null);
    }

    @Deprecated
    public static List<Long> getAuthorizedOrgAndViewType(Long userID, String appId, String entityID, String permissionItem, List<Long> includeOrgIds) {
        List<Long> orgIdListByViewType;
        List<Long> orgIdList = ModelHelper.getCacheUserPermission(userID, null, appId, entityID, permissionItem);
        if (ModelHelper.existsBizBodySystem() && !EmptyUtil.isEmpty(orgIdListByViewType = ModelHelper.getCacheUserPermission(userID, "01", appId, entityID, permissionItem))) {
            if (orgIdList != null) {
                orgIdList.addAll(orgIdListByViewType);
            } else {
                orgIdList = orgIdListByViewType;
            }
        }
        if (!EmptyUtil.isEmpty(includeOrgIds)) {
            if (orgIdList != null) {
                orgIdList.addAll(includeOrgIds);
            } else {
                orgIdList = includeOrgIds;
            }
        }
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (orgIdList != null) {
            filter = filter.and(new QFilter("id", "in", orgIdList));
        }
        List orgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])filter.toArray(), null, (int)-1);
        return orgIds.stream().map(o -> (Long)o).collect(Collectors.toList());
    }

    @Deprecated
    private static List<Long> getCacheUserPermission(Long userId, String orgViewType, String appId, String entityId, String permItem) {
        logger.info("\u6267\u884c\u7ec4\u7ec7\u5e2e\u52a9\u7c7bgetCacheUserPermission\uff0cuserId=" + userId + ",orgViewType=" + orgViewType + ",appId=" + appId + ",entityId=" + entityId + ",permItem=" + permItem);
        if (EmptyUtil.isNoEmpty((String)appId)) {
            appId = AppMetadataCache.getAppInfo((String)appId).getId();
        }
        HasPermOrgResult result = StringUtils.isEmpty((CharSequence)orgViewType) ? PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityId, (String)permItem) : PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityId, (String)permItem);
        return result.hasAllOrgPerm() ? null : result.getHasPermOrgs();
    }

    private static HasPermOrgResult getUserPermOrgResult(Long userId, String orgViewType, String appId, String entityId, String permItem) {
        logger.info("\u6267\u884c\u7ec4\u7ec7\u5e2e\u52a9\u7c7bgetCacheUserPermission\uff0cuserId=" + userId + ",orgViewType=" + orgViewType + ",appId=" + appId + ",entityId=" + entityId + ",permItem=" + permItem);
        if (EmptyUtil.isNoEmpty((String)appId)) {
            appId = AppMetadataCache.getAppInfo((String)appId).getId();
        }
        HasPermOrgResult result = StringUtils.isEmpty((CharSequence)orgViewType) ? PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityId, (String)permItem) : PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityId, (String)permItem);
        return result;
    }

    public static boolean existsBizBodySystem() {
        QFilter tQFilter = new QFilter("fnumber", "=", (Object)"01");
        DynamicObject bos_org_biz = QueryServiceHelper.queryOne((String)"bos_org_biz", (String)"id", (QFilter[])new QFilter[]{tQFilter});
        if (bos_org_biz != null && bos_org_biz.getLong("id") != 0L) {
            tQFilter = new QFilter("basedata", "=", (Object)"Org");
            tQFilter.and("basedatabiz", "=", (Object)bos_org_biz.getLong("id"));
            return QueryServiceHelper.exists((String)"fpm_dimension", (QFilter[])new QFilter[]{tQFilter});
        }
        return false;
    }
}

