/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.result.ReferenceResult;

public class ReferenceServiceHelper {
    public static List<ReferenceResult> bodySysReference(List<Long> bodySysIdList, Boolean needDetailObj) {
        List<ReferenceResult> referenceResults = ReferenceServiceHelper.bodySysReference(bodySysIdList);
        if (needDetailObj.booleanValue()) {
            for (ReferenceResult referenceResult : referenceResults) {
                Map<String, List<Object>> objIdMap = referenceResult.getReferenceObjIdMap();
                HashMap<String, List<DynamicObject>> referenceObjMap = new HashMap<String, List<DynamicObject>>(objIdMap.size());
                for (Map.Entry<String, List<Object>> entry : objIdMap.entrySet()) {
                    String entityNumber = entry.getKey();
                    DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((Object[])entry.getValue().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
                    referenceObjMap.put(entityNumber, Arrays.stream(dynamicObjects).collect(Collectors.toList()));
                }
                referenceResult.setReferenceObjMap(referenceObjMap);
            }
        }
        return referenceResults;
    }

    public static List<ReferenceResult> bodySysReference(List<Long> bodySysIdList) {
        ArrayList<ReferenceResult> result = new ArrayList<ReferenceResult>(10);
        DynamicObjectCollection dimColl = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,bodysystem.id", (QFilter[])new QFilter[]{new QFilter("bodysystem.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> dimensionMap = dimColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysystem.id")));
        DynamicObjectCollection memberColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,bodysystem.id,dimtype", (QFilter[])new QFilter[]{new QFilter("bodysystem.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> dimensionMemberMap = memberColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysystem.id")));
        DynamicObjectCollection detailFieldsColl = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)"id,bodysys.id", (QFilter[])new QFilter[]{new QFilter("bodysys.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> detailFieldMap = detailFieldsColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysys.id")));
        DynamicObjectCollection dimensionMapColl = QueryServiceHelper.query((String)"fpm_dimensionmember", (String)"id,bodysysmanage.id", (QFilter[])new QFilter[]{new QFilter("bodysysmanage.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> dimensionMappingMap = dimensionMapColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysysmanage.id")));
        DynamicObjectCollection templateColl = QueryServiceHelper.query((String)"fpm_template", (String)"id,model.id", (QFilter[])new QFilter[]{new QFilter("model.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> reportTemplateMap = templateColl.stream().collect(Collectors.groupingBy(i -> i.getLong("model.id")));
        DynamicObjectCollection reportPreparationColl = QueryServiceHelper.query((String)"fpm_reportpreparation", (String)"id,bodysysmanage.id", (QFilter[])new QFilter[]{new QFilter("bodysysmanage.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> preparationMap = reportPreparationColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysysmanage.id")));
        String selectFields = String.join((CharSequence)",", "id", "bodysys.id");
        DynamicObjectCollection matchRuleColl = QueryServiceHelper.query((String)"fpm_matchrule", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bodysys.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> execMatchRuleMap = matchRuleColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysys.id")));
        DynamicObjectCollection auxiliaryFieldColl = QueryServiceHelper.query((String)"fpm_auxiliaryfields", (String)"id,bodysys.id", (QFilter[])new QFilter[]{new QFilter("bodysys.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> auxiliaryFieldMap = auxiliaryFieldColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysys.id")));
        DynamicObjectCollection inspectionConfigColl = QueryServiceHelper.query((String)"fpm_inspection_config", (String)"id,bodysys.id", (QFilter[])new QFilter[]{new QFilter("bodysys.id", "in", bodySysIdList)});
        Map<Long, List<DynamicObject>> inspectionConfigMap = inspectionConfigColl.stream().collect(Collectors.groupingBy(i -> i.getLong("bodysys.id")));
        for (Long modelId : bodySysIdList) {
            List<DynamicObject> inspectionConfigDataList;
            List<DynamicObject> matchRuleDataList;
            List<DynamicObject> auxiliaryDataList;
            List<DynamicObject> detailFieldDataList;
            List<DynamicObject> dimMemberDataList;
            List<DynamicObject> dimDataList;
            List<DynamicObject> dimensionMapDataList;
            List<DynamicObject> reportPreparationDataList;
            ReferenceResult referenceResult = new ReferenceResult();
            referenceResult.setSourceId(modelId);
            LinkedHashMap<String, List<Object>> referenceObjIdMap2 = new LinkedHashMap<String, List<Object>>(10);
            List<DynamicObject> templateDataList = reportTemplateMap.get(modelId);
            if (EmptyUtil.isNoEmpty(templateDataList)) {
                referenceObjIdMap2.put("fpm_template", templateDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty(reportPreparationDataList = preparationMap.get(modelId))) {
                referenceObjIdMap2.put("fpm_reportpreparation", reportPreparationDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty(dimensionMapDataList = dimensionMappingMap.get(modelId))) {
                referenceObjIdMap2.put("fpm_dimensionmember", dimensionMapDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty(dimDataList = dimensionMap.get(modelId))) {
                referenceObjIdMap2.put("fpm_dimension", dimDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty(dimMemberDataList = dimensionMemberMap.get(modelId))) {
                Map<String, List<DynamicObject>> dimMemberTypeMap = dimMemberDataList.stream().collect(Collectors.groupingBy(i -> i.getString("dimtype")));
                for (Map.Entry<String, List<DynamicObject>> next : dimMemberTypeMap.entrySet()) {
                    String key = next.getKey();
                    List<DynamicObject> typeDataList = next.getValue();
                    List list = referenceObjIdMap2.computeIfAbsent(DimsionEnums.getDimsionByNumber(key).getMetadata(), k -> new ArrayList(16));
                    list.addAll(typeDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
                }
            }
            if (EmptyUtil.isNoEmpty(detailFieldDataList = detailFieldMap.get(modelId))) {
                referenceObjIdMap2.put("fpm_detailplanfields", detailFieldDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty(auxiliaryDataList = auxiliaryFieldMap.get(modelId))) {
                referenceObjIdMap2.put("fpm_auxiliaryfields", auxiliaryDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty(matchRuleDataList = execMatchRuleMap.get(modelId))) {
                referenceObjIdMap2.put("fpm_matchrule", matchRuleDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            if (EmptyUtil.isNoEmpty(inspectionConfigDataList = inspectionConfigMap.get(modelId))) {
                referenceObjIdMap2.put("fpm_inspection_config", inspectionConfigDataList.stream().map(e -> e.get("id")).collect(Collectors.toList()));
            }
            referenceResult.setReferenceObjIdMap(referenceObjIdMap2);
            result.add(referenceResult);
        }
        return result;
    }
}

