/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.DetailDimTypeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateMetricTypeEnum;

public class ReportDataFieldHelper {
    public static final Map<String, String> MAINDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>();
    public static final Map<String, String> DETAILDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>();
    public static final Map<String, String> TYPE_MAPPING_MAP = new HashMap<String, String>();
    public static final Map<String, String> METRIC_MAPPING_MAP = new HashMap<String, String>();
    public static final Map<String, List<String>> REDUNDANT_FIELD_MAPPING_MAP = new HashMap<String, List<String>>();

    public static String getMainPropByDimensionNumber(String number) {
        return MAINDIM_ENTRY_MAPPING_MAP.get(number);
    }

    public static Map<String, List<String>> mainPropMapByDimensionNumbers(List<String> numberList) {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>(numberList.size());
        int index = 0;
        for (String number : numberList) {
            String prop = MAINDIM_ENTRY_MAPPING_MAP.get(number);
            if (StringUtils.isEmpty((Object)prop)) continue;
            if (DimsionEnums.CUSTOM.getNumber().equals(number)) {
                String[] split = prop.split(",");
                props.computeIfAbsent(number, k -> new ArrayList());
                int finalIndex = index++;
                props.computeIfPresent(number, (k, v) -> {
                    v.add(split[finalIndex]);
                    return v;
                });
                continue;
            }
            props.put(number, Collections.singletonList(prop));
        }
        return props;
    }

    public static String getMetricPropByMetricNumber(String number) {
        return METRIC_MAPPING_MAP.get(number);
    }

    private static <E> ArrayList<E> newArrayList(E ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    static {
        MAINDIM_ENTRY_MAPPING_MAP.put(DimsionEnums.ORG.getNumber(), String.join((CharSequence)".", "maindimentry", "orgmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimsionEnums.CURRENCY.getNumber(), String.join((CharSequence)".", "maindimentry", "currencymem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimsionEnums.PERIOD.getNumber(), String.join((CharSequence)".", "maindimentry", "periodmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimsionEnums.SUBJECT.getNumber(), String.join((CharSequence)".", "maindimentry", "subjectmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimsionEnums.COMPANY.getNumber(), String.join((CharSequence)".", "maindimentry", "companymem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimsionEnums.SETLTMENT.getNumber(), String.join((CharSequence)".", "maindimentry", "settletypemem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimsionEnums.CUSTOM.getNumber(), String.join((CharSequence)",", String.join((CharSequence)".", "maindimentry", "extmem1"), String.join((CharSequence)".", "maindimentry", "extmem2"), String.join((CharSequence)".", "maindimentry", "extmem3")));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.CONNTERPARTY_TYPE.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "opusertype"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.COUNTERPARTY_NAME.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "opusername"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.BANK_CATE.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "bankcate"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.CONTRACT_NO.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "contractno"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.CONTRACT_NAME.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "contractname"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.PLAN_DATE.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "plandate"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.BANK_ACCOUNT.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "bankaccount"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.BUSINESS_PARTNER.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "businesspartner"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_1.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext1"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_2.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext2"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_3.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext3"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_4.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext4"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_5.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext5"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_6.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext6"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_7.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext7"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimTypeEnum.EXTRA_8.getValue().toLowerCase(), String.join((CharSequence)".", "detailentry", "detailext8"));
        TYPE_MAPPING_MAP.putAll(MAINDIM_ENTRY_MAPPING_MAP);
        TYPE_MAPPING_MAP.putAll(DETAILDIM_ENTRY_MAPPING_MAP);
        METRIC_MAPPING_MAP.put(TemplateMetricTypeEnum.PLANAMT.getCode(), String.join((CharSequence)".", "maindimentry", "planamt"));
        METRIC_MAPPING_MAP.put(TemplateMetricTypeEnum.LOCKAMT.getCode(), String.join((CharSequence)".", "maindimentry", "lockamt"));
        METRIC_MAPPING_MAP.put(TemplateMetricTypeEnum.ORIGINALPLANAMT.getCode(), String.join((CharSequence)".", "maindimentry", "orgplanamt"));
        METRIC_MAPPING_MAP.put(TemplateMetricTypeEnum.ACTMAT.getCode(), String.join((CharSequence)".", "maindimentry", "realamt"));
        METRIC_MAPPING_MAP.put(TemplateMetricTypeEnum.PLANREFERENCEAMT.getCode(), String.join((CharSequence)".", "maindimentry", "planreferenceamt"));
        METRIC_MAPPING_MAP.put(TemplateMetricTypeEnum.REPORTPLANAMT.getCode(), String.join((CharSequence)".", "maindimentry", "reportplanamt"));
        METRIC_MAPPING_MAP.put("offsetMetric", String.join((CharSequence)".", "maindimentry", "offsetamt"));
        REDUNDANT_FIELD_MAPPING_MAP.put("effectflag", ReportDataFieldHelper.newArrayList("0", "1"));
        REDUNDANT_FIELD_MAPPING_MAP.put("maintable", ReportDataFieldHelper.newArrayList("0", "1"));
        REDUNDANT_FIELD_MAPPING_MAP.put("amountunit", Arrays.stream(AmountUnitEnum.values()).map(AmountUnitEnum::getValue).collect(Collectors.toList()));
    }
}

