/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.helper;

import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class StringHelper {
    private static final String[] DELIMITERS = new String[]{";", ",", "_", " ", "-"};

    public static String subString(String str, int maxLength) {
        return StringHelper.subString(str, maxLength, DELIMITERS);
    }

    public static String subString(String str, int maxLength, String ... delimiters) {
        if (StringUtils.isBlank((CharSequence)str) || str.length() <= maxLength) {
            return str;
        }
        for (String delimiter : delimiters) {
            String[] split = str.split(delimiter);
            if (split.length == 1) continue;
            StringBuilder sb = new StringBuilder();
            for (String sn : split) {
                if (sb.length() + sn.length() > maxLength) {
                    sb.delete(sb.length() - delimiter.length(), sb.length());
                    return sb.toString();
                }
                sb.append(sn).append(delimiter);
            }
        }
        return str.substring(0, maxLength);
    }

    public static String subStringAppendThreePoint(String str, int maxLength) {
        if (StringUtils.isBlank((CharSequence)str) || str.length() <= maxLength) {
            return str;
        }
        str = str.substring(0, maxLength);
        str = str + "...";
        return str;
    }

    public static Object trimIfString(Object obj) {
        if (Objects.isNull(obj)) {
            return "";
        }
        if (String.class.isInstance(obj)) {
            String str = (String)obj;
            return str.trim();
        }
        return obj;
    }

    public static String getStringValue(Object value) {
        return StringHelper.trimIfString(value).toString();
    }

    public static String[] split(String str, String ... delimiters) {
        if (EmptyUtil.isEmpty((String)str)) {
            return new String[0];
        }
        if (delimiters == null || delimiters.length == 0) {
            delimiters = DELIMITERS;
        }
        for (String delimiter : delimiters) {
            if (!str.contains(delimiter)) continue;
            return str.split(delimiter);
        }
        return new String[]{str};
    }
}

