/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.trace.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTraceSpanPrinter;
import kd.tmc.fpm.common.trace.Tick;

public class FpmTracePrinter
implements IFpmTraceSpanPrinter {
    private static Log logger = LogFactory.getLog(FpmTracePrinter.class);
    private long totalTimeMs;
    private StringBuilder contentBuilder;

    @Override
    public void print(List<IFpmTraceSpan> spanList) {
        try {
            this.contentBuilder = new StringBuilder();
            HashMap<IFpmTraceSpan, TraceSpanWrap> wrapMap = new HashMap<IFpmTraceSpan, TraceSpanWrap>(spanList.size());
            LinkedList<TraceSpanWrap> firstLevelSpanWrapList = new LinkedList<TraceSpanWrap>();
            TraceSpanWrap rootWrap = null;
            for (IFpmTraceSpan span : spanList) {
                TraceSpanWrap wrap = wrapMap.computeIfAbsent(span, o -> new TraceSpanWrap(span));
                if (!span.isRoot()) {
                    IFpmTraceSpan parent = span.getParent();
                    TraceSpanWrap pWrap = (TraceSpanWrap)wrapMap.get(parent);
                    if (pWrap == null) {
                        pWrap = new TraceSpanWrap(parent);
                        wrapMap.put(parent, pWrap);
                    }
                    pWrap.children.add(wrap);
                    if (parent.isRoot()) {
                        firstLevelSpanWrapList.add(wrap);
                    }
                } else {
                    if (rootWrap != null) {
                        throw new IllegalArgumentException("The spanList contains more than one root.");
                    }
                    rootWrap = wrap;
                }
                wrapMap.put(span, wrap);
            }
            if (rootWrap == null) {
                throw new IllegalArgumentException("The spanList has no root.");
            }
            rootWrap.children = firstLevelSpanWrapList;
            this.totalTimeMs = rootWrap.children.stream().mapToLong(o -> o.span.getTotalCost()).sum() / 1000L / 1000L;
            this.buildPrintContent(null, rootWrap, -1);
            this.printContent(this.contentBuilder.toString());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void buildPrintContent(TraceSpanWrap pSpan, TraceSpanWrap span, int level) {
        if (span.span.isRoot() && span.children.size() == 0) {
            return;
        }
        IFpmTraceSpan innerSpan = span.span;
        if (span.span.isRoot()) {
            String runtime = ResManager.loadKDString((String)"----------------\u603b\u8fd0\u884c\u65f6\u95f4: %1$s ms----------------", (String)"FpmTracePrinter_0", (String)"tmc-fpm-common", (Object[])new Object[0]);
            this.contentBuilder.append('\n').append(String.format(runtime, this.totalTimeMs)).append('\n');
            String logHeader = ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u95f4(ms)\t\t\u8fd0\u884c\u6b21\u6570\t\t\u8017\u65f6\u6bd4\u4f8b\t\t\u5c42\u7ea7\t\t\u4efb\u52a1\u540d", (String)"FpmTracePrinter_1", (String)"tmc-fpm-common", (Object[])new Object[0]);
            this.contentBuilder.append(logHeader).append('\n');
        } else {
            long currTotalCostMs = span.span.getTotalCost() / 1000L / 1000L;
            int currTotalPercent = this.totalTimeMs == 0L ? 100 : (int)(currTotalCostMs * 100L / this.totalTimeMs);
            this.contentBuilder.append("[Name: ").append(span.span.getName()).append(", pName: ").append(pSpan.span.getName()).append(", total cost: ").append(currTotalCostMs).append("ms(").append(currTotalPercent).append("%)]").append('\n');
            Map<String, Tick> costMap = innerSpan.getTickInfo();
            if (!costMap.isEmpty()) {
                costMap.entrySet().stream().sorted((o1, o2) -> Long.compare(((Tick)o2.getValue()).getCostMs(), ((Tick)o1.getValue()).getCostMs())).forEach(entry -> {
                    String taskName = (String)entry.getKey();
                    Long cost = ((Tick)entry.getValue()).getCostMs();
                    Long count = ((Tick)entry.getValue()).getCnt();
                    int timePercent = this.totalTimeMs == 0L ? 100 : (int)((double)cost.longValue() * 100.0 / (double)this.totalTimeMs);
                    this.contentBuilder.append(String.format("%010d\t\t%06d\t\t%02d%%\t\t\t%d\t\t%s", cost, count, timePercent, level, taskName)).append('\n');
                });
            }
        }
        for (TraceSpanWrap child : span.children) {
            this.buildPrintContent(span, child, level + 1);
        }
    }

    private void printContent(String content) {
        logger.info(content);
    }

    private static class TraceSpanWrap {
        IFpmTraceSpan span;
        List<TraceSpanWrap> children = new LinkedList<TraceSpanWrap>();

        TraceSpanWrap(IFpmTraceSpan span) {
            this.span = span;
        }
    }
}

