/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.trace.impl;

import java.util.LinkedList;
import java.util.List;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTraceSpanPrinter;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.trace.impl.FpmTraceSpan;
import kd.tmc.fpm.common.trace.impl.FpmTraceSpanEmpty;
import kd.tmc.fpm.common.trace.impl.FpmTraceSpanRoot;

public class FpmTracer
implements IFpmTracer {
    private static final ThreadLocal<FpmTracer> CUR = new ThreadLocal();
    private FpmTraceSpanRoot root;
    private List<IFpmTraceSpan> spanList = new LinkedList<IFpmTraceSpan>();

    public static FpmTracer get() {
        FpmTracer instance = CUR.get();
        if (instance == null) {
            instance = new FpmTracer();
            CUR.set(instance);
        }
        return instance;
    }

    @Override
    public void close() {
        CUR.set(null);
        this.spanList.clear();
    }

    @Override
    public IFpmTraceSpan createSpan(String name) {
        if (!this.enable()) {
            return FpmTraceSpanEmpty.getInstance();
        }
        if (this.root == null) {
            this.root = new FpmTraceSpanRoot(this);
        }
        FpmTraceSpan span = new FpmTraceSpan(this, name);
        return span;
    }

    @Override
    public void report(IFpmTraceSpan span) {
        if (!this.enable()) {
            return;
        }
        this.spanList.add(span);
    }

    @Override
    public void print() {
        if (!this.enable()) {
            return;
        }
        IFpmTraceSpanPrinter printer = IFpmTraceSpanPrinter.getInstance();
        printer.print(this.spanList);
    }

    @Override
    public boolean enable() {
        try {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

