/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.common.enums.AmountUnitEnum;

public class AmountUtil {
    public static BigDecimal convert(AmountUnitEnum sourceUnit, AmountUnitEnum targetUnit, BigDecimal amount) {
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        BigDecimal oneAmount = null;
        if (sourceUnit == AmountUnitEnum.ONE) {
            oneAmount = amount;
        } else if (sourceUnit == AmountUnitEnum.THOUSAND) {
            oneAmount = amount.multiply(new BigDecimal("1000"));
        } else if (sourceUnit == AmountUnitEnum.TEN_THOUSAND) {
            oneAmount = amount.multiply(new BigDecimal("10000"));
        } else if (sourceUnit == AmountUnitEnum.MILLION) {
            oneAmount = amount.multiply(new BigDecimal("1000000"));
        } else if (sourceUnit == AmountUnitEnum.HUNDRED_MILLION) {
            oneAmount = amount.multiply(new BigDecimal("100000000"));
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d\u9519\u8bef", (String)"AmountUtil_0", (String)"tmc-fpm-common", (Object[])new Object[0]));
        }
        BigDecimal result = null;
        BigDecimal convertScale = BigDecimal.ONE;
        if (targetUnit == AmountUnitEnum.ONE) {
            result = oneAmount;
        } else if (targetUnit == AmountUnitEnum.THOUSAND) {
            convertScale = convertScale.divide(new BigDecimal("1000"), 12, RoundingMode.HALF_EVEN);
            result = oneAmount.multiply(convertScale);
        } else if (targetUnit == AmountUnitEnum.TEN_THOUSAND) {
            convertScale = convertScale.divide(new BigDecimal("10000"), 12, RoundingMode.HALF_EVEN);
            result = oneAmount.multiply(convertScale);
        } else if (targetUnit == AmountUnitEnum.MILLION) {
            convertScale = convertScale.divide(new BigDecimal("1000000"), 12, RoundingMode.HALF_EVEN);
            result = oneAmount.multiply(convertScale);
        } else if (targetUnit == AmountUnitEnum.HUNDRED_MILLION) {
            convertScale = convertScale.divide(new BigDecimal("100000000"), 12, RoundingMode.HALF_EVEN);
            result = oneAmount.multiply(convertScale);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d\u9519\u8bef", (String)"AmountUtil_1", (String)"tmc-fpm-common", (Object[])new Object[0]));
        }
        return result;
    }
}

