/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.utils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.common.annotation.DispersionAnalysisAnnotation;
import kd.tmc.fpm.common.model.DispersionAnalysisModel;

public class DispersionAnalysisUtils {
    private static Log logger = LogFactory.getLog(DispersionAnalysisUtils.class);

    public static <T> List<Field> getDispersionAnalysisAnnoFields(Class<T> clazz, boolean isCompare) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> fieldLst = new ArrayList<Field>(10);
        for (Field field : fields) {
            DispersionAnalysisAnnotation dispersionAnalysisAnno;
            boolean compare;
            boolean existDispersionAnalysisAnno = field.isAnnotationPresent(DispersionAnalysisAnnotation.class);
            if (!existDispersionAnalysisAnno || isCompare != (compare = (dispersionAnalysisAnno = field.getAnnotation(DispersionAnalysisAnnotation.class)).compare())) continue;
            fieldLst.add(field);
        }
        return fieldLst;
    }

    public static <T> Boolean isChange(T oldBean, T newBean) {
        boolean isChange = Boolean.FALSE;
        try {
            List<Field> fields = DispersionAnalysisUtils.getDispersionAnalysisAnnoFields(oldBean.getClass(), true);
            for (Field field : fields) {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), oldBean.getClass());
                Method readMethod = pd.getReadMethod();
                Object newValue = readMethod.invoke(newBean, new Object[0]);
                Object oldValue = readMethod.invoke(oldBean, new Object[0]);
                if (newValue == null && oldValue == null) continue;
                if (newValue == null && oldValue != null || newValue != null && oldValue == null) {
                    isChange = Boolean.TRUE;
                } else {
                    if (newValue.toString().equals(oldValue.toString())) continue;
                    isChange = Boolean.TRUE;
                }
                break;
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage());
        }
        return isChange;
    }

    public static <T> List<DispersionAnalysisModel<T>> dispersionAnalysis(T newBean, T oldBean) {
        ArrayList<DispersionAnalysisModel<T>> result = new ArrayList<DispersionAnalysisModel<T>>(10);
        try {
            List<Field> fields = DispersionAnalysisUtils.getDispersionAnalysisAnnoFields(oldBean.getClass(), true);
            for (Field field : fields) {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), oldBean.getClass());
                Method getMethod = pd.getReadMethod();
                Object newValue = getMethod.invoke(newBean, new Object[0]);
                Object oldValue = getMethod.invoke(oldBean, new Object[0]);
                if (newValue == null && oldValue == null) continue;
                if (newValue == null && oldValue != null || newValue != null && oldValue == null) {
                    result.add(new DispersionAnalysisModel<T>(field.getName(), oldValue, newValue, newBean, oldBean));
                    continue;
                }
                if (newValue.toString().equals(oldValue.toString())) continue;
                result.add(new DispersionAnalysisModel<T>(field.getName(), oldValue, newValue, newBean, oldBean));
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage());
        }
        return result;
    }
}

