/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.service;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.gm.common.enums.BizStatusEnum;

public class LetterGuaranteeWriteBackPayService
extends AbstractPayBillWriteBackService {
    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
        sourceBill.set("payeebillno", (Object)payBill.getPayBillNo());
        sourceBill.set("lockpayamt", (Object)payBill.getAmount());
        LetterGuaranteeWriteBackPayService.updateSourcebill(sourceBill);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
        sourceBill.set("payeebillno", (Object)payBill.getPayBillNo());
        sourceBill.set("lockpayamt", (Object)payBill.getAmount());
        LetterGuaranteeWriteBackPayService.updateSourcebill(sourceBill);
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        LetterGuaranteeWriteBackPayService.checkBillStatus(sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        LetterGuaranteeWriteBackPayService.checkBillStatus(sourceBill);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doChargebackExecute(param, sourceBill);
        sourceBill.set("payeebillno", (Object)" ");
        sourceBill.set("lockpayamt", (Object)BigDecimal.ZERO);
        LetterGuaranteeWriteBackPayService.updateSourcebill(sourceBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("payeebillno", (Object)" ");
        sourceBill.set("lockpayamt", (Object)BigDecimal.ZERO);
        LetterGuaranteeWriteBackPayService.updateSourcebill(sourceBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doRenoteExecute(param, sourceBill);
        sourceBill.set("payeebillno", (Object)" ");
        sourceBill.set("lockpayamt", (Object)BigDecimal.ZERO);
        LetterGuaranteeWriteBackPayService.updateSourcebill(sourceBill);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        if (EmptyUtil.isEmpty((Long)payBillInfo.getSourceBillId())) {
            return TmcBotpHelper.getSourceBill((String)"cas_paybill", (Object)payBillInfo.getPayBillId(), (String)"gm_letterofguarantee");
        }
        return TmcDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"gm_letterofguarantee", (String)"billno,payeebillno,lockpayamt,amount,currency,bizstatus");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("currency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("amount");
    }

    private static void checkBillStatus(DynamicObject sourceBill) {
        String bizStatus = sourceBill.getString("bizstatus");
        if (!BizStatusEnum.CLAIMED.getValue().equals(bizStatus)) {
            throw new KDBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u5f00\u51fd\u767b\u8bb0[%s]\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u7d22\u8d54\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7d22\u8d54\u4ed8\u6b3e\u3002", (String)"LetterGuaranteeWriteBackPayService_0", (String)"tmc-gm-mservice", (Object[])new Object[]{sourceBill.getString("billno")})});
        }
    }

    private static void updateSourcebill(DynamicObject sourceBill) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceBill});
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }
}

