/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;
import kd.tmc.gm.helper.GmReportHelper;

public class GuaranteeContractDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;
    private String groupString = null;
    private String orderString = null;
    private final List<QFilter> filterList = new ArrayList<QFilter>(12);
    private static final String GUARANTEECONTRACT_FIELDS = "id,billno,org,entry_guaranteeorg.a_guaranteeorg as guaranteeorg,entry_guaranteeorg.a_guaranteeorgtext as guaranteeorgtext,guaranteedorg,guaranteedorgtext,creditor,entry_guaranteeorg.a_guaranteetype as guaranteetype,creditortype,creditortext,guarantee,guarantee.name as guaranteetext,currency,currency.name currencytext,amount,entry_guaranteeorg.a_gratio as ratio,begindate,enddate,bizstatus,iscrossguarantee";
    private static final String GUARANTEEDCONTRACT_FIELDS = "id,billno,org,guaranteeorg,guaranteeorgtext,entry_guaranteedorg.b_guaranteedorg as guaranteedorg,entry_guaranteedorg.b_guaranteedorgtext as guaranteedorgtext,creditor,guaranteetype,creditortype,creditortext,guarantee,guarantee.name as guaranteetext,currency,currency.name currencytext,amount,entry_guaranteedorg.b_gratio as ratio,begindate,enddate,bizstatus,iscrossguarantee";
    private static final String TOTAL_FIELDS = "id,billno,org,guaranteeorg,creditor,guarantee,guaranteeorgtext,guaranteedorg,guaranteedorgtext,creditortext,currency,guaranteetext,currencytext,amount,dutyamount,begindate,enddate,case when to_date(to_char(date(),'yyyy-MM-dd'),'yyyy-MM-dd') > to_date(to_char(enddate,'yyyy-MM-dd'),'yyyy-MM-dd') and enddate is not null then 1 else 0 end delayed,case when bizstatus = 'closed' then 1 else 0 end closed";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        this.init(queryParam);
        DataSet billDataSet = this.queryBillData();
        if (billDataSet.copy().isEmpty()) {
            return billDataSet;
        }
        billDataSet = billDataSet.select(TOTAL_FIELDS);
        return billDataSet;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        return dataSet.addField(((DynamicObject)this.paramMap.get("filter_dutycurrency")).getString("id"), "dutycurrency");
    }

    public String sumNameField() {
        String dimension = (String)this.paramMap.get("filter_statdim");
        String[] split = dimension.split("_");
        return split[0] + "text";
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("amount", "dutyamount");
    }

    public List<String> groupFields() {
        return Arrays.stream(this.groupString.split(",")).collect(Collectors.toList());
    }

    public List<String> sumAmountFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("amount");
        fields.add("dutyamount");
        return fields;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    private DataSet queryBillData() {
        DataSet guaranteeContracts = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteecontract"), (String)"gm_guaranteecontract", (String)GUARANTEECONTRACT_FIELDS, (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString).distinct();
        if ("guaranteedorg".equals(this.paramMap.get("filter_statdim"))) {
            guaranteeContracts = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteecontract"), (String)"gm_guaranteecontract", (String)GUARANTEEDCONTRACT_FIELDS, (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString).distinct();
        }
        if (!guaranteeContracts.copy().isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>(16);
            for (Row guaranteeContract : guaranteeContracts.copy()) {
                ids.add(guaranteeContract.getLong("id"));
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("gsrcbilltype", "!=", (Object)"cfm_creditlimit"), new QFilter("gsrcbilltype", "!=", (Object)"creditm_limit_framework"), new QFilter("gcontract.id", "in", ids), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
            DataSet guaranteeUse = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteeuse"), (String)"gm_guaranteeuse", (String)"gcontract.id gcontractid,gdebtcurrency,case when gsrcbilltype in ('cfm_loanbill_b_l','cfm_loanbill_e_l','cim_invest_loanbill') then 'cfm_loanbill' else gsrcbilltype end as gsrcbilltype,gsrcbillid,gratio,gdebtbalance", (QFilter[])qFilters, null);
            Map<String, Set<Long>> guaranteeUseMap = this.getGuaranteeUseMap(guaranteeUse.copy());
            HashSet<Long> emptySet = new HashSet<Long>(16);
            DataSet letterOfGuaranteeDs = this.queryLetterOfGuaranteeDs(guaranteeUseMap.get("gm_letterofguarantee") == null ? emptySet : guaranteeUseMap.get("gm_letterofguarantee"));
            DataSet payableBillDs = this.queryPayableBillDs(guaranteeUseMap.get("cdm_payablebill") == null ? emptySet : guaranteeUseMap.get("cdm_payablebill"));
            DataSet letterCreditDs = this.queryLetterCreditDs(guaranteeUseMap.get("lc_lettercredit") == null ? emptySet : guaranteeUseMap.get("lc_lettercredit"));
            DataSet loanBillDs = this.queryLoanBillDs(guaranteeUseMap.get("cfm_loanbill") == null ? emptySet : guaranteeUseMap.get("cfm_loanbill"));
            DataSet debtRegisterDs = this.queryDebtRegister(guaranteeUseMap.get("gm_debt_register") == null ? emptySet : guaranteeUseMap.get("gm_debt_register"));
            DataSet leaseContractDs = this.queryLeaseContract(guaranteeUseMap.get("fl_receiptbill") == null ? emptySet : guaranteeUseMap.get("fl_receiptbill"));
            letterOfGuaranteeDs = letterOfGuaranteeDs.copy().union(new DataSet[]{payableBillDs, letterCreditDs, loanBillDs, debtRegisterDs, leaseContractDs});
            guaranteeUse = guaranteeUse.copy().leftJoin(letterOfGuaranteeDs).on("gsrcbillid", "id").on("gsrcbilltype", "billtype").select(new String[]{"gcontractid", "gdebtcurrency", "gsrcbilltype", "gsrcbillid", "gratio", "case when gsrcbilltype not in ('gm_letterofguarantee','cdm_payablebill','lc_lettercredit','cfm_loanbill','fl_receiptbill') or camount == null then gdebtbalance when gsrcbilltype='gm_debt_register' then camount else camount*gratio/100 end as gdebtbalance"}).finish();
            DataSet exchangeRateDataSet = this.getExchangeRateDataSet(guaranteeUse.copy());
            guaranteeUse = guaranteeUse.copy().join(exchangeRateDataSet).on("gdebtcurrency", "tarcurrency").select(new String[]{"gcontractid", "rate*gdebtbalance gdebtbalance"}).finish();
            DataSet guaranteeUseGroup = guaranteeUse.groupBy(new String[]{"gcontractid"}).sum("gdebtbalance").finish();
            RowMeta rowMeta = guaranteeContracts.getRowMeta();
            guaranteeContracts = guaranteeContracts.leftJoin(guaranteeUseGroup).on("id", "gcontractid").select(rowMeta.getFieldNames(), new String[]{"case when iscrossguarantee=true and guaranteeorg=org then 0 else gdebtbalance*ratio/100 end dutyamount"}).finish();
        }
        return guaranteeContracts;
    }

    private Map<String, Set<Long>> getGuaranteeUseMap(DataSet joinedDS) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        if (joinedDS.isEmpty()) {
            return map;
        }
        for (Row guaranteeUse : joinedDS.copy()) {
            String gSrcBillType = guaranteeUse.getString("gsrcbilltype");
            Long gSrcBillId = guaranteeUse.getLong("gsrcbillid");
            HashSet<Long> ids = (HashSet<Long>)map.get(gSrcBillType);
            if (ids == null) {
                ids = new HashSet<Long>(16);
            }
            ids.add(gSrcBillId);
            map.put(gSrcBillType, ids);
        }
        return map;
    }

    private DataSet queryLeaseContract(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("bizdate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "fl_receiptbill"), (String)"fl_receiptbill", (String)"'fl_receiptbill' as billtype,id,drawamount", (QFilter[])qFilters, null);
        HashSet<Long> flIds = new HashSet<Long>(16);
        for (Row receiptBill : dataSet.copy()) {
            flIds.add(receiptBill.getLong("id"));
        }
        QFilter[] rentPayFilters = new QFilter[]{new QFilter("loans.e_loanbill.id", "in", flIds), new QFilter("bizdate", "<=", (Object)filterCutOffDate), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
        DataSet rentPayDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "fl_rentpaybill"), (String)"fl_rentpaybill", (String)"id,loans.e_loanbill.id as loanbillid,loans.e_repayamount as repayamount", (QFilter[])rentPayFilters, null);
        DataSet rentPayGroupDs = rentPayDs.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        return dataSet.leftJoin(rentPayGroupDs).on("id", "loanbillid").select(new String[]{"billtype", "id", "drawamount-case when repayamount = null then 0 else repayamount end as camount"}).finish();
    }

    private DataSet queryDebtRegister(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("changetype", "=", (Object)DebtChangeTypeEnum.DEBT_OCCUPY.getValue()), new QFilter("begindate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_debt_register"), (String)"gm_debt_register", (String)"bindid,'gm_debt_register' as billtype,id,occupyamount", (QFilter[])qFilters, null);
        HashSet<String> debtIds = new HashSet<String>(16);
        for (Row debtRegister : dataSet.copy()) {
            debtIds.add(debtRegister.getString("bindid"));
        }
        QFilter[] releaseFilters = new QFilter[]{new QFilter("bindid", "in", debtIds), new QFilter("changetype", "=", (Object)DebtChangeTypeEnum.DEBT_RELEASE.getValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("registerdate", "<=", (Object)filterCutOffDate)};
        DataSet releaseDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_debt_register"), (String)"gm_debt_register", (String)"id,bindid,releaseamount", (QFilter[])releaseFilters, null);
        DataSet releaseGroupDs = releaseDataSet.groupBy(new String[]{"bindid"}).sum("releaseamount").finish();
        return dataSet.leftJoin(releaseGroupDs).on("bindid", "bindid").select(new String[]{"billtype", "id", "occupyamount-case when releaseamount = null then 0 else releaseamount end as camount"}).finish();
    }

    private DataSet queryLoanBillDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("loantype", "!=", (Object)"sl"), new QFilter("bizdate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cfm_loanbill"), (String)"cfm_loanbill", (String)"'cfm_loanbill' as billtype,id,drawamount", (QFilter[])qFilters, null);
        HashSet<Long> cfmIds = new HashSet<Long>(16);
        for (Row loanBill : dataSet.copy()) {
            cfmIds.add(loanBill.getLong("id"));
        }
        QFilter[] repaymentFilters = new QFilter[]{new QFilter("loans.e_loanbill.id", "in", cfmIds), new QFilter("bizdate", "<=", (Object)filterCutOffDate), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
        DataSet repaymentDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cfm_repaymentbill"), (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill.id as loanbillid,loans.e_repayamount as repayamount", (QFilter[])repaymentFilters, null);
        DataSet repaymentGroupDs = repaymentDs.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        return dataSet.leftJoin(repaymentGroupDs).on("id", "loanbillid").select(new String[]{"billtype", "id", "drawamount-case when repayamount = null then 0 else repayamount end as camount"}).finish();
    }

    private DataSet queryLetterCreditDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("bizdate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "lc_lettercredit"), (String)"lc_lettercredit", (String)"'lc_lettercredit' as billtype,id,amount*(1+amountscaleupper/100) as debtamount", (QFilter[])qFilters, null);
        HashSet<Long> lcIds = new HashSet<Long>(16);
        for (Row letterCredit : dataSet.copy()) {
            lcIds.add(letterCredit.getLong("id"));
        }
        QFilter[] arrivalFilters = new QFilter[]{new QFilter("lettercredit.id", "in", lcIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("arrivaldate", "<=", (Object)filterCutOffDate), new QFilter("entrys.realpaydate", "<=", (Object)DateUtils.stringToDate((String)(DateUtils.formatString((Date)filterCutOffDate, (String)"yyyy-MM-dd") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"))};
        DataSet arrivalDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "lc_arrival"), (String)"lc_arrival", (String)"id,lettercredit.id as lettercreditid,doneamount", (QFilter[])arrivalFilters, null);
        DataSet arrivalGroupDs = arrivalDs.groupBy(new String[]{"lettercreditid"}).sum("doneamount").finish();
        return dataSet.leftJoin(arrivalGroupDs).on("id", "lettercreditid").select(new String[]{"billtype", "id", "debtamount-case when doneamount = null then 0 else doneamount end as camount"}).finish();
    }

    private DataSet queryPayableBillDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] draftFilters = new QFilter[]{new QFilter("entrys.draftbill.id", "in", ids), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("tradetype", "in", Arrays.asList("billsplit", "payoff")), new QFilter("bizdate", "<", (Object)filterCutOffDate)};
        DataSet draftDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cdm_drafttradebill"), (String)"cdm_drafttradebill", (String)"entrys.draftbill.id as draftbillid", (QFilter[])draftFilters, null);
        for (Row draftBill : draftDs.copy()) {
            ids.remove(draftBill.getLong("draftbillid"));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("issuedate", "<=", (Object)filterCutOffDate)};
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cdm_payablebill"), (String)"cdm_payablebill", (String)"'cdm_payablebill' as billtype,id,amount camount", (QFilter[])qFilters, null);
    }

    private DataSet queryLetterOfGuaranteeDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("startdate", "<=", (Object)filterCutOffDate), new QFilter("claimdate", ">", (Object)filterCutOffDate).or(new QFilter("claimdate", "is null", null)), new QFilter("canceldate", ">", (Object)filterCutOffDate).or(new QFilter("canceldate", "is null", null))};
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_letterofguarantee"), (String)"gm_letterofguarantee", (String)"'gm_letterofguarantee' as billtype,id,amount camount", (QFilter[])qFilters, null);
    }

    private DataSet getExchangeRateDataSet(DataSet joinedDS) {
        Long statCurrencyId = ((DynamicObject)this.paramMap.get("filter_dutycurrency")).getLong("id");
        ArrayList currencyIdList = new ArrayList(16);
        joinedDS.copy().iterator().forEachRemaining(v -> {
            if (EmptyUtil.isNoEmpty((Long)v.getLong("gdebtcurrency"))) {
                currencyIdList.add(v.getLong("gdebtcurrency"));
            }
        });
        String queryType = (String)this.paramMap.get("filter_queryway");
        return TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)statCurrencyId, (long)TmcOrgDataHelper.getCurrentOrgId(), (Date)DateUtils.getCurrentDate(), (boolean)ReportOrgQueryWayEnum.ORG.getValue().equals(queryType));
    }

    private void init(ReportQueryParam reportQueryParam) {
        String[] dimensions;
        this.paramMap = this.transQueryParam(reportQueryParam);
        this.paramMap.putAll(reportQueryParam.getCustomParam());
        FilterInfo filters = reportQueryParam.getFilter();
        String dimension = (String)this.paramMap.get("filter_statdim");
        StringBuilder group = new StringBuilder(dimension.replaceAll("_", ","));
        for (String s : dimensions = dimension.split("_")) {
            group.append(",").append(s).append("text");
        }
        this.groupString = group.toString();
        this.orderString = dimension.replaceAll("_", ",");
        DynamicObjectCollection guarantees = (DynamicObjectCollection)this.paramMap.get("filter_guarantee");
        FilterItemInfo beginDate = filters.getFilterItem("filter_begindate");
        FilterItemInfo endDate = filters.getFilterItem("filter_enddate");
        FilterItemInfo cutOffDate = filters.getFilterItem("filter_cutoffdate");
        FilterItemInfo currency = filters.getFilterItem("filter_currency");
        FilterItemInfo closed = filters.getFilterItem("filter_closed");
        List orgIds = this.getQueryOrgIds(reportQueryParam);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guarantees)) {
            this.filterList.add(new QFilter("guarantee", "in", (Object)guarantees.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        GmReportHelper.getOrgFilter(orgIds, this.filterList);
        GmReportHelper.getGuaranFilter(this.paramMap, this.filterList);
        this.filterList.add(GmReportHelper.getDateFilter(beginDate, cutOffDate));
        if (EmptyUtil.isNoEmpty((Object)endDate.getValue())) {
            this.filterList.add(new QFilter("enddate", "<=", endDate.getValue()));
        }
        GmReportHelper.dealFilter(this.filterList, "currency", currency);
        this.filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (!((Boolean)closed.getValue()).booleanValue()) {
            this.filterList.add(new QFilter("bizstatus", "!=", (Object)"closed"));
        } else {
            this.filterList.add(new QFilter("closetime", ">", cutOffDate.getValue()).or("closetime", "is null", null));
        }
        if ("creditor".equals(dimension)) {
            this.filterList.add(new QFilter("creditortext", "!=", (Object)" ").or("creditortext", "!=", (Object)""));
        }
    }
}

