/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.constant.GmReportResConst;
import kd.tmc.gm.helper.GmReportHelper;

public class GuaranteeContractRptDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;
    private String groupString = null;
    private String orderString = null;
    private Long statCurrency = null;
    private final List<QFilter> filterList = new ArrayList<QFilter>(12);
    private static final String GUARANTEECONTRACT_FIELDS = "id,bizdate,org,entry_guaranteeorg.id as entryid,entry_guaranteeorg.a_guaranteeorg as guaranteeorg,entry_guaranteeorg.a_guaranteeorgtext as guaranteeorgtext,creditor,entry_guaranteeorg.a_guaranteetype as guaranteetype,creditortype,creditortext,guarantee,guarantee.name as guaranteetext,currency,currency.name currencytext,amount,entry_guaranteeorg.a_gratio as ratio,iscrossguarantee";
    private static final String TOTAL_FIELDS = "org,guaranteeorg,creditor,guarantee,guaranteeorgtext,creditortext,currency,guaranteetext,currencytext,id,tarcurrency,rate,amount,dutyamount,amount_report,dutyamount_report";
    private static final Long DEFAULTORGVIEWID = 8L;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        this.init(queryParam);
        DataSet billDataSet = this.queryBillData();
        if (billDataSet.copy().isEmpty()) {
            return billDataSet;
        }
        if (this.needTreeList()) {
            return this.handleTreeDataSet(billDataSet);
        }
        return this.handleListDataSet(billDataSet);
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("amount", "dutyamount");
    }

    private DataSet handleListDataSet(DataSet billDataSet) {
        boolean isTotal = (Boolean)this.paramMap.get("filter_istotal");
        DataSet groupDataSet = this.groupByStatdim(billDataSet);
        groupDataSet = groupDataSet.select("id rowid,amount,dutyamount,amount_report,dutyamount_report,'" + GmReportResConst.getGmReportResConst16() + "' detail," + this.groupString);
        groupDataSet = groupDataSet.addFields(new String[]{String.valueOf(this.statCurrency), "0"}, new String[]{"statcurrency", "sumlevel"});
        if (isTotal) {
            groupDataSet = this.sumDataSet(groupDataSet);
        }
        String statDim = (String)this.paramMap.get("filter_statdim");
        String select = "amount_report,dutyamount_report,rowid,'0' pid,sumlevel,'" + GmReportResConst.getGmReportResConst16() + "' detail," + this.groupString;
        DataSet allDataSet = statDim.contains("currency") ? groupDataSet.select("amount,dutyamount," + select) : groupDataSet.select(select);
        return allDataSet.addField(String.valueOf(this.statCurrency), "statcurrency");
    }

    private DataSet sumDataSet(DataSet dataSet) {
        List<String> sumFields = this.sumFields();
        DataSet subSumDataSet = this.genSubTotalDataSet(dataSet, sumFields);
        DataSet sumDataSet = this.addAllTotalDataSet(dataSet, sumFields, this.getTotalField());
        sumDataSet = sumDataSet.updateFields(new String[]{"sumlevel", "rowid", "statcurrency"}, new String[]{"2", String.valueOf(DBServiceHelper.genGlobalLongId()), String.valueOf(this.statCurrency)});
        return subSumDataSet.union(sumDataSet);
    }

    private DataSet genSubTotalDataSet(DataSet billDataSet, List<String> sumFields) {
        String[] dimensions = ((String)this.paramMap.get("filter_statdim")).split("_");
        int dimensionLength = dimensions.length;
        DataSet subTotalDs = billDataSet.copy();
        if (dimensionLength >= 2) {
            for (int i = 0; i < dimensionLength - 1; ++i) {
                List<String> groups = this.getSubGroups(i);
                subTotalDs = this.addSubTotalDataSet(subTotalDs, groups, sumFields, this.getTotalField());
                final RowMeta newRowMetas = subTotalDs.copy().getRowMeta();
                subTotalDs = subTotalDs.map(new MapFunction(){

                    public Object[] map(Row row) {
                        ArrayList<Object> rowInfo = new ArrayList<Object>();
                        for (String fieldName : newRowMetas.getFieldNames()) {
                            if ("rowid".equals(fieldName)) {
                                rowInfo.add(DBServiceHelper.genGlobalLongId());
                                continue;
                            }
                            rowInfo.add(row.get(fieldName));
                        }
                        return rowInfo.toArray();
                    }

                    public RowMeta getResultRowMeta() {
                        return newRowMetas;
                    }
                });
                billDataSet = billDataSet.union(subTotalDs).orderBy(this.getSubOrderBy(i));
            }
        }
        return billDataSet;
    }

    private String[] getSubOrderBy(int level) {
        String dimension = (String)this.paramMap.get("filter_statdim");
        String[] dimensions = dimension.split("_");
        if (dimensions.length < level) {
            return dimensions;
        }
        String[] orders = new String[dimensions.length - level - 1];
        System.arraycopy(dimensions, 0, orders, 0, dimensions.length - level - 1);
        return orders;
    }

    private String getTotalField() {
        String dimension = (String)this.paramMap.get("filter_statdim");
        String[] split = dimension.split("_");
        return split[0] + "text";
    }

    private List<String> getSubGroups(int level) {
        String[] dimensions = ((String)this.paramMap.get("filter_statdim")).split("_");
        ArrayList<String> groups = new ArrayList<String>(3);
        for (int i = 0; i < dimensions.length - level - 1; ++i) {
            groups.add(dimensions[i]);
            groups.add(dimensions[i] + "text");
        }
        return groups;
    }

    private boolean needTreeList() {
        String dimensions = (String)this.paramMap.get("filter_statdim");
        return !dimensions.contains("currency") && !dimensions.equals("guarantee");
    }

    private DataSet handleTreeDataSet(DataSet dataSet) {
        String statdim = (String)this.paramMap.get("filter_statdim");
        if ("guaranteeorg".equals(statdim)) {
            return this.handleTreeDataSet(dataSet, "guaranteeorg", "guaranteetype");
        }
        if ("creditor".equals(statdim)) {
            return this.handleTreeDataSet(dataSet, "creditor", "creditortype");
        }
        return dataSet;
    }

    private DataSet handleTreeDataSet(DataSet dataSet, String idField, String filterField) {
        boolean isTotal = (Boolean)this.paramMap.get("filter_istotal");
        DataSet ds = dataSet.copy();
        DataSet orgDs = ds.filter(filterField + "='bos_org' or " + filterField + "='tmc_org'");
        DataSet bankDs = ds.filter(filterField + "='tmc_bank'");
        DataSet finOrgDs = ds.filter(filterField + "='tmc_otherbank'");
        DataSet customDs = ds.filter(filterField + "='bd_bizpartner'");
        DataSet otherDs = ds.filter(filterField + "='other'");
        String type = GmReportHelper.getType(idField);
        DataSet bankTreeDs = this.createBankTree(this.groupByStatdim(bankDs), this.statCurrency, idField, type).addField("1", "sort");
        DataSet finOrgTreeDs = this.createFinOrgTree(this.groupByStatdim(finOrgDs), this.statCurrency, idField, type).addField("2", "sort");
        DataSet orgTreeDs = this.dealBillDataSetByOrg(this.groupByStatdim(orgDs), idField, GuaranteeTypeEnum.ORG.getValue(), type).addField("0", "sort");
        DataSet customListDs = this.getCustom(customDs, type, GuaranteeTypeEnum.PARTNER.getValue()).addField("3", "sort");
        DataSet otherListDs = this.getCustom(otherDs, type, GuaranteeTypeEnum.OTHER.getValue()).addField("4", "sort");
        DataSet allDataSet = bankTreeDs.union(finOrgTreeDs).union(orgTreeDs).union(customListDs).union(otherListDs).orderBy(new String[]{"sort"}).removeFields(new String[]{"sort"});
        if (isTotal) {
            DataSet totalDs = this.addAllTotalDataSet(allDataSet, this.sumFields(), null, this.getTotalField(), GmReportResConst.getGmReportResConst14()).addField("'0'", "pid").addField("'" + DBServiceHelper.genGlobalLongId() + "'", "rowid").addField("1", "level").addField("'0'", "isgroupnode").addNullField("detail").addNullField(type).select("rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report,detail," + type + "," + this.groupString);
            allDataSet = allDataSet.union(totalDs);
        }
        return allDataSet.addField(String.valueOf(this.statCurrency), "statcurrency");
    }

    private DataSet dealBillDataSetByOrg(DataSet billDataSet, String idField, String totalCaptionKey, String type) {
        if (billDataSet.copy().isEmpty()) {
            return this.emptyDataSet(billDataSet, type);
        }
        DynamicObject companyView = (DynamicObject)this.paramMap.get("filter_orgview");
        Long companyViewId = EmptyUtil.isNoEmpty((DynamicObject)companyView) ? (Long)companyView.getPkValue() : DEFAULTORGVIEWID;
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)companyViewId);
        String[] fieldNames = billDataSet.getRowMeta().getFieldNames();
        DataSet ds = orgDateSet.leftJoin(billDataSet).on("rowid", idField).select(new String[]{"rowid org", "orgname", "rowid + 10000 rowid", "case when pid > 0 then pid + 10000 else pid end pid", "isgroupnode", "level", "0 sumlevel"}, fieldNames).finish().addField(String.valueOf(this.statCurrency), "statcurrency").updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        DataSet sumDataSet = this.getSumDataSet(ds, "org,orgname," + this.groupString).addField("1", "subsort");
        DataSet subDataSet = this.getSubDataSet(ds.copy(), this.sumFields(), sumDataSet);
        sumDataSet = sumDataSet.union(subDataSet.select(sumDataSet.getRowMeta().getFieldNames()));
        String str = "";
        if (this.groupString.contains("guaranteeorg")) {
            str = "org guaranteeorg,orgname guaranteeorgtext";
        } else if (this.groupString.contains("creditor")) {
            str = "org creditor,orgname creditortext";
        }
        String select = "rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report,subsort,'" + GmReportResConst.getGmReportResConst16() + "' detail,'" + totalCaptionKey + "' " + type + "," + str;
        sumDataSet = sumDataSet.select(select).orderBy(new String[]{"subsort"});
        boolean isTotal = (Boolean)this.paramMap.get("filter_istotal");
        if (isTotal) {
            DataSet totalDs = this.addSubTotalDataSet(ds, new ArrayList(), this.sumFields(), this.getTotalField(), GmReportHelper.getTotalCaption(totalCaptionKey)).updateField("isgroupnode", "'0'").updateField("rowid", String.valueOf(DBServiceHelper.genGlobalLongId())).updateField("pid", "'0'").updateField("rowid", "cast(rowid as String)").addNullField("detail").addField("'" + GuaranteeTypeEnum.TMCORG.getValue() + "'", type).addField("1", "subsort").select("rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report,subsort, detail," + type + "," + this.groupString);
            sumDataSet = sumDataSet.union(totalDs);
        }
        return this.removeNoDataTreeDs(sumDataSet.removeFields(new String[]{"subsort"}), this.sumFields()).removeFields(new String[]{"parentid"});
    }

    private DataSet getCustom(DataSet ds, String type, String guarantType) {
        long globaId = DBServiceHelper.genGlobalLongId();
        DataSet rows = this.groupByStatdim(ds).addField("0", this.sumField);
        if (rows.copy().isEmpty()) {
            return this.emptyDataSet(rows, type);
        }
        String totalCaption = GmReportHelper.getTotalCaption(guarantType);
        return this.addAllTotalDataSet(rows, this.sumFields(), null, this.getTotalField(), totalCaption).addField("'" + globaId + "'", "rowid").addField("'0'", "pid").addField("1", "level").addField("'0'", "isgroupnode").addNullField("detail").addField("'" + guarantType + "'", type).updateField("sumlevel", "0").select("rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report,'" + GmReportResConst.getGmReportResConst16() + "' detail," + type + "," + this.groupString);
    }

    private DataSet emptyDataSet(DataSet ds, String type) {
        return ds.addField("'0'", "pid").addField("'0'", "rowid").addField("0", "sumlevel").addField("1", "level").addField("'0'", "isgroupnode").addNullField("detail").addNullField(type).select("rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report,detail," + type + "," + this.groupString);
    }

    private DataSet createBankTree(DataSet bankDs, Long tarCurrencyId, String idField, String type) {
        if (bankDs.copy().isEmpty()) {
            return this.emptyDataSet(bankDs, type);
        }
        Set<Long> bankIds = this.getDataSetFieldIds(bankDs, idField);
        DataSet bdFinOrgInfoDs = this.getBaseDataSetOfChilds(bankIds, "bd_finorginfo", "bank_cate");
        String[] fieldNames = bankDs.getRowMeta().getFieldNames();
        Set<Long> bankTypeIds = this.getDataSetFieldIds(bdFinOrgInfoDs, "pid");
        DataSet bankCgSettingDs = GuaranteeContractRptDataListPlugin.getBaseDataSetOfParent(bankTypeIds, (String)"bd_bankcgsetting").addField(String.valueOf(tarCurrencyId), "currency").select(GmReportHelper.genRootTypeFileds(bankDs, this.groupString) + ",rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = bankDs.leftJoin(bdFinOrgInfoDs).on(idField, "id").select(fieldNames, new String[]{"rowid", "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish();
        DataSet bankTreeDs = creditorDs.union(bankCgSettingDs).updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        DataSet sumDataSet = this.getSumDataSet(bankTreeDs, this.groupString);
        String select = "rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report,'" + GmReportResConst.getGmReportResConst16() + "' detail,'tmc_bank' " + type + "," + this.groupString;
        sumDataSet = sumDataSet.select(select);
        boolean isTotal = (Boolean)this.paramMap.get("filter_istotal");
        if (isTotal) {
            DataSet totalDs = this.addSubTotalDataSet(bankTreeDs, new ArrayList(), this.sumFields(), this.getTotalField(), GmReportHelper.getTotalCaption(GuaranteeTypeEnum.TMCBANK.getValue())).updateField("isgroupnode", "'0'").updateField("rowid", "'" + DBServiceHelper.genGlobalLongId() + "'").updateField("pid", "'0'").addNullField("detail").addField("'" + GuaranteeTypeEnum.TMCBANK.getValue() + "'", type).select("rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report, detail," + type + "," + this.groupString);
            sumDataSet = sumDataSet.union(totalDs);
        }
        return this.removeNoDataTreeDs(sumDataSet, this.sumFields()).removeFields(new String[]{"parentid"});
    }

    private DataSet createFinOrgTree(DataSet finOrgDs, Long tarCurrencyId, String idField, String type) {
        if (finOrgDs.copy().isEmpty()) {
            return this.emptyDataSet(finOrgDs, type);
        }
        Set<Long> bankIds = this.getDataSetFieldIds(finOrgDs, idField);
        DataSet bdFinOrgInfoDs = this.getBaseDataSetOfChilds(bankIds, "bd_finorginfo", "finorgtype");
        String[] fieldNames = finOrgDs.getRowMeta().getFieldNames();
        Set<Long> finTypeIds = this.getDataSetFieldIds(bdFinOrgInfoDs, "pid");
        DataSet finOrgTypeDs = GuaranteeContractRptDataListPlugin.getBaseDataSetOfParent(finTypeIds, (String)"bd_finorgtype").addField(String.valueOf(tarCurrencyId), "currency").select(GmReportHelper.genRootTypeFileds(finOrgDs, this.groupString) + ",rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = finOrgDs.leftJoin(bdFinOrgInfoDs).on(idField, "id").select(fieldNames, new String[]{"rowid", "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish();
        DataSet finOrgTreeDs = creditorDs.union(finOrgTypeDs).updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        String select = "rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report,'" + GmReportResConst.getGmReportResConst16() + "' detail,'tmc_otherbank' " + type + "," + this.groupString;
        DataSet sumDataSet = this.getSumDataSet(finOrgTreeDs, this.groupString);
        sumDataSet = sumDataSet.select(select);
        boolean isTotal = (Boolean)this.paramMap.get("filter_istotal");
        if (isTotal) {
            DataSet totalDs = this.addSubTotalDataSet(finOrgTreeDs, new ArrayList(), this.sumFields(), this.getTotalField(), GmReportHelper.getTotalCaption(GuaranteeTypeEnum.TMCNOTBANK.getValue())).updateField("isgroupnode", "'0'").updateField("rowid", "'" + DBServiceHelper.genGlobalLongId() + "'").updateField("pid", "'0'").addNullField("detail").addField("'" + GuaranteeTypeEnum.TMCNOTBANK.getValue() + "'", type).select("rowid,pid,isgroupnode,level,sumlevel,amount_report,dutyamount_report, detail," + type + "," + this.groupString);
            sumDataSet = sumDataSet.union(totalDs);
        }
        return this.removeNoDataTreeDs(sumDataSet, this.sumFields()).removeFields(new String[]{"parentid"});
    }

    private DataSet getSumDataSet(DataSet treeData, String customFields) {
        treeData = this.getSumDataSetByLevel(treeData.copy(), this.sumFields(), customFields);
        return treeData;
    }

    private List<String> sumFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("amount_report");
        fields.add("dutyamount_report");
        return fields;
    }

    private Set<Long> getDataSetFieldIds(DataSet billDataSet, String field) {
        HashSet<Long> billIds = new HashSet<Long>();
        billDataSet.copy().forEach(o -> billIds.add(o.getLong(field)));
        return billIds;
    }

    private DataSet groupByStatdim(DataSet billDataSet) {
        if (EmptyUtil.isEmpty((Object)billDataSet)) {
            return DataSetHelper.createEmptyDataSet((String[])new String[]{"empty"}, (DataType[])new DataType[]{DataType.StringType});
        }
        String statDim = (String)this.paramMap.get("filter_statdim");
        DataSet exBillDataSet = this.addExchangeRateAndCurrencyUnit(billDataSet, this.paramMap).select(TOTAL_FIELDS.split(","));
        exBillDataSet = exBillDataSet.groupBy(this.groupString.split(",")).sum("amount").sum("amount_report").sum("dutyamount").sum("dutyamount_report").max("id").finish();
        if ("creditor_currency".equals(statDim)) {
            DataSet otherDs = exBillDataSet.filter("creditor=0");
            exBillDataSet = exBillDataSet.filter("creditor!=0");
            DataSet billGroup = exBillDataSet.groupBy(this.groupString.split(",")).sum("amount").sum("amount_report").sum("dutyamount").sum("dutyamount_report").max("id").finish();
            Object[] fields = Arrays.stream(this.groupString.split(",")).filter(o -> !"currency".equals(o) && !"creditortext".equals(o)).toArray();
            DataSet otherGroup = otherDs.groupBy(new String[]{"creditor"}).sum("amount_report").sum("dutyamount_report").max("id").finish().addField("'" + GmReportResConst.getGmReportResConst23() + "'", "creditortext").addNullField(new String[]{"amount", "dutyamount", "currency"});
            for (Object field : fields) {
                otherGroup = otherGroup.addNullField(String.valueOf(field));
            }
            otherGroup = otherGroup.select(billGroup.getRowMeta().getFieldNames());
            return billGroup.union(otherGroup);
        }
        return exBillDataSet;
    }

    private DataSet queryBillData() {
        DataSet guaranteeContracts = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteecontract"), (String)"gm_guaranteecontract", (String)GUARANTEECONTRACT_FIELDS, (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString).distinct();
        if (!guaranteeContracts.copy().isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>(16);
            for (Row guaranteeContract : guaranteeContracts.copy()) {
                ids.add(guaranteeContract.getLong("id"));
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("gsrcbilltype", "!=", (Object)"cfm_creditlimit"), new QFilter("gsrcbilltype", "!=", (Object)"creditm_limit_framework"), new QFilter("gcontract.id", "in", ids), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
            DataSet guaranteeUse = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_guaranteeuse"), (String)"gm_guaranteeuse", (String)"gcontract.id gcontractid,gdebtcurrency,case when gsrcbilltype in ('cfm_loanbill_b_l','cfm_loanbill_e_l','cim_invest_loanbill') then 'cfm_loanbill' else gsrcbilltype end as gsrcbilltype,gsrcbillid,gratio,gdebtbalance", (QFilter[])qFilters, null);
            Map<String, Set<Long>> guaranteeUseMap = this.getGuaranteeUseMap(guaranteeUse.copy());
            HashSet<Long> emptySet = new HashSet<Long>(16);
            DataSet letterOfGuaranteeDs = this.queryLetterOfGuaranteeDs(guaranteeUseMap.get("gm_letterofguarantee") == null ? emptySet : guaranteeUseMap.get("gm_letterofguarantee"));
            DataSet payableBillDs = this.queryPayableBillDs(guaranteeUseMap.get("cdm_payablebill") == null ? emptySet : guaranteeUseMap.get("cdm_payablebill"));
            DataSet letterCreditDs = this.queryLetterCreditDs(guaranteeUseMap.get("lc_lettercredit") == null ? emptySet : guaranteeUseMap.get("lc_lettercredit"));
            DataSet loanBillDs = this.queryLoanBillDs(guaranteeUseMap.get("cfm_loanbill") == null ? emptySet : guaranteeUseMap.get("cfm_loanbill"));
            DataSet debtRegisterDs = this.queryDebtRegister(guaranteeUseMap.get("gm_debt_register") == null ? emptySet : guaranteeUseMap.get("gm_debt_register"));
            DataSet leaseContractDs = this.queryLeaseContract(guaranteeUseMap.get("fl_receiptbill") == null ? emptySet : guaranteeUseMap.get("fl_receiptbill"));
            letterOfGuaranteeDs = letterOfGuaranteeDs.copy().union(new DataSet[]{payableBillDs, letterCreditDs, loanBillDs, debtRegisterDs, leaseContractDs});
            guaranteeUse = guaranteeUse.copy().leftJoin(letterOfGuaranteeDs).on("gsrcbillid", "id").on("gsrcbilltype", "billtype").select(new String[]{"gcontractid", "gdebtcurrency", "gsrcbilltype", "gsrcbillid", "gratio", "case when gsrcbilltype not in ('gm_letterofguarantee','cdm_payablebill','lc_lettercredit','cfm_loanbill','fl_receiptbill') or camount == null then gdebtbalance when gsrcbilltype='gm_debt_register' then camount else camount*gratio/100 end as gdebtbalance"}).finish();
            DataSet exchangeRateDataSet = this.getExchangeRateDataSet(guaranteeUse.copy());
            guaranteeUse = guaranteeUse.copy().join(exchangeRateDataSet).on("gdebtcurrency", "tarcurrency").select(new String[]{"gcontractid", "rate*gdebtbalance gdebtbalance"}).finish();
            DataSet guaranteeUseGroup = guaranteeUse.groupBy(new String[]{"gcontractid"}).sum("gdebtbalance").finish();
            RowMeta rowMeta = guaranteeContracts.getRowMeta();
            guaranteeContracts = guaranteeContracts.leftJoin(guaranteeUseGroup).on("id", "gcontractid").select(rowMeta.getFieldNames(), new String[]{"case when iscrossguarantee=true and guaranteeorg=org then 0 else gdebtbalance*ratio/100 end dutyamount"}).finish();
        }
        return guaranteeContracts;
    }

    private DataSet getExchangeRateDataSet(DataSet joinedDS) {
        Long statCurrencyId = ((DynamicObject)this.paramMap.get("filter_statcurrency")).getLong("id");
        ArrayList currencyIdList = new ArrayList(16);
        joinedDS.copy().iterator().forEachRemaining(v -> {
            if (EmptyUtil.isNoEmpty((Long)v.getLong("gdebtcurrency"))) {
                currencyIdList.add(v.getLong("gdebtcurrency"));
            }
        });
        String queryType = (String)this.paramMap.get("filter_queryway");
        return TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)statCurrencyId, (long)TmcOrgDataHelper.getCurrentOrgId(), (Date)DateUtils.getCurrentDate(), (boolean)ReportOrgQueryWayEnum.ORG.getValue().equals(queryType));
    }

    private Map<String, Set<Long>> getGuaranteeUseMap(DataSet joinedDS) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        if (joinedDS.isEmpty()) {
            return map;
        }
        for (Row guaranteeUse : joinedDS) {
            HashSet<Long> ids = (HashSet<Long>)map.get(guaranteeUse.getString("gsrcbilltype"));
            if (ids == null) {
                ids = new HashSet<Long>(16);
            }
            ids.add(guaranteeUse.getLong("gsrcbillid"));
            map.put(guaranteeUse.getString("gsrcbilltype"), ids);
        }
        return map;
    }

    private DataSet queryLeaseContract(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("bizdate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "fl_receiptbill"), (String)"fl_receiptbill", (String)"'fl_receiptbill' as billtype,id,drawamount", (QFilter[])qFilters, null);
        HashSet<Long> flIds = new HashSet<Long>(16);
        for (Row receiptBill : dataSet.copy()) {
            flIds.add(receiptBill.getLong("id"));
        }
        QFilter[] rentPayFilters = new QFilter[]{new QFilter("loans.e_loanbill.id", "in", flIds), new QFilter("bizdate", "<=", (Object)filterCutOffDate), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
        DataSet rentPayDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "fl_rentpaybill"), (String)"fl_rentpaybill", (String)"id,loans.e_loanbill.id as loanbillid,loans.e_repayamount as repayamount", (QFilter[])rentPayFilters, null);
        DataSet rentPayGroupDs = rentPayDs.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        return dataSet.leftJoin(rentPayGroupDs).on("id", "loanbillid").select(new String[]{"billtype", "id", "drawamount-case when repayamount = null then 0 else repayamount end as camount"}).finish();
    }

    private DataSet queryDebtRegister(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("changetype", "=", (Object)DebtChangeTypeEnum.DEBT_OCCUPY.getValue()), new QFilter("begindate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_debt_register"), (String)"gm_debt_register", (String)"bindid,'gm_debt_register' as billtype,id,occupyamount", (QFilter[])qFilters, null);
        HashSet<String> debtIds = new HashSet<String>(16);
        for (Row debtRegister : dataSet.copy()) {
            debtIds.add(debtRegister.getString("bindid"));
        }
        QFilter[] releaseFilters = new QFilter[]{new QFilter("bindid", "in", debtIds), new QFilter("changetype", "=", (Object)DebtChangeTypeEnum.DEBT_RELEASE.getValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("registerdate", "<=", (Object)filterCutOffDate)};
        DataSet releaseDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_debt_register"), (String)"gm_debt_register", (String)"id,bindid,releaseamount", (QFilter[])releaseFilters, null);
        DataSet releaseGroupDs = releaseDataSet.groupBy(new String[]{"bindid"}).sum("releaseamount").finish();
        return dataSet.leftJoin(releaseGroupDs).on("bindid", "bindid").select(new String[]{"billtype", "id", "occupyamount-case when releaseamount = null then 0 else releaseamount end as camount"}).finish();
    }

    private DataSet queryLoanBillDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("loantype", "!=", (Object)"sl"), new QFilter("bizdate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cfm_loanbill"), (String)"cfm_loanbill", (String)"'cfm_loanbill' as billtype,id,drawamount", (QFilter[])qFilters, null);
        HashSet<Long> cfmIds = new HashSet<Long>(16);
        for (Row loanBill : dataSet.copy()) {
            cfmIds.add(loanBill.getLong("id"));
        }
        QFilter[] repaymentFilters = new QFilter[]{new QFilter("loans.e_loanbill.id", "in", cfmIds), new QFilter("bizdate", "<=", (Object)filterCutOffDate), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())};
        DataSet repaymentDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cfm_repaymentbill"), (String)"cfm_repaymentbill", (String)"id,loans.e_loanbill.id as loanbillid,loans.e_repayamount as repayamount", (QFilter[])repaymentFilters, null);
        DataSet repaymentGroupDs = repaymentDs.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        return dataSet.leftJoin(repaymentGroupDs).on("id", "loanbillid").select(new String[]{"billtype", "id", "drawamount-case when repayamount = null then 0 else repayamount end as camount"}).finish();
    }

    private DataSet queryLetterCreditDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("bizdate", "<=", (Object)filterCutOffDate)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "lc_lettercredit"), (String)"lc_lettercredit", (String)"'lc_lettercredit' as billtype,id,amount*(1+amountscaleupper/100) as debtamount", (QFilter[])qFilters, null);
        HashSet<Long> lcIds = new HashSet<Long>(16);
        for (Row letterCredit : dataSet.copy()) {
            lcIds.add(letterCredit.getLong("id"));
        }
        QFilter[] arrivalFilters = new QFilter[]{new QFilter("lettercredit.id", "in", lcIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("arrivaldate", "<=", (Object)filterCutOffDate), new QFilter("entrys.realpaydate", "<=", (Object)DateUtils.stringToDate((String)(DateUtils.formatString((Date)filterCutOffDate, (String)"yyyy-MM-dd") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"))};
        DataSet arrivalDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "lc_arrival"), (String)"lc_arrival", (String)"id,lettercredit.id as lettercreditid,doneamount", (QFilter[])arrivalFilters, null);
        DataSet arrivalGroupDs = arrivalDs.groupBy(new String[]{"lettercreditid"}).sum("doneamount").finish();
        return dataSet.leftJoin(arrivalGroupDs).on("id", "lettercreditid").select(new String[]{"billtype", "id", "debtamount-case when doneamount = null then 0 else doneamount end as camount"}).finish();
    }

    private DataSet queryPayableBillDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] draftFilters = new QFilter[]{new QFilter("entrys.draftbill.id", "in", ids), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("tradetype", "in", Arrays.asList("billsplit", "payoff")), new QFilter("bizdate", "<", (Object)filterCutOffDate)};
        DataSet draftDs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cdm_drafttradebill"), (String)"cdm_drafttradebill", (String)"entrys.draftbill.id as draftbillid", (QFilter[])draftFilters, null);
        for (Row draftBill : draftDs.copy()) {
            ids.remove(draftBill.getLong("draftbillid"));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("issuedate", "<=", (Object)filterCutOffDate)};
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "cdm_payablebill"), (String)"cdm_payablebill", (String)"'cdm_payablebill' as billtype,id,amount camount", (QFilter[])qFilters, null);
    }

    private DataSet queryLetterOfGuaranteeDs(Set<Long> ids) {
        Date filterCutOffDate = (Date)this.paramMap.get("filter_cutoffdate");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("startdate", "<=", (Object)filterCutOffDate), new QFilter("claimdate", ">=", (Object)filterCutOffDate).or(new QFilter("claimdate", "is null", null)), new QFilter("canceldate", ">=", (Object)filterCutOffDate).or(new QFilter("canceldate", "is null", null))};
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_letterofguarantee"), (String)"gm_letterofguarantee", (String)"'gm_letterofguarantee' as billtype,id,amount camount", (QFilter[])qFilters, null);
    }

    private void init(ReportQueryParam reportQueryParam) {
        String[] dimensions;
        this.paramMap = this.transQueryParam(reportQueryParam);
        this.paramMap.putAll(reportQueryParam.getCustomParam());
        FilterInfo filters = reportQueryParam.getFilter();
        this.statCurrency = (Long)((DynamicObject)this.paramMap.get("filter_statcurrency")).getPkValue();
        String dimension = (String)this.paramMap.get("filter_statdim");
        StringBuilder group = new StringBuilder(dimension.replaceAll("_", ","));
        for (String s : dimensions = dimension.split("_")) {
            group.append(',').append(s).append("text");
        }
        this.groupString = group.toString();
        this.orderString = dimension.replaceAll("_", ",");
        DynamicObjectCollection guarantees = (DynamicObjectCollection)this.paramMap.get("filter_guarantee");
        FilterItemInfo cutOffDate = filters.getFilterItem("filter_cutoffdate");
        FilterItemInfo currency = filters.getFilterItem("filter_currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)guarantees)) {
            this.filterList.add(new QFilter("guarantee", "in", (Object)guarantees.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        QFilter beginDateFilter = QFilter.isNull((String)"begindate");
        if (EmptyUtil.isNoEmpty((Object)cutOffDate.getValue())) {
            Date filterCutOffDate = (Date)cutOffDate.getValue();
            beginDateFilter.or(new QFilter("begindate", "<=", (Object)filterCutOffDate));
        }
        this.filterList.add(beginDateFilter);
        List orgIds = this.getQueryOrgIds(reportQueryParam);
        GmReportHelper.getOrgFilter(orgIds, this.filterList);
        GmReportHelper.getGuaranFilter(this.paramMap, this.filterList);
        GmReportHelper.dealFilter(this.filterList, "currency.id", currency);
        this.filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        this.filterList.add(new QFilter("bizstatus", "!=", (Object)"closed"));
        if ("creditor".equals(dimension)) {
            this.filterList.add(new QFilter("creditortext", "!=", (Object)" ").or("creditortext", "!=", (Object)""));
        }
    }
}

