/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.helper.GmReportHelper;

public class LetterOfGuaranteeRptDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;
    private String groupString = null;
    private String orderString = null;
    private final List<QFilter> filterList = new ArrayList<QFilter>(12);
    private static final String LETTER_FIELDS = "id,finorginfo.bank_cate.id bankcateid,finorginfo.bank_cate.name bankcatename, applyorg,applyorg.name applyorgtext,finorginfo,finorginfo.name finorginfotext,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext,amount";
    private static final String RECEIVE_FIELDS = "id,finorginfo.bank_cate.id bankcateid,finorginfo.bank_cate.name bankcatename, applyorg,applyorg.name applyorgtext,finorginfo,finorginfo.name finorginfotext,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext,amount";

    public DataSet queryDataSet(ReportQueryParam param) {
        this.init(param);
        DataSet bizDataSet = this.queryBillDataSet();
        if (this.isFinorgAndBankLevel1()) {
            DataSet bankDataSet = bizDataSet.copy().filter("bankcateid != 0");
            DataSet notBankDataSet = bizDataSet.copy().filter("bankcateid = 0");
            DataSet bankDataSetNew = bankDataSet.select("id,applyorg ,applyorgtext,guaranteetype,guaranteetypetext,bankcateid finorginfo,bankcatename finorginfotext,currency,currencytext,amount");
            DataSet notBankDataSetNew = notBankDataSet.select("id,applyorg ,applyorgtext,guaranteetype,guaranteetypetext,finorginfo,finorginfotext,currency,currencytext,amount");
            bizDataSet = bankDataSetNew.union(notBankDataSetNew);
        }
        bizDataSet = this.ReplaceFileds(bizDataSet);
        GroupbyDataSet groupDs = bizDataSet.copy().groupBy(this.groupString.split(",")).sum("amount");
        return groupDs.finish();
    }

    private boolean isFinorgAndBankLevel1() {
        String statdim = (String)this.paramMap.get("filter_statdim");
        String level = (String)this.paramMap.get("filter_level");
        return statdim.contains("finorginfo") && "1".equals(level);
    }

    private DataSet queryBillDataSet() {
        String bizType = (String)this.paramMap.get("filter_biztype");
        if ("send".equals(bizType)) {
            return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_letterofguarantee"), (String)"gm_letterofguarantee", (String)"id,finorginfo.bank_cate.id bankcateid,finorginfo.bank_cate.name bankcatename, applyorg,applyorg.name applyorgtext,finorginfo,finorginfo.name finorginfotext,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext,amount", (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString);
        }
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "gm_receiveletter"), (String)"gm_receiveletter", (String)"id,finorginfo.bank_cate.id bankcateid,finorginfo.bank_cate.name bankcatename, applyorg,applyorg.name applyorgtext,finorginfo,finorginfo.name finorginfotext,guaranteetype,guaranteetype.name guaranteetypetext,currency,currency.name currencytext,amount", (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString);
    }

    private void init(ReportQueryParam reportQueryParam) {
        String[] dimensions;
        this.paramMap = this.transQueryParam(reportQueryParam);
        this.paramMap.putAll(reportQueryParam.getCustomParam());
        FilterInfo filters = reportQueryParam.getFilter();
        String dimension = (String)this.paramMap.get("filter_statdim");
        StringBuilder group = new StringBuilder(dimension.replaceAll("_", ","));
        for (String s : dimensions = dimension.split("_")) {
            group.append(',').append(s).append("text");
        }
        this.groupString = group.toString();
        this.orderString = dimension.replaceAll("_", ",");
        DynamicObjectCollection finorginfo = (DynamicObjectCollection)this.paramMap.get("filter_finorginfo");
        FilterItemInfo currency = filters.getFilterItem("filter_currency");
        String bizType = (String)this.paramMap.get("filter_biztype");
        if ("send".equals(bizType)) {
            List applyOrg = this.getQueryOrgIds(reportQueryParam);
            this.filterList.add(new QFilter("applyorg", "in", (Object)(EmptyUtil.isNoEmpty((Object)applyOrg) ? applyOrg : new ArrayList(10))));
        } else {
            List beneficiary = this.getQueryOrgIds(reportQueryParam, "filter_beneficiary_org", "filter_beneficiary_orgv");
            this.filterList.add(new QFilter("applyorg", "in", (Object)(EmptyUtil.isNoEmpty((Object)beneficiary) ? beneficiary : new ArrayList(10))));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finorginfo)) {
            List ids = finorginfo.stream().map(f -> f.getLong("id")).collect(Collectors.toList());
            this.filterList.add(new QFilter("finorginfo", "in", ids));
        }
        GmReportHelper.dealFilter(this.filterList, "currency.id", currency);
        String startDate = (String)this.paramMap.get("filter_startdate");
        if (EmptyUtil.isNotEmpty((CharSequence)startDate)) {
            QFilter qFilter = GmReportHelper.buildDateRangesFilter(startDate, "startdate", "startdateranges", this.paramMap);
            this.filterList.add(qFilter);
        }
        ArrayList<String> bizStatus = new ArrayList<String>();
        bizStatus.add(BizStatusEnum.REGISTERED.getValue());
        boolean hasCanceled = (Boolean)this.paramMap.get("filter_hascanceled");
        boolean hasClaimed = (Boolean)this.paramMap.get("filter_hasclaimed");
        bizStatus.add(BizStatusEnum.CLAIMED.getValue());
        bizStatus.add(BizStatusEnum.CANCELLED.getValue());
        QFilter qFilter = new QFilter("bizstatus", "in", bizStatus);
        this.filterList.add(qFilter);
        FilterItemInfo cutoffdate = filters.getFilterItem("filter_cutoffdate");
        if (EmptyUtil.isNoEmpty((Object)cutoffdate.getValue())) {
            Date filtercutoffdate = (Date)cutoffdate.getValue();
            QFilter startdateFilter = new QFilter("startdate", "<=", (Object)filtercutoffdate);
            if (!hasClaimed) {
                QFilter claimDateFilter = new QFilter("claimdate", ">", (Object)filtercutoffdate).or(new QFilter("claimdate", "is null", null));
                startdateFilter = startdateFilter.and(claimDateFilter);
            }
            if (!hasCanceled) {
                QFilter cancelDateFilter = new QFilter("canceldate", ">", (Object)filtercutoffdate).or(new QFilter("canceldate", "is null", null));
                startdateFilter = startdateFilter.and(cancelDateFilter);
            }
            this.filterList.add(startdateFilter);
        }
        this.filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
    }

    private DataSet ReplaceFileds(DataSet bizDataSet) {
        String[] fields = bizDataSet.getRowMeta().getFieldNames();
        String bizType = (String)this.paramMap.get("filter_biztype");
        if (!"send".equals(bizType)) {
            for (int index = 0; index < fields.length; ++index) {
                String field = fields[index];
                if (field.equals("applyorg")) {
                    fields[index] = "applyorg beneficiary";
                }
                if (!field.equals("applyorgtext")) continue;
                fields[index] = "applyorgtext beneficiarytext";
            }
        }
        return bizDataSet.select(fields);
    }

    public List<String> sumAmountFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("amount_report");
        return fields;
    }

    public String sumNameField() {
        String dimension = (String)this.paramMap.get("filter_statdim");
        if (dimension.contains("applyorg")) {
            return "applyorgtext";
        }
        if (dimension.contains("beneficiary")) {
            return "beneficiarytext";
        }
        if (dimension.contains("finorginfo")) {
            return "finorginfotext";
        }
        if (dimension.contains("guaranteetype")) {
            return "guaranteetypetext";
        }
        return "currencytext";
    }

    public List<String> groupFields() {
        String[] dimensions = ((String)this.paramMap.get("filter_statdim")).split("_");
        int dimensionLength = dimensions.length;
        if (dimensionLength >= 2) {
            ArrayList<String> groups = new ArrayList<String>(3);
            groups.add(dimensions[0]);
            groups.add(dimensions[0] + "text");
            return groups;
        }
        return super.groupFields();
    }

    public List<String> amountFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("amount_report");
        return fields;
    }
}

