/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.constant.GmReportResConst;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AbstractGuaranteeContractFormPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Map<String, Pair<String, String>> fieldMap = this.getFieldMap();
        if (fieldMap.size() > 0) {
            Set<String> fields = fieldMap.keySet();
            this.addClickListeners(fields.toArray(new String[0]));
        }
        this.addClickListeners(new String[]{"filter_guaranteetext"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        String key = srcControl.getKey();
        if (this.getFieldMap().containsKey(key)) {
            String baseType = this.getBaseType(key);
            if (EmptyUtil.isEmpty((String)baseType)) {
                String typeField = (String)this.getFieldMap().get(key).getLeft();
                ComboEdit control = (ComboEdit)this.getControl(typeField);
                LocaleString fieldName = control.getProperty().getDisplayName();
                this.getView().showTipNotification(String.format(GmReportResConst.getGmReportResConst9(), fieldName));
                return;
            }
            if (!this.getTypeOtherValue().equals(baseType)) {
                this.showF7(key);
            } else {
                this.getView().showTipNotification(GmReportResConst.getGmReportResConst20());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "filter_creditortype": {
                this.getModel().setValue("filter_creditortext", (Object)"");
                this.getPageCache().put("filter_creditorid", null);
                break;
            }
            case "filter_guaranteetype": {
                this.getModel().setValue("filter_guaranteeorgtext", (Object)"");
                this.getPageCache().put("filter_guaranteeorgid", null);
                break;
            }
            case "filter_reguatype": {
                this.getModel().setValue("filter_reguatext", (Object)"");
                this.getPageCache().put("filter_reguaid", null);
                break;
            }
            case "filter_guaranteeorgtext": {
                String guaranteeOrgText = (String)this.getModel().getValue("filter_guaranteeorgtext");
                if (!EmptyUtil.isEmpty((String)guaranteeOrgText)) break;
                this.getPageCache().put("filter_guaranteeorgid", null);
                break;
            }
            case "filter_creditortext": {
                String creditorText = (String)this.getModel().getValue("filter_creditortext");
                if (!EmptyUtil.isEmpty((String)creditorText)) break;
                this.getPageCache().put("filter_creditorid", null);
                break;
            }
            case "filter_reguatext": {
                String reGuaText = (String)this.getModel().getValue("filter_reguatext");
                if (!EmptyUtil.isEmpty((String)reGuaText)) break;
                this.getPageCache().put("filter_reguaid", null);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (this.getFieldMap().containsKey(key) && EmptyUtil.isNoEmpty((Object)e.getValue())) {
            String typePropDisplayName = this.getTypeDisplayName(key);
            String baseType = this.getBaseType(key);
            if (!this.getTypeOtherValue().equals(baseType)) {
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u975e\u5176\u4ed6\u7c7b\u578b\uff0c\u4e0d\u80fd\u76f4\u63a5\u8f93\u5165\uff0c\u8bf7\u901a\u8fc7\u70b9\u51fb\u9009\u62e9", (String)"AbstractGuaranteeContractFormPlugin_0", (String)"tmc-gm-report", (Object[])new Object[0]), typePropDisplayName, 6000));
                this.getView().updateView(key);
            }
        }
    }

    private String getTypeDisplayName(String key) {
        String typeField = (String)this.getFieldMap().get(key).getLeft();
        ComboEdit control = (ComboEdit)this.getControl(typeField);
        LocaleString typeDisplayName = control.getProperty().getDisplayName();
        String typePropDisplayName = typeDisplayName.toString();
        return typePropDisplayName;
    }

    protected void search() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    private Map<String, Pair<String, String>> getFieldMap() {
        HashMap<String, Pair<String, String>> fieldMap = new HashMap<String, Pair<String, String>>(3);
        fieldMap.put("filter_creditortext", Pair.of((Object)"filter_creditortype", (Object)"filter_creditorid"));
        fieldMap.put("filter_guaranteeorgtext", Pair.of((Object)"filter_guaranteetype", (Object)"filter_guaranteeorgid"));
        fieldMap.put("filter_reguatext", Pair.of((Object)"filter_reguatype", (Object)"filter_reguaid"));
        return fieldMap;
    }

    private void showF7(String textField) {
        String baseType = this.getBaseType(textField);
        String f7FormId = this.getF7FormId(baseType);
        if (StringUtils.equals((CharSequence)baseType, (CharSequence)GuaranteeTypeEnum.TMCORG.getValue())) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)3, (boolean)true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, textField);
            lsp.setCloseCallBack(closeCallBack);
            lsp.setCustomParam("orgFuncId", (Object)"08");
            this.getView().showForm((FormShowParameter)lsp);
        } else {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)f7FormId, (boolean)true, (int)3, (boolean)true);
            this.addCustomFilter(textField, lsp);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, textField);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    protected void addCustomFilter(String textField, ListShowParameter lsp) {
        String type = this.getBaseType(textField);
        List lspQFilter = lsp.getListFilterParameter().getQFilters();
        if (GuaranteeTypeEnum.TMCBANK.getValue().equals(type)) {
            lspQFilter.add(new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.BANK.getValue()));
        } else if (GuaranteeTypeEnum.TMCNOTBANK.getValue().equals(type)) {
            lspQFilter.add(new QFilter("finorgtype.type", "!=", (Object)FinOrgTypeEnum.BANK.getValue()));
        }
    }

    protected String getF7FormId(String type) {
        for (GuaranteeTypeEnum value : GuaranteeTypeEnum.values()) {
            if (!value.getValue().equals(type)) continue;
            return value.getFormid();
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String type = e.getActionId();
        if (this.getFieldMap().containsKey(type)) {
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)e.getReturnData();
            if (selectedRowCol == null || selectedRowCol.size() == 0) {
                return;
            }
            String names = selectedRowCol.stream().map(ListSelectedRow::getName).collect(Collectors.joining(","));
            String ids = selectedRowCol.stream().map(a -> String.valueOf(a.getPrimaryKeyValue())).collect(Collectors.joining(","));
            this.getModel().setValue(type, (Object)names);
            this.getPageCache().put((String)this.getFieldMap().get(type).getRight(), ids);
        }
    }

    protected String getTypeOtherValue() {
        return "other";
    }

    private String getBaseType(String textField) {
        String typeField = (String)this.getFieldMap().get(textField).getLeft();
        return (String)this.getModel().getValue(typeField);
    }
}

