/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.form;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.constant.GmReportResConst;
import kd.tmc.gm.form.AbstractGuaranteeContractFormPlugin;

public class GuaranteeContractDetailFormPlugin
extends AbstractGuaranteeContractFormPlugin
implements HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_statdim": 
            case "filter_istotal": {
                String dimension = (String)this.getModel().getValue("filter_statdim");
                boolean isTotal = (Boolean)this.getModel().getValue("filter_istotal") != false && dimension.replaceAll("_", ",").contains("currency");
                this.getModel().setValue("filter_isshowsubtotal", (Object)isTotal);
                this.search();
            }
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey("detail")) {
            this.getModel().setValue("lookupdetail", (Object)Boolean.TRUE);
            this.getModel().setValue("filter_guarantee", (Object)((JSONArray)customParams.get("filter_guaranteeid")).toArray());
            this.getModel().setValue("filter_queryway", customParams.get("filter_queryway"));
            this.getModel().setValue("filter_orgview", customParams.get("filter_orgview"));
            this.getModel().setValue("filter_currencyunit", customParams.get("filter_currencyunit"));
            this.getModel().setValue("filter_currency", customParams.get("filter_currency"));
            this.getModel().setValue("filter_statdim", customParams.get("filter_statdim"));
            this.getModel().setValue("filter_cutoffdate", customParams.get("filter_cutoffdate"));
            this.getModel().setValue("filter_guaranteetype", customParams.get("guaranteetype"));
            this.getModel().setValue("filter_guaranteeorgtext", customParams.get("guaranteeorgtext"));
            this.getPageCache().put("filter_guaranteeorgid", this.getStrFromMap(customParams, "guaranteeorg"));
            this.getModel().setValue("filter_reguatype", customParams.get("reguatype"));
            this.getModel().setValue("filter_reguatext", customParams.get("reguatext"));
            this.getPageCache().put("filter_reguaid", this.getStrFromMap(customParams, "reguaid"));
            this.getModel().setValue("filter_creditortype", customParams.get("creditortype"));
            this.getModel().setValue("filter_creditortext", customParams.get("creditortext"));
            this.getPageCache().put("filter_creditorid", this.getStrFromMap(customParams, "creditor"));
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            rptFilter.search();
        }
    }

    private String getStrFromMap(Map<String, Object> customParams, String prop) {
        Object valObj = customParams.get(prop);
        if (valObj instanceof JSONArray) {
            JSONArray val = (JSONArray)valObj;
            if (EmptyUtil.isEmpty((Collection)val)) {
                return null;
            }
            return val.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        return (String)valObj;
    }

    public void beforeQuery(ReportQueryParam param) {
        param.getCustomParam().put("filter_statdim", this.getModel().getValue("filter_statdim"));
        param.getCustomParam().put("filter_dutycurrency", this.getModel().getValue("filter_dutycurrency"));
        String dimension = (String)this.getModel().getValue("filter_statdim");
        boolean isTotal = (Boolean)this.getModel().getValue("filter_istotal") != false && dimension.replaceAll("_", ",").contains("currency");
        param.getFilter().addFilterItem("filter_isshowsubtotal", (Object)isTotal);
        param.getFilter().addFilterItem("filter_isshowtotal", (Object)false);
        param.getCustomParam().put("filter_guaranteeorgid", this.getPageCache().get("filter_guaranteeorgid"));
        param.getCustomParam().put("filter_creditorid", this.getPageCache().get("filter_creditorid"));
        param.getCustomParam().put("filter_reguaid", this.getPageCache().get("filter_reguaid"));
        this.controlTableColumns();
    }

    private void controlTableColumns() {
        String[] curDimensions;
        String dimension = (String)this.getModel().getValue("filter_statdim");
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        ArrayList<String> col = new ArrayList<String>(4);
        ArrayList reportColumns = new ArrayList(4);
        ArrayList reportBillNoColumns = new ArrayList(4);
        for (String curDimension : curDimensions = dimension.split("_")) {
            col.add(dimension);
            if (curDimension.contains("text")) continue;
            col.add(curDimension + "text");
        }
        List columns = listTable.getColumns();
        columns.removeIf(column -> {
            if (column instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)column;
                boolean isDimensions = col.contains(reportColumn.getFieldKey());
                if (isDimensions) {
                    reportColumns.add(reportColumn);
                    return true;
                }
                boolean isBillNo = "billno".equals(reportColumn.getFieldKey());
                if (isBillNo) {
                    reportBillNoColumns.add(reportColumn);
                    return true;
                }
            }
            return false;
        });
        columns.addAll(0, reportColumns);
        columns.addAll(1, reportBillNoColumns);
    }

    public boolean verifyQuery(ReportQueryParam param) {
        FilterInfo filters = param.getFilter();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statdim"))) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst2());
            return false;
        }
        boolean lookupDetail = (Boolean)this.getModel().getValue("lookupdetail");
        if (!lookupDetail) {
            Object beginDate = filters.getFilterItem("filter_begindate").getValue();
            Object cutoffDate = filters.getFilterItem("filter_cutoffdate").getValue();
            Object endDate = filters.getFilterItem("filter_enddate").getValue();
            if (EmptyUtil.isEmpty((Object)cutoffDate)) {
                this.getView().showTipNotification(GmReportResConst.getGmReportResConst6());
                return false;
            }
            if (beginDate != null && ((Date)beginDate).after((Date)cutoffDate)) {
                this.getView().showTipNotification(GmReportResConst.getGmReportResConst7());
                return false;
            }
            if (beginDate != null && endDate != null && ((Date)beginDate).after((Date)endDate)) {
                this.getView().showTipNotification(GmReportResConst.getGmReportResConst8());
                return false;
            }
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_currencyunit"))) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst1());
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst3());
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_dutycurrency"))) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst44());
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("billno".equals(fieldName)) {
            int rowIndex = event.getRowIndex();
            ReportList reportList = (ReportList)event.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            BillShowParameter param = new BillShowParameter();
            param.setFormId("gm_guaranteecontract");
            param.setPkId(rowData.get("id"));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

