/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.form;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.constant.GmReportResConst;
import kd.tmc.gm.form.AbstractGuaranteeContractFormPlugin;

public class GuaranteeUseAnalysesFormPlugin
extends AbstractGuaranteeContractFormPlugin
implements HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeQuery(ReportQueryParam param) {
        Map customParam = param.getCustomParam();
        customParam.put("filter_statcurrency", this.getModel().getValue("filter_statcurrency"));
        customParam.put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        customParam.put("filter_guaranteeorgid", this.getPageCache().get("filter_guaranteeorgid"));
        customParam.put("filter_creditorid", this.getPageCache().get("filter_creditorid"));
    }

    public boolean verifyQuery(ReportQueryParam param) {
        FilterInfo filters = param.getFilter();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst3());
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_currencyunit"))) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst1());
            return false;
        }
        Object beginDate = filters.getFilterItem("filter_begindate").getValue();
        Object cutoffDate = filters.getFilterItem("filter_cutoffdate").getValue();
        if (EmptyUtil.isEmpty((Object)cutoffDate)) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst24());
            return false;
        }
        if (!EmptyUtil.isEmpty((Object)beginDate) && ((Date)beginDate).after((Date)cutoffDate)) {
            this.getView().showTipNotification(GmReportResConst.getGmReportResConst25());
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName) {
            case "g_billno": {
                this.openForm("gm_guaranteecontract", rowData.get("gid"));
                break;
            }
            case "u_billno": {
                this.openForm(rowData.getString("u_gsrcbilltype"), rowData.get("uid"));
            }
        }
    }

    private void openForm(String formId, Object id) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(formId);
        param.setPkId(id);
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("qinganalysis".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gm_guaranteeuse_qing");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm(showParameter);
        }
    }
}

