/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.form.AbstractLetterOfGuaranteeFormPlugin;

public class LetterOfGuaranteeRptFormPlugin
extends AbstractLetterOfGuaranteeFormPlugin {
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "filter_statdim": {
                this.getModel().setValue("filter_finorginfo", null);
                this.getModel().setValue("filter_currency", null);
                this.search();
            }
        }
    }

    @Override
    public void beforeQuery(ReportQueryParam param) {
        super.beforeQuery(param);
        String staDim = (String)this.getModel().getValue("filter_statdim");
        String statDim = this.replaceStaDim(staDim);
        param.getCustomParam().put("filter_statdim", statDim);
        param.getCustomParam().put("filter_level", this.getModel().getValue("filter_level"));
        param.getFilter().addFilterItem("filter_isshowsubtotal", (Object)statDim.contains("_"));
        this.controlTableColumns(statDim);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
    }

    private List<String> allDimension() {
        return Arrays.asList("applyorg", "beneficiary", "finorginfo", "guaranteetype", "currency");
    }

    private void controlTableColumns(String dimension) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        ArrayList<String> col = new ArrayList<String>(4);
        List<String> allDimensions = this.allDimension();
        String[] curdimensions = dimension.split("_");
        List ExcludeDimensions = allDimensions.stream().filter(a -> Arrays.stream(curdimensions).noneMatch(a::equals)).collect(Collectors.toList());
        for (String excludeDimension : ExcludeDimensions) {
            col.add(excludeDimension);
            if (excludeDimension.contains("text")) continue;
            col.add(excludeDimension + "text");
        }
        List columns = listTable.getColumns();
        columns.removeIf(columm -> {
            if (columm instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)columm;
                return col.contains(reportColumn.getFieldKey());
            }
            return false;
        });
    }

    private String replaceStaDim(String dimension) {
        if (this.isSendBizType()) {
            return dimension.replace("company", "applyorg");
        }
        return dimension.replace("company", "beneficiary");
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if ("detail".equals(operateKey)) {
            this.lookUpDetail();
        }
    }

    private void lookUpDetail() {
        boolean isCheck = this.verifyQueryParam();
        if (!isCheck) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObjectCollection applyOrg = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        DynamicObjectCollection beneficiary = (DynamicObjectCollection)this.getModel().getValue("filter_beneficiary_org");
        DynamicObjectCollection finorginfo = (DynamicObjectCollection)this.getModel().getValue("filter_finorginfo");
        String applyOrgs = applyOrg.stream().map(e -> String.valueOf(((DynamicObject)e.get("fbasedataid")).getPkValue())).collect(Collectors.joining(","));
        String beneficiarys = beneficiary.stream().map(e -> String.valueOf(((DynamicObject)e.get("fbasedataid")).getPkValue())).collect(Collectors.joining(","));
        String finorginfos = finorginfo.stream().map(e -> String.valueOf(((DynamicObject)e.get("fbasedataid")).getPkValue())).collect(Collectors.joining(","));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_currency");
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
        DynamicObject beneficiaryOrgv = (DynamicObject)this.getModel().getValue("filter_beneficiary_orgv");
        map.put("filter_cutoffdate", this.getModel().getValue("filter_cutoffdate"));
        map.put("filter_startdate", this.getModel().getValue("filter_startdate"));
        map.put("startdateranges_startdate", this.getModel().getValue("startdateranges_startdate"));
        map.put("startdateranges_enddate", this.getModel().getValue("startdateranges_enddate"));
        map.put("filter_queryway", this.getModel().getValue("filter_queryway"));
        map.put("filter_orgview", EmptyUtil.isNoEmpty((DynamicObject)orgView) ? orgView.getPkValue() : null);
        map.put("filter_beneficiary_orgv", EmptyUtil.isNoEmpty((DynamicObject)beneficiaryOrgv) ? beneficiaryOrgv.getPkValue() : null);
        map.put("filter_beneficiary_org", beneficiarys);
        map.put("filter_org", applyOrgs);
        map.put("filter_biztype", this.getModel().getValue("filter_biztype"));
        map.put("filter_finorginfo", finorginfos);
        map.put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        map.put("filter_statcurrency", statCurrency != null ? statCurrency.getPkValue() : null);
        map.put("filter_currency", currency != null ? currency.getPkValue() : null);
        map.put("detail", Boolean.TRUE);
        map.put("filter_hascanceled", this.getModel().getValue("filter_hascanceled"));
        map.put("filter_hasclaimed", this.getModel().getValue("filter_hasclaimed"));
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("gm_letterofguarantee_dtl");
        param.setCustomParams(map);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }
}

