/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.contract;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;

public class GuaranteeContractList
extends AbstractTmcBillBaseList {
    private static final String[] gcProps = new String[]{"gsrcbilltype", "gsrcbillid", "gdebtcurrency", "gdebtbalance", "gexchrate", "gdebtenddate"};

    public void setFilter(SetFilterEvent e) {
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter == null) {
            return;
        }
        QFilter guaranteeOrgFilter = new QFilter("entry_guaranteeorg.a_guaranteetype", "=", (Object)GuaranteeTypeEnum.TMCORG.getValue()).and(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", mainOrgQFilter.getValue()));
        QFilter reGuaranteeOrgFilter = new QFilter("entry_guaranteedorg.b_reguaranteetype", "=", (Object)GuaranteeTypeEnum.TMCORG.getValue()).and(new QFilter("entry_guaranteedorg.b_guaranteedorg", "in", mainOrgQFilter.getValue()));
        QFilter orgFilter = mainOrgQFilter.or(guaranteeOrgFilter).or(reGuaranteeOrgFilter);
        e.setMainOrgQFilter(orgFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opr = args.getOperationResult();
        if (opr != null && opr.isSuccess()) {
            switch (operateKey) {
                case "billclose": 
                case "billunclose": {
                    BillList billList = (BillList)this.getControl("billlistap");
                    billList.refreshData();
                    break;
                }
                case "change": {
                    this.openApplyForm();
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            if (!"org.name".equals(commonFilter.getFieldName())) continue;
            commonFilter.setDefaultValue(null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("change".equals(operateKey)) {
            Long selected = this.getSelectedId();
            if (selected == null) {
                args.setCancel(true);
            }
        } else if ("billclose".equals(operateKey)) {
            Long selected = this.getSelectedId();
            if (selected == null) {
                args.setCancel(true);
                return;
            }
            if (!this.checkCanClose(selected) && !this.getPageCache().getAll().containsKey("passClose")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u8054\u7684\u878d\u8d44\u4e1a\u52a1\u672a\u7ed3\u6e05\uff0c\u786e\u8ba4\u662f\u5426\u624b\u5de5\u5173\u95ed\u62c5\u4fdd\u5355\uff1f", (String)"GuaranteeContractList_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("closeConfig", (IFormPlugin)this));
                args.setCancel(true);
            }
            this.getPageCache().remove("passClose");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("billno".equals(fieldName)) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentRow = billList.getCurrentSelectedRowInfo();
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            selectedRows.clear();
            selectedRows.add((Object)currentRow);
            QFilter qFilter = new QFilter("id", "=", billList.getFocusRowPkId());
            DynamicObjectCollection guaConBillCol = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"org,entry_guaranteeorg.a_guaranteeorg,entry_guaranteedorg.b_guaranteedorg", (QFilter[])qFilter.toArray());
            List<Long> permissionOrgIds = this.getPermissionOrgIds();
            for (DynamicObject guaConBill : guaConBillCol) {
                if (permissionOrgIds == null || permissionOrgIds.contains(guaConBill.getLong("org")) || !permissionOrgIds.contains(guaConBill.getLong("entry_guaranteeorg.a_guaranteeorg")) && !permissionOrgIds.contains(guaConBill.getLong("entry_guaranteedorg.b_guaranteedorg"))) continue;
                args.setCancel(true);
                this.showBill(billList.getFocusRowPkId());
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"closeConfig", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("passClose", "true");
            this.getView().invokeOperation("billclose");
        }
    }

    private boolean checkCanClose(Long billId) {
        QFilter gQF = new QFilter("gcontract.id", "=", (Object)billId);
        gQF.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObjectCollection gcUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", gcProps), (QFilter[])gQF.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)gcUseBills)) {
            return true;
        }
        DynamicObject[] gcUseBillArr = GuaranteeUseHelper.removeExpireData((DynamicObject[])((DynamicObject[])gcUseBills.toArray((Object[])new DynamicObject[gcUseBills.size()])));
        DynamicObject gContractCcy = this.getContractBill(billId);
        Long gContractCcyId = (Long)gContractCcy.getPkValue();
        for (DynamicObject gcBIll : gcUseBillArr) {
            if ("cfm_creditlimit".equals(gcBIll.get("gsrcbilltype"))) continue;
            BigDecimal debtBalance = gcBIll.getBigDecimal("gdebtbalance");
            Long debtBillCcy = gcBIll.getLong("gdebtcurrency");
            if (!gContractCcyId.equals(debtBillCcy) && debtBalance.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal gExchRate = gcBIll.getBigDecimal("gexchrate");
                debtBalance = debtBalance.multiply(gExchRate);
            }
            if (BigDecimal.ZERO.compareTo(debtBalance) == 0) continue;
            return false;
        }
        return true;
    }

    private DynamicObject getContractBill(Long billId) {
        return TmcDataServiceHelper.loadSingle((Object)billId, (String)"gm_guaranteecontract", (String)"currency");
    }

    private void openApplyForm() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("gm_guaranteeapply");
        showParameter.setCustomParam("guaContractId", (Object)this.getSelectedId());
        showParameter.setCustomParam("change", (Object)Boolean.TRUE);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setBillStatus(BillOperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> getPermissionOrgIds() {
        Map pageCache = this.getPageCache().getAll();
        String orgIds = (String)pageCache.get("org");
        if (EmptyUtil.isNoEmpty((String)orgIds)) {
            return Arrays.stream(orgIds.split("-")).map(Long::parseLong).collect(Collectors.toList());
        }
        RequestContext req = RequestContext.get();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getCacheUserPermission((Long)req.getCurrUserId(), (String)appId, (String)"gm_guaranteecontract", (String)"47150e89000000ac");
        if (authOrgIds == null) {
            return null;
        }
        this.getPageCache().put("org", authOrgIds.stream().map(String::valueOf).collect(Collectors.joining("-")));
        return authOrgIds;
    }

    private void showBill(Object id) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId(id);
        parameter.setFormId("gm_guaranteecontract");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setHasRight(false);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

