/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.debt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.common.helper.BaseDebtRegisterHelper;

public class DebtRegisterDynamicPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(DebtRegisterDynamicPlugin.class);
    public static final String SAVE = "save";
    public static final String DELETE = "delete";
    public static final String SUBMIT = "submit";
    public static final String UN_SUBMIT = "unsubmit";
    public static final String AUDIT = "audit";
    public static final String UN_AUDIT = "unaudit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit gmOrg = (BasedataEdit)this.getView().getControl("org");
        gmOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit gmBillNo = (BasedataEdit)this.getView().getControl("gmbillno");
        gmBillNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.equals("NEW", formShowParameter.getCustomParam("operateType"))) {
            this.initDebtRegister();
        } else if (Objects.equals("RELEASE", formShowParameter.getCustomParam("operateType"))) {
            this.releaseDebtRegister();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{UN_SUBMIT, AUDIT, UN_AUDIT});
    }

    private void hideFields(String[] hideFields) {
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])hideFields, (boolean)false);
    }

    private void releaseDebtRegister() {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long debtRegisterId = (Long)formShowParameter.getCustomParam("debtRegisterId");
        DynamicObject dynamicObject = BaseDebtRegisterHelper.loadSingleDebtRegisterById((Long)debtRegisterId);
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("debtregisterdetails");
        this.setEntryRow(dynamicObject, entryCurrentRowIndex);
        this.setStyle(entryCurrentRowIndex);
    }

    private void setEntryRow(DynamicObject dynamicObject, int rowIndex) {
        IDataModel model = this.getView().getModel();
        model.setEntryCurrentRowIndex("debtregisterdetails", rowIndex);
        model.setValue("bindid", dynamicObject.get("bindid"));
        model.setValue("rootid", dynamicObject.getPkValue());
        model.setValue("org", dynamicObject.get("org"));
        model.setValue("registerpeople", dynamicObject.get("registerpeople"));
        model.setValue("gmbillno", (Object)dynamicObject.getDynamicObject("gmbillno"), rowIndex);
        model.setValue("changetype", (Object)DebtChangeTypeEnum.DEBT_RELEASE.getValue(), rowIndex);
        model.setValue("reguaranteetype", dynamicObject.get("reguaranteetype"), rowIndex);
        model.setValue("guaranteedorg", dynamicObject.get("guaranteedorg"), rowIndex);
        model.setValue("guaranteedorgtext", dynamicObject.get("guaranteedorgtext"), rowIndex);
        model.setValue("creditortext", dynamicObject.get("creditortext"), rowIndex);
        model.setValue("begindate", dynamicObject.get("begindate"), rowIndex);
        model.setValue("enddate", dynamicObject.get("enddate"), rowIndex);
        model.setValue("businesscode", dynamicObject.get("businesscode"), rowIndex);
        model.setValue("currency", (Object)dynamicObject.getDynamicObject("currency"), rowIndex);
        model.setValue("convertrate", dynamicObject.get("convertrate"), rowIndex);
        model.setValue("amount", dynamicObject.get("amount"), rowIndex);
        model.setValue("guaranteerate", dynamicObject.get("guaranteerate"), rowIndex);
        model.setValue("leftreleaseamount", (Object)this.calLeftReleaseAmount(dynamicObject.getPkValue()), rowIndex);
        model.setValue("remark", dynamicObject.get("remark"), rowIndex);
        model.setValue("isfinance", dynamicObject.get("isfinance"), rowIndex);
        model.setValue("uniquecode", (Object)UUID.randomUUID().toString(), rowIndex);
    }

    private BigDecimal calLeftReleaseAmount(Object id) {
        DynamicObject occupyDebtBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"gm_debt_register", (String)"occupyamount");
        BigDecimal occupyAmount = occupyDebtBill.getBigDecimal("occupyamount");
        QFilter debtFilter = new QFilter("changetype", "=", (Object)DebtChangeTypeEnum.DEBT_RELEASE.getValue()).and(new QFilter("rootid", "=", (Object)id.toString()));
        DynamicObjectCollection releaseDebtBills = QueryServiceHelper.query((String)"gm_debt_register", (String)"releaseamount", (QFilter[])new QFilter[]{debtFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)releaseDebtBills)) {
            return occupyAmount;
        }
        BigDecimal releaseAmountTotal = BigDecimal.ZERO;
        for (DynamicObject debtBill : releaseDebtBills) {
            releaseAmountTotal = releaseAmountTotal.add(debtBill.getBigDecimal("releaseamount"));
        }
        return occupyAmount.subtract(releaseAmountTotal);
    }

    private void setStyle(int rowIndex) {
        this.lockField(Arrays.asList("org", "registerpeople", "gmbillno", "changetype", "reguaranteetype", "guaranteedorgtext", "creditortext", "businesscode", "begindate", "enddate", "businesscode", "currency", "convertrate", "amount", "guaranteerate", "leftreleaseamount", "remark", "isfinance"), rowIndex);
        this.hideFields(new String[]{"occupyamount"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap"});
    }

    private void lockField(List<String> lockFields, int rowIndex) {
        IFormView view = this.getView();
        for (String lockField : lockFields) {
            FieldEdit lockFieldEdit = (FieldEdit)view.getControl(lockField);
            if (!Objects.nonNull(lockFieldEdit)) continue;
            lockFieldEdit.setEnable("", false, rowIndex);
        }
    }

    private void initDebtRegister() {
        DynamicObject currentOrg = TmcOrgDataHelper.getCurrentOrg();
        this.getModel().setValue("org", (Object)currentOrg);
        this.getModel().setValue("registerpeople", (Object)RequestContext.get().getUserName());
        this.getModel().setValue("groupid", (Object)UUID.randomUUID().toString());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("debtregisterdetails");
        long[] bindIds = DB.genLongIds((String)"t_gm_debtregister", (int)entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            dynamicObject.set("changetype", (Object)DebtChangeTypeEnum.DEBT_OCCUPY.getValue());
            dynamicObject.set("bindid", (Object)bindIds[i]);
            dynamicObject.set("uniquecode", (Object)UUID.randomUUID().toString());
        }
        this.hideFields(new String[]{"releaseamount", "leftreleaseamount"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("operateType");
        if (Objects.equals(customParam, "NEW")) {
            int rowIndex = model.getEntryRowCount("debtregisterdetails") - 1;
            FieldEdit changeTypeField = (FieldEdit)view.getControl("changetype");
            model.setValue("changetype", (Object)DebtChangeTypeEnum.DEBT_OCCUPY.getValue(), rowIndex);
            model.setValue("bindid", (Object)DB.genLongId((String)"t_gm_debtregister"), rowIndex);
            changeTypeField.setEnable("", false, e.getInsertRow());
            model.setValue("uniquecode", (Object)UUID.randomUUID().toString(), rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "org": {
                this.orgF7Evt(evt);
                break;
            }
            case "gmbillno": {
                this.gmContractF7Evt(evt);
            }
        }
    }

    private void gmContractF7Evt(BeforeF7SelectEvent evt) {
        Object org = this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u767b\u8bb0\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"DebtRegisterDynamicPlugin_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", ((DynamicObject)org).getPkValue()));
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_debt_register", (String)"47150e89000000ac");
        qFilters.add(new QFilter("org.id", "in", (Object)orgIdList));
        evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gmbillno"));
    }

    public void orgF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_debt_register", (String)"47150e89000000ac");
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIdList));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(event);
        String key = event.getActionId();
        if ("gmbillno".equals(key) && EmptyUtil.isNoEmpty((Object)(selectedRows = (ListSelectedRowCollection)event.getReturnData())) && selectedRows.size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject contract = QueryServiceHelper.queryOne((String)"gm_guaranteecontract", (String)"billno,entry_guaranteedorg,entry_guaranteedorg.b_reguaranteetype,entry_guaranteedorg.b_guaranteedorg,entry_guaranteedorg.b_guaranteedorgtext,creditortext,currency", (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
            this.setCardEntryValue("gmbillno", primaryKeyValue);
            String reGuaranteeType = contract.getString(String.join((CharSequence)".", "entry_guaranteedorg", "b_reguaranteetype"));
            this.setCardEntryValue("reguaranteetype", GuaranteeTypeEnum.ORG.getValue().equals(reGuaranteeType) ? GuaranteeTypeEnum.TMCORG.getValue() : reGuaranteeType);
            this.setCardEntryValue("guaranteedorg", 0L);
            this.setCardEntryValue("guaranteedorgtext", "");
            this.setCardEntryValue("creditortext", contract.getString("creditortext"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIdx = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "org": {
                this.getModel().deleteEntryData("debtregisterdetails");
                break;
            }
            case "gmbillno": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reguaranteetype", (Object)"", (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteedorg", (Object)0L, (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteedorgtext", (Object)"", (int)rowIdx);
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    DynamicObject gmContract = (DynamicObject)newValue;
                    String reGuaranteeType = ((DynamicObject)gmContract.getDynamicObjectCollection("entry_guaranteedorg").get(0)).getString("b_reguaranteetype");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reguaranteetype", (Object)(GuaranteeTypeEnum.ORG.getValue().equals(reGuaranteeType) ? GuaranteeTypeEnum.TMCORG.getValue() : reGuaranteeType), (int)rowIdx);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditortext", (Object)gmContract.getString("creditortext"), (int)rowIdx);
                    int rowCount = this.getModel().getEntryRowCount("debtregisterdetails");
                    for (int i = rowIdx; i < rowCount; ++i) {
                        if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("gmbillno", i))) continue;
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditortext", (Object)gmContract.getString("creditortext"), (int)i);
                    }
                }
            }
            case "currency": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("gmbillno", rowIdx);
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rowIdx);
                Long currentOrgId = TmcOrgDataHelper.getCurrentOrg().getLong("id");
                if (!EmptyUtil.isNoEmpty((DynamicObject)contract) || !EmptyUtil.isNoEmpty((DynamicObject)currency)) break;
                if (Long.valueOf(currency.getLong("id")).equals(contract.getDynamicObject("currency").getLong("id"))) {
                    this.setCardEntryValue("convertrate", BigDecimal.ONE);
                    this.setCardEnable(false, "convertrate");
                } else {
                    Long currencyId = currency.getLong("id");
                    Long baseCurrencyId = contract.getDynamicObject("currency").getLong("id");
                    BigDecimal exchangeRate = TmcBusinessBaseHelper.getExchangeRate((long)currencyId, (long)baseCurrencyId, (long)currentOrgId, (Date)DateUtils.getCurrentDate());
                    this.setCardEntryValue("convertrate", exchangeRate);
                    this.setCardEnable(true, "convertrate");
                }
                int rowCount = this.getModel().getEntryRowCount("debtregisterdetails");
                for (int i = rowIdx; i < rowCount; ++i) {
                    DynamicObject curContract = (DynamicObject)this.getModel().getValue("gmbillno", i);
                    DynamicObject curCurrency = (DynamicObject)this.getModel().getValue("currency", i);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)curContract) || !EmptyUtil.isNoEmpty((DynamicObject)curCurrency)) continue;
                    if (Long.valueOf(curCurrency.getLong("id")).equals(curContract.getDynamicObject("currency").getLong("id"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"convertrate", (Object)BigDecimal.ONE, (int)i);
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"convertrate"});
                        continue;
                    }
                    Long currencyId = curCurrency.getLong("id");
                    Long baseCurrencyId = curContract.getDynamicObject("currency").getLong("id");
                    BigDecimal exchangeRate = TmcBusinessBaseHelper.getExchangeRate((long)currencyId, (long)baseCurrencyId, (long)currentOrgId, (Date)DateUtils.getCurrentDate());
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"convertrate", (Object)exchangeRate, (int)i);
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"convertrate"});
                }
                break;
            }
            case "amount": 
            case "guaranteerate": {
                BigDecimal amount = (BigDecimal)this.getCardEntryValue("amount");
                BigDecimal guaranteeRate = (BigDecimal)this.getCardEntryValue("guaranteerate");
                if (!EmptyUtil.isNoEmpty((BigDecimal)amount) || !EmptyUtil.isNoEmpty((BigDecimal)guaranteeRate)) break;
                this.setCardEntryValue("occupyamount", amount.multiply(guaranteeRate.divide(new BigDecimal("100"))));
                break;
            }
            case "reguaranteetype": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteedorg", (Object)0L, (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"guaranteedorgtext", (Object)"", (int)rowIdx);
                break;
            }
        }
    }

    private Object getCardEntryValue(String propName) {
        Integer rowIndex = this.getModel().getEntryCurrentRowIndex("debtregisterdetails");
        return this.getModel().getValue(propName, rowIndex.intValue(), 0);
    }

    private void setCardEntryValue(String propName, Object value) {
        Integer rowIndex = this.getModel().getEntryCurrentRowIndex("debtregisterdetails");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)value, (int)rowIndex, (int)0);
    }

    private void setCardEnable(Boolean value, String ... propName) {
        Integer parentRowIndex = this.getModel().getEntryCurrentRowIndex("debtregisterdetails");
        this.getView().setEnable(value, parentRowIndex.intValue(), propName);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String itemKey = evt.getItemKey();
        if (Objects.equals(itemKey, SAVE) || Objects.equals(itemKey, SUBMIT)) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("debtregisterdetails");
            if (dynamicObjectCollection.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5206\u5f55\u6570\u636e\u3002", (String)"DebtRegisterDynamicPlugin_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (Objects.equals("RELEASE", formShowParameter.getCustomParam("operateType")) && EmptyUtil.isEmpty((BigDecimal)((DynamicObject)dynamicObjectCollection.get(0)).getBigDecimal("releaseamount"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u91ca\u653e\u62c5\u4fdd\u91d1\u989d\u201d\u3002", (String)"DebtRegisterDynamicPlugin_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (!this.isDataChanged(itemKey) || this.updateValidate(itemKey)) {
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        if (Objects.equals(itemKey, SUBMIT)) {
            DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity("debtregisterdetails");
            DynamicObject[] dynamicObjectArr = new DynamicObject[dynamicObjectCollection.size()];
            this.fillDynamicObjectArr(dynamicObjectArr, dynamicObjectCollection);
            this.execOperate(SUBMIT, dynamicObjectArr);
            this.execDelete(dynamicObjectCollection);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SUBMIT, SAVE, UN_AUDIT, "advcontoolbarap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{UN_SUBMIT, AUDIT});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataflex"});
            this.refreshLeftReleaseAmount();
        } else if (Objects.equals(itemKey, SAVE)) {
            DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity("debtregisterdetails");
            DynamicObject[] dynamicObjectArr = new DynamicObject[dynamicObjectCollection.size()];
            this.fillDynamicObjectArr(dynamicObjectArr, dynamicObjectCollection);
            this.execOperate(SAVE, dynamicObjectArr);
            this.execDelete(dynamicObjectCollection);
            this.refreshLeftReleaseAmount();
        } else if (Objects.equals(itemKey, AUDIT)) {
            this.execOperate(AUDIT);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{UN_AUDIT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{AUDIT, UN_SUBMIT});
        } else if (Objects.equals(itemKey, UN_AUDIT)) {
            this.execOperate(UN_AUDIT);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SAVE, SUBMIT, "advcontoolbarap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{UN_AUDIT});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"dataflex"});
        } else if (Objects.equals(itemKey, UN_SUBMIT)) {
            this.execOperate(UN_SUBMIT);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SAVE, SUBMIT, "advcontoolbarap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{UN_SUBMIT, AUDIT});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"dataflex"});
        }
    }

    private boolean updateValidate(String itemKey) {
        String uniqueCode = (String)this.getModel().getValue("uniquecode", 0);
        DynamicObject debtRegisterDb = BaseDebtRegisterHelper.loadDebtRegisterByUniqueCode((String)uniqueCode);
        BigDecimal releaseAmount = (BigDecimal)this.getCardEntryValue("releaseamount");
        BigDecimal leftReleaseAmount = (BigDecimal)this.getCardEntryValue("leftreleaseamount");
        if (EmptyUtil.isNoEmpty((BigDecimal)releaseAmount) && (EmptyUtil.isEmpty((DynamicObject)debtRegisterDb) && releaseAmount.compareTo(leftReleaseAmount) > 0 || Objects.equals(itemKey, SAVE) && EmptyUtil.isNoEmpty((DynamicObject)debtRegisterDb) && releaseAmount.subtract(debtRegisterDb.getBigDecimal("releaseamount")).compareTo(leftReleaseAmount) > 0)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u6b21\u91ca\u653e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5269\u4f59\u53ef\u91ca\u653e\u91d1\u989d\u3002", (String)"DebtRegisterDynamicPlugin_3", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isDataChanged(String itemKey) {
        if (Objects.equals(itemKey, SAVE) && !this.getModel().getDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"DebtRegisterDynamicPlugin_4", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void refreshLeftReleaseAmount() {
        if (Objects.equals(this.getCardEntryValue("changetype"), DebtChangeTypeEnum.DEBT_OCCUPY.getValue())) {
            return;
        }
        this.setCardEntryValue("leftreleaseamount", this.calLeftReleaseAmount(this.getCardEntryValue("rootid")));
    }

    private void fillDynamicObjectArr(DynamicObject[] dynamicObjectArr, DynamicObjectCollection dynamicObjectCollection) {
        IDataModel model = this.getModel();
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject debtRegister;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            DynamicObject loadByUniqueCode = BaseDebtRegisterHelper.loadDebtRegisterByUniqueCode((String)((DynamicObject)dynamicObjectCollection.get(i)).getString("uniquecode"));
            DynamicObject dynamicObject2 = debtRegister = loadByUniqueCode == null ? BusinessDataServiceHelper.newDynamicObject((String)"gm_debt_register") : loadByUniqueCode;
            if (loadByUniqueCode == null) {
                debtRegister.set("creator", (Object)RequestContext.get().getCurrUserId());
                debtRegister.set("createtime", (Object)new Date());
            }
            debtRegister.set("bindid", dynamicObject.get("bindid"));
            debtRegister.set("rootid", dynamicObject.get("rootid"));
            debtRegister.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            debtRegister.set("org", model.getValue("org"));
            debtRegister.set("groupid", model.getValue("groupid"));
            debtRegister.set("uniquecode", dynamicObject.get("uniquecode"));
            debtRegister.set("registerdate", model.getValue("registerdate"));
            debtRegister.set("registerpeople", model.getValue("registerpeople"));
            debtRegister.set("description", model.getValue("description"));
            debtRegister.set("gmbillno", dynamicObject.get("gmbillno"));
            debtRegister.set("changetype", dynamicObject.get("changetype"));
            debtRegister.set("reguaranteetype", dynamicObject.get("reguaranteetype"));
            debtRegister.set("guaranteedorg", dynamicObject.get("guaranteedorg"));
            debtRegister.set("guaranteedorgtext", dynamicObject.get("guaranteedorgtext"));
            debtRegister.set("creditortext", dynamicObject.get("creditortext"));
            debtRegister.set("begindate", dynamicObject.get("begindate"));
            debtRegister.set("enddate", dynamicObject.get("enddate"));
            debtRegister.set("businesscode", dynamicObject.get("businesscode"));
            debtRegister.set("currency", dynamicObject.get("currency"));
            debtRegister.set("convertrate", dynamicObject.get("convertrate"));
            debtRegister.set("amount", dynamicObject.get("amount"));
            debtRegister.set("guaranteerate", dynamicObject.get("guaranteerate"));
            if (DebtChangeTypeEnum.DEBT_OCCUPY.getValue().equals(dynamicObject.getString("changetype"))) {
                debtRegister.set("occupyamount", dynamicObject.get("occupyamount"));
            } else {
                debtRegister.set("releaseamount", dynamicObject.get("releaseamount"));
            }
            debtRegister.set("remark", dynamicObject.get("remark"));
            debtRegister.set("isfinance", dynamicObject.get("isfinance"));
            dynamicObjectArr[i] = debtRegister;
        }
    }

    private void execOperate(String operationKey, DynamicObject[] dynamicObjectArr) {
        ArrayList<DynamicObject> saveDynamicObjectArr = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateDynamicObjectArr = new ArrayList<DynamicObject>();
        for (int i = 0; i < dynamicObjectArr.length; ++i) {
            if ((Long)dynamicObjectArr[i].getPkValue() == 0L) {
                saveDynamicObjectArr.add(dynamicObjectArr[i]);
                continue;
            }
            updateDynamicObjectArr.add(dynamicObjectArr[i]);
        }
        try {
            TmcOperateServiceHelper.execOperate((String)operationKey, (String)"gm_debt_register", (DynamicObject[])saveDynamicObjectArr.toArray(new DynamicObject[0]), (OperateOption)this.getOperateOption());
            TmcOperateServiceHelper.execOperate((String)operationKey, (String)"gm_debt_register", (DynamicObject[])updateDynamicObjectArr.toArray(new DynamicObject[0]), (OperateOption)this.getOperateOption());
        }
        catch (Exception e) {
            logger.error(operationKey + "\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private void execOperate(String operationKey) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("debtregisterdetails");
        Object[] bindIds = new Object[dynamicObjectCollection.size()];
        for (int i = 0; i < bindIds.length; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            DynamicObject loadById = BaseDebtRegisterHelper.loadSingleDebtRegisterByUniqueCode((String)dynamicObject.getString("uniquecode"));
            bindIds[i] = loadById.getPkValue();
        }
        TmcOperateServiceHelper.execOperate((String)operationKey, (String)"gm_debt_register", (Object[])bindIds, (OperateOption)this.getOperateOption());
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("strictvalidation", String.valueOf(true));
        option.setVariableValue("isDynamicBillOp", String.valueOf(true));
        return option;
    }

    private void execDelete(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null || Objects.equals(((DynamicObject)dynamicObjectCollection.get(0)).getString("changetype"), DebtChangeTypeEnum.DEBT_RELEASE.getValue())) {
            return;
        }
        String groupId = (String)this.getModel().getValue("groupid");
        DynamicObject[] dynamicObjects = BaseDebtRegisterHelper.loadDebtRegisterByGroupId((String)groupId);
        Set currentSubmitBindIdSet = dynamicObjectCollection.stream().map(d -> d.get("bindid")).collect(Collectors.toSet());
        Set fromDbDynamicObjectSet = Arrays.stream(dynamicObjects).collect(Collectors.toSet());
        fromDbDynamicObjectSet.removeIf(r -> currentSubmitBindIdSet.contains(((DynamicObject)r).get("bindid")));
        if (!fromDbDynamicObjectSet.isEmpty()) {
            TmcOperateServiceHelper.execOperate((String)DELETE, (String)"gm_debt_register", (Object[])fromDbDynamicObjectSet.stream().map(f -> ((DynamicObject)f).getPkValue()).distinct().toArray(Object[]::new), (OperateOption)this.getOperateOption());
        }
    }
}

