/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.home;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuarDutyAnalysisHistogramChartPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GuarDutyAnalysisHistogramChartPlugin.class);
    private static final String CHART_PROP = "histogramchartap";
    private static final String GUARANTEE_CONTRACT_PROPS = "id,guaranteedorg,guaranteedorgtext,currency";
    private static final String GUARANTEE_CONTRACT_DUTY_PROPS = "gcontract.id as contractId,gdebtbalance,gexchrate,gdebtbalance*gexchrate as dutyamount";
    private static final int SIZE = 15;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshChart();
    }

    private void refreshChart() {
        Map<String, BigDecimal> map = this.selectData();
        if (map == null || map.isEmpty()) {
            return;
        }
        List<Map.Entry<String, BigDecimal>> list = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        if (list.size() > 15) {
            list = list.subList(list.size() - 15, list.size());
        }
        HistogramChart chart = (HistogramChart)this.getControl(CHART_PROP);
        this.setStyle(chart);
        chart.clearData();
        this.createYAxis(chart, list.stream().map(a -> (String)a.getKey()).collect(Collectors.toList()));
        this.createXAxis(chart);
        this.setData(chart, list);
    }

    private void setStyle(HistogramChart chart) {
        chart.setName(new LocaleString(ResManager.loadKDString((String)"\u63d0\u4f9b\u62c5\u4fdd \u8d23\u4efb\u91d1\u989d\u524d15", (String)"GuarDutyAnalysisHistogramChartPlugin_1", (String)"tmc-gm-formplugin", (Object[])new Object[0])));
        chart.setMargin(Position.left, "30px");
        chart.setMargin(Position.right, "120px");
        chart.setMargin(Position.top, "30px");
        chart.setMargin(Position.bottom, "30px");
        chart.setShowLegend(true);
        chart.setLegendPropValue("itemWidth", (Object)10);
        chart.setLegendPropValue("itemHeight", (Object)10);
        chart.setLegendVertical(true);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setShowTooltip(true);
    }

    private void createYAxis(HistogramChart chart, List<String> guaranteedOrg) {
        Axis yAxis = chart.createYAxis("", AxisType.category);
        yAxis.setCategorys(guaranteedOrg);
        yAxis.setPosition(Position.bottom);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 55, 0, 0});
        yAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        yAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(yAxis);
    }

    private void createXAxis(HistogramChart chart) {
        Axis xAxis = chart.createXAxis("", AxisType.value);
        xAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 0, 5, -45});
        xAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", false);
        xAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(xAxis);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("rotate", "-15");
        axisLabel.put("inside", false);
        axisLabel.put("margin", "6");
        xAxis.setPropValue("axisLabel", axisLabel);
    }

    private void setData(HistogramChart chart, List<Map.Entry<String, BigDecimal>> list) {
        BarSeries barSeries = this.createBarSeries(chart, ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u91d1\u989d", (String)"GuarDutyAnalysisHistogramChartPlugin_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]), "#20A7F0", list.stream().map(a -> (String)a.getKey()).collect(Collectors.toList()));
        barSeries.setData((Number[])list.stream().map(a -> (BigDecimal)a.getValue()).collect(Collectors.toList()).toArray(new BigDecimal[0]));
        chart.bindData(null);
    }

    private BarSeries createBarSeries(HistogramChart chart, String name, String color, List<String> guaranteedOrg) {
        BarSeries barSeries = chart.createBarSeries(name);
        if (guaranteedOrg.size() <= 2) {
            barSeries.setBarWidth("15px");
        } else {
            barSeries.setBarWidth("10px");
        }
        barSeries.setAnimationDuration(1500);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> itemStyle = new HashMap<String, HashMap<String, String>>();
        map.put("color", String.format("new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '%s'}, {\"offset\": 1, \"color\": '%s'}])", color, color));
        itemStyle.put("normal", map);
        barSeries.setPropValue("itemStyle", itemStyle);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setLabel(null);
        return barSeries;
    }

    private void setLineColor(Axis axis) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    private Map<String, BigDecimal> selectData() {
        long currentOrgId = TmcOrgDataHelper.getCurrentOrgId();
        DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)currentOrgId);
        if (EmptyUtil.isEmpty((DynamicObject)baseCurrency)) {
            return null;
        }
        long baseCurrencyId = baseCurrency.getLong("id");
        DataSet guaranteeContractDs = this.selectGuaranteeContractBillList();
        DataSet contractDutyDs = this.selectContractDutyAmt();
        guaranteeContractDs = guaranteeContractDs.copy().leftJoin(contractDutyDs).on("id", "contractId").select(GUARANTEE_CONTRACT_PROPS.split(","), new String[]{"dutyamount"}).finish();
        try {
            ArrayList currencyIdList = new ArrayList(10);
            guaranteeContractDs.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
            DataSet exchangeRateDS = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)baseCurrencyId, (long)currentOrgId, (Date)DateUtils.getCurrentDate(), (boolean)true);
            exchangeRateDS = exchangeRateDS.addField("rate", "exchrate");
            String columnStr = String.join((CharSequence)",", GUARANTEE_CONTRACT_PROPS, "dutyamount, exchrate");
            DataSet resultDS = guaranteeContractDs.leftJoin(exchangeRateDS).on("currency", "tarcurrency").select(columnStr.split(",")).finish();
            resultDS.updateField("dutyamount", "dutyamount*exchrate");
            resultDS = resultDS.copy().groupBy(new String[]{"guaranteedorgtext"}).sum("dutyamount").finish();
            TreeMap<String, BigDecimal> map = new TreeMap<String, BigDecimal>();
            for (Row contractDatum : resultDS.copy()) {
                BigDecimal dutyAmount = contractDatum.getBigDecimal("dutyamount");
                map.put(contractDatum.getString("guaranteedorgtext"), EmptyUtil.isEmpty((BigDecimal)dutyAmount) ? BigDecimal.ZERO : dutyAmount.setScale(6, 4));
            }
            return map;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6c47\u7387\u8f6c\u6362\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    private DataSet selectGuaranteeContractBillList() {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("bizstatus", "!=", (Object)"closed"));
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_guaranteecontract", (String)"47150e89000000ac");
        qFilter.and(new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", (Object)orgIds));
        return QueryServiceHelper.queryDataSet((String)"guaranteeContract", (String)"gm_guaranteecontract", (String)GUARANTEE_CONTRACT_PROPS, (QFilter[])qFilter.toArray(), null);
    }

    public DataSet selectContractDutyAmt() {
        QFilter gcFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        gcFilter.and(new QFilter("gsrcbilltype", "!=", (Object)"cfm_creditlimit"));
        DataSet guaranteeUseDs = QueryServiceHelper.queryDataSet((String)"guaranteeUse", (String)"gm_guaranteeuse", (String)GUARANTEE_CONTRACT_DUTY_PROPS, (QFilter[])gcFilter.toArray(), null);
        return guaranteeUseDs.copy().groupBy(new String[]{"contractId"}).sum("dutyamount").finish();
    }
}

