/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LetterOfGuaranteeAnalysisHistogramChartPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(LetterOfGuaranteeAnalysisHistogramChartPlugin.class);
    private static final String CHART_PROP = "piechartap";
    private static final String LETTER_OF_GUARANTEE_PROPS = "case when finorginfo.bank_cate.name is not null and finorginfo.finorgtype.number = 'FI-014' then finorginfo.bank_cate.name else finorginfo.name end as finorginfomain,amount,currency";
    private static final String LETTER_OF_GUARANTEE_COLUMNS = "finorginfomain,amount,currency,exchrate";
    private static final int SIZE = 8;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshChart();
    }

    private void refreshChart() {
        Map<String, BigDecimal> map = this.selectData();
        if (map == null || map.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, BigDecimal>> list = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        ArrayList<ItemValue> sortList = new ArrayList<ItemValue>(9);
        BigDecimal otherTotal = Constants.ZERO;
        for (int rowIdx = 0; rowIdx < list.size(); ++rowIdx) {
            Map.Entry entry = (Map.Entry)list.get(rowIdx);
            if (rowIdx < 8) {
                sortList.add(new ItemValue((String)entry.getKey(), (Number)entry.getValue()));
                continue;
            }
            otherTotal = otherTotal.add((BigDecimal)entry.getValue());
        }
        sortList.add(new ItemValue(ResManager.loadKDString((String)"\u5176\u5b83", (String)"LetterOfGuaranteeAnalysisHistogramChartPlugin_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]), (Number)otherTotal));
        PieChart chart = (PieChart)this.getControl(CHART_PROP);
        this.setTitle(chart);
        chart.clearData();
        this.setData(chart, sortList);
    }

    private void setTitle(PieChart chart) {
        chart.setMargin(Position.left, "30px");
        chart.setMargin(Position.right, "120px");
        chart.setMargin(Position.top, "30px");
        chart.setMargin(Position.bottom, "30px");
        chart.setShowLegend(true);
        chart.setLegendPropValue("type", (Object)"scroll");
        chart.setLegendPropValue("orient", (Object)"vertical");
        chart.setLegendPropValue("right", (Object)10);
        chart.setLegendPropValue("top", (Object)20);
        chart.setLegendPropValue("bottom", (Object)20);
        chart.setLegendVertical(true);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setShowTooltip(true);
    }

    private void setData(PieChart chart, List<ItemValue> list) {
        PieSeries pieSeries = this.createPieSeries(chart, ResManager.loadKDString((String)"\u4fdd\u51fd\u91d1\u989d", (String)"LetterOfGuaranteeAnalysisHistogramChartPlugin_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
        pieSeries.setData(list.toArray(new ItemValue[0]));
        chart.bindData(null);
    }

    private PieSeries createPieSeries(PieChart chart, String name) {
        PieSeries pieSeries = chart.createSeries(name);
        pieSeries.setType(ChartType.pie);
        pieSeries.setRadius("70%");
        pieSeries.setAnimationDuration(1500);
        HashMap<String, Object> itemStyle = new HashMap<String, Object>();
        itemStyle.put("shadowBlur", 10);
        itemStyle.put("shadowOffsetX", 0);
        itemStyle.put("shadowColor", "rgba(0, 0, 0, 0.5)");
        pieSeries.setPropValue("itemStyle", itemStyle);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        pieSeries.addFuncPath(list);
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        return pieSeries;
    }

    private Map<String, BigDecimal> selectData() {
        long currentOrgId = TmcOrgDataHelper.getCurrentOrgId();
        DynamicObject baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)currentOrgId);
        if (EmptyUtil.isEmpty((DynamicObject)baseCurrency)) {
            return null;
        }
        long baseCurrencyId = baseCurrency.getLong("id");
        DataSet letterOfGuaranteeDs = this.selectLetterOfGuaranteeBillList();
        try {
            ArrayList currencyIdList = new ArrayList(10);
            letterOfGuaranteeDs.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
            DataSet exchangeRateDS = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)baseCurrencyId, (long)currentOrgId, (Date)DateUtils.getCurrentDate(), (boolean)true);
            exchangeRateDS = exchangeRateDS.addField("rate", "exchrate");
            DataSet resultDS = letterOfGuaranteeDs.leftJoin(exchangeRateDS).on("currency", "tarcurrency").select(LETTER_OF_GUARANTEE_COLUMNS.split(",")).finish();
            resultDS = resultDS.addField("amount*exchrate", "gamount");
            resultDS = resultDS.copy().groupBy(new String[]{"finorginfomain"}).sum("gamount").finish();
            TreeMap<String, BigDecimal> map = new TreeMap<String, BigDecimal>();
            for (Row letterDatum : resultDS.copy()) {
                BigDecimal gAmount = letterDatum.getBigDecimal("gamount");
                map.put(letterDatum.getString("finorginfomain"), EmptyUtil.isEmpty((BigDecimal)gAmount) ? BigDecimal.ZERO : gAmount.setScale(6, 4));
            }
            return map;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6c47\u7387\u8f6c\u6362\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    private DataSet selectLetterOfGuaranteeBillList() {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_letterofguarantee", (String)"47150e89000000ac");
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
        QFilter reissueFilter = new QFilter("isreissue", "=", (Object)"1").and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("applyorg", "in", (Object)orgIds);
        qFilter.and(orgFilter.or(reissueFilter));
        return QueryServiceHelper.queryDataSet((String)"letterOfGuarantee", (String)"gm_letterofguarantee", (String)LETTER_OF_GUARANTEE_PROPS, (QFilter[])qFilter.toArray(), null);
    }
}

