/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.letterofguaapply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LetterOfGuaApplyConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject destDO = dataEntity.getDataEntity();
            destDO.set("id", (Object)DBServiceHelper.genGlobalLongId());
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"gm_letterofguaapply", (String)"org");
            destDO.set("org", (Object)sourceBill.getDynamicObject("org"));
            DynamicObject creditLimit = destDO.getDynamicObject("creditlimit");
            if (!EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) continue;
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)((Long)pkValue), (String)"gm_letterofguaapply");
            Object[] guaranteeUseBills = BusinessDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate"), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", creditLimit.getPkValue())}, (String)"id");
            if (!EmptyUtil.isNoEmpty((Object[])guaranteeUseBills)) continue;
            for (Object guaranteeUseBill : guaranteeUseBills) {
                this.createNewEntryRow((DynamicObject)guaranteeUseBill, destDO, creditUseBill);
            }
        }
        GuaranteeUseHelper.saveGuaranteeUse((DynamicObject[])((DynamicObject[])Arrays.stream(billDataEntitys).map(o -> o.getDataEntity()).toArray(DynamicObject[]::new)), (String[])new String[0]);
    }

    private void createNewEntryRow(DynamicObject guaranteeUseBill, DynamicObject destDO, DynamicObject creditUseBill) {
        BigDecimal rate;
        DynamicObject guaranteeRow = destDO.getDynamicObjectCollection("entry_gcontract").addNew();
        guaranteeRow.set("gcontract", guaranteeUseBill.get("gcontract"));
        BigDecimal amount = destDO.getBigDecimal("amount");
        BigDecimal gRatio = guaranteeUseBill.getBigDecimal("gratio");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditUseBill)) {
            gRatio = gRatio.multiply(creditUseBill.getBigDecimal("creditratio")).divide(Constants.ONE_HUNDRED);
        }
        guaranteeRow.set("gratio", (Object)gRatio);
        guaranteeRow.set("gamount", (Object)amount.multiply(gRatio).divide(Constants.ONE_HUNDRED));
        guaranteeRow.set("gcontractamount", guaranteeUseBill.get("gcontract.amount"));
        guaranteeRow.set("gcontractcurrency", (Object)guaranteeUseBill.getDynamicObject("gcontract.currency").getLong("id"));
        DynamicObject currency = destDO.getDynamicObject("currency");
        if (currency != null && guaranteeUseBill.getDynamicObject("gcontract.currency").getLong("id") != currency.getLong("id")) {
            DynamicObject company = destDO.getDynamicObject("org");
            rate = TmcBusinessBaseHelper.getExchangeRate((long)currency.getLong("id"), (long)guaranteeUseBill.getDynamicObject("gcontract.currency").getLong("id"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
        } else {
            rate = BigDecimal.ONE;
        }
        guaranteeRow.set("gexchrate", (Object)rate);
        guaranteeRow.set("gcomment", guaranteeUseBill.get("gcomment"));
    }
}

