/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.letterofguarantee;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaranteeList
extends AbstractTmcBillBaseList {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ListShowParameter fsp = (ListShowParameter)e.getFormShowParameter();
        if (EmptyUtil.isNoEmpty((Object)fsp)) {
            fsp.setSelectedEntity(fsp.getBillFormId());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if ("applyorg.name".equals(fieldName) || "applyreissueorg.name".equals(fieldName)) {
            this.applyOrgF7Evt(args);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if ("applyreissueorg.name".equals(fieldName)) {
            List qFilters = args.getQFilters();
            String appId = this.getView().getFormShowParameter().getAppId();
            List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_letterofguaapply", (String)"47150e89000000ac");
            qFilters.add(new QFilter("id", "in", (Object)comIdList));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            if (!"org.name".equals(commonFilter.getFieldName())) continue;
            commonFilter.setDefaultValue(null);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_letterofguarantee", (String)"47150e89000000ac");
        QFilter applyQFilter = new QFilter("isreissue", "=", (Object)"1").and("applyorg", "in", (Object)comIdList).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter issueQFilter = new QFilter("org", "in", (Object)comIdList);
        qFilters.add(applyQFilter.or(issueQFilter));
    }

    private void applyOrgF7Evt(BeforeFilterF7SelectEvent f7Evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_letterofguaapply", (String)"47150e89000000ac");
        f7Evt.getQfilters().add(new QFilter("id", "in", (Object)comIdList));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (!LetterOfGuaranteeHelper.NOTNEED_PERMISSIONOP.contains(op.getOperateKey()) && op.needSelectData() && !LetterOfGuaranteeHelper.checkPermisionForIsreissue((List)this.getSelectedIdList(), (String)this.getView().getFormShowParameter().getAppId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u94f6\u884c\u8f6c\u5f00\u65e0\u64cd\u4f5c\u6743\u9650\u7684\u6570\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LetterOfGuaranteeList_11", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (op.getOperateKey()) {
            case "setclaimdate": 
            case "setcanceldate": 
            case "change": {
                Long selected = this.getSelectedId();
                if (selected != null) break;
                args.setCancel(true);
                break;
            }
            case "suretyconfigm": {
                if (this.checkCanSuretyConfirm()) break;
                args.setCancel(true);
                return;
            }
            case "genreceiveletter": {
                Long selectedId = this.getSelectedId();
                if (selectedId == null) {
                    args.setCancel(true);
                    return;
                }
                op.getOption().setVariableValue("genreceiveletter", this.getView().getModel().getDataEntityType().getName());
                break;
            }
        }
    }

    private boolean checkCanSuretyConfirm() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject letterOfGuarantee = this.loadLetterOfGuarantee(id);
        if (!BillStatusEnum.AUDIT.getValue().equals(letterOfGuarantee.getString("billstatus")) || !BizStatusEnum.REGISTERED.getValue().equals(letterOfGuarantee.getString("bizstatus")) && !BizStatusEnum.CHANGING.getValue().equals(letterOfGuarantee.getString("bizstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838&\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u767b\u8bb0\u6216\u6539\u51fd\u4e2d\uff0c\u624d\u53ef\u5b58\u5165\u4fdd\u8bc1\u91d1\u3002", (String)"LetterOfGuaranteeList_12", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject loadLetterOfGuarantee(Long id) {
        DynamicObject letterOfGuarantee = TmcDataServiceHelper.loadSingle((Object)id, (String)"gm_letterofguarantee", (String)"bizstatus,billstatus");
        return letterOfGuarantee;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirm_gcontract_amount".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("afterconfirm", "1");
            this.getView().invokeOperation("submit", option);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey = e.getOperateKey();
        OperationResult opr = e.getOperationResult();
        if (opr != null && opr.isSuccess()) {
            switch (opKey) {
                case "inputfee": {
                    this.toFeeForm();
                    break;
                }
                case "setclaimdate": {
                    this.openDateForm(ResManager.loadKDString((String)"\u5f00\u51fd\u767b\u8bb0-\u7d22\u8d54", (String)"LetterOfGuaranteeList_4", (String)"tmc-gm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7d22\u8d54\u65e5\u671f", (String)"LetterOfGuaranteeList_8", (String)"tmc-gm-formplugin", (Object[])new Object[0]), "setclaimdate");
                    break;
                }
                case "setcanceldate": {
                    this.openDateForm(ResManager.loadKDString((String)"\u5f00\u51fd\u767b\u8bb0-\u6ce8\u9500", (String)"LetterOfGuaranteeList_10", (String)"tmc-gm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ce8\u9500\u65e5\u671f", (String)"LetterOfGuaranteeList_9", (String)"tmc-gm-formplugin", (Object[])new Object[0]), "setcanceldate");
                    break;
                }
                case "unclaim": 
                case "uncancel": {
                    this.getView().updateView("billlistap");
                    break;
                }
                case "change": {
                    this.openApplyForm();
                    break;
                }
            }
        }
    }

    private void openApplyForm() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("gm_letterofguaapply");
        showParameter.setCustomParam("letterOfGuaId", (Object)this.getSelectedId());
        showParameter.setCustomParam("change", (Object)Boolean.TRUE);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setBillStatus(BillOperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openDateForm(String title, String dateName, String callBackName) {
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackName);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setHasRight(true);
        showParameter.setFormId("gm_date_f7");
        showParameter.setCaption(title);
        showParameter.setCloseCallBack(callBack);
        DynamicObject record = this.getSelectedRecord();
        showParameter.setCustomParam("dateName", (Object)dateName);
        showParameter.setCustomParam("startdate", (Object)record.getDate("startdate"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        switch (event.getActionId()) {
            case "setclaimdate": {
                DynamicObject data = (DynamicObject)event.getReturnData();
                if (!EmptyUtil.isNoEmpty((DynamicObject)data)) break;
                Date date = (Date)data.get("date");
                OperateOption op = OperateOption.create();
                op.setVariableValue("date", DateUtils.formatString((Date)date, (String)"yyyy-MM-dd"));
                this.getView().invokeOperation("claim", op);
                this.getView().updateView("billlistap");
                break;
            }
            case "setcanceldate": {
                DynamicObject returnData = (DynamicObject)event.getReturnData();
                if (!EmptyUtil.isNoEmpty((DynamicObject)returnData)) break;
                Date date = (Date)returnData.get("date");
                OperateOption op = OperateOption.create();
                op.setVariableValue("date", DateUtils.formatString((Date)date, (String)"yyyy-MM-dd"));
                this.getView().invokeOperation("cancel", op);
                this.getView().updateView("billlistap");
                break;
            }
        }
    }

    private DynamicObject getSelectedRecord() {
        Long id = this.getSelectedId();
        QFilter filter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"gm_letterofguarantee", (String)"startdate", (QFilter[])filter.toArray());
    }

    private void toFeeForm() {
        List ids = this.getSelectedIdList();
        QFilter gQFilter = new QFilter("id", "in", (Object)ids);
        DynamicObjectCollection lgs = QueryServiceHelper.query((String)"gm_letterofguarantee", (String)"id, billno, applyorg,billstatus, bizstatus", (QFilter[])gQFilter.toArray());
        if (lgs.stream().anyMatch(o -> !BillStatusEnum.AUDIT.getValue().equals(o.getString("billstatus")) || BizStatusEnum.CANCELLED.getValue().equals(o.getString("bizstatus")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u72b6\u6001\u90fd\u4e3a\u5ba1\u6838\u4e14\u975e\u6ce8\u9500\u7684\u4fdd\u51fd\u8bb0\u5f55\u3002", (String)"LetterOfGuaranteeList_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (lgs.stream().map(o -> o.getLong("applyorg")).distinct().count() > 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fdd\u51fd\u7533\u8bf7\u4eba\u76f8\u540c\u7684\u8bb0\u5f55\u3002", (String)"LetterOfGuaranteeList_3", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> feeEntryMap = new HashMap<String, Object>(16);
        ArrayList entrys = new ArrayList(lgs.size());
        for (DynamicObject lg : lgs) {
            HashMap<String, Object> entry = new HashMap<String, Object>(16);
            entry.put("producttype", ProductTypeEnum.GM_LETTEROFGUARANTEE.getId());
            entry.put("srcbillno", lg.getString("billno"));
            entry.put("srcbillid", lg.getLong("id"));
            entrys.add(entry);
        }
        feeEntryMap.put("initentry", entrys);
        feeEntryMap.put("biztype", "gm");
        BillShowParameter fp = new BillShowParameter();
        fp.setFormId("gm_feebill");
        fp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fp.setBillStatus(BillOperationStatus.ADDNEW);
        fp.setCustomParams(feeEntryMap);
        fp.setCustomParam("SELECT_ORG_ID", (Object)String.valueOf(((DynamicObject)lgs.get(0)).getLong("applyorg")));
        this.getView().showForm((FormShowParameter)fp);
    }
}

