/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.pledgebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.common.billversion.AbstractBillVersionTabEdit;

public class PledgeBillHistoryVersionEdit
extends AbstractBillVersionTabEdit {
    public static final String BAR_NEW = "bar_new";
    public static final String BAR_DELETE = "bar_del";
    public static final String BAR_SAVE = "bar_save";
    public static final String BAR_SUBMIT = "bar_submit";
    public static final String BAR_AUDIT = "bar_audit";
    public static final String TABPAGE_HISTORY = "tabpage_history";
    public static final String ENTRYENTITY = "entryentity";
    private final List<String> hisHeadFields = Arrays.asList("h_id", "h_reason", "h_version", "h_applyid", "h_applycreate", "h_applybillno", "h_creator", "h_createtime");

    protected String getApplyBillEntity() {
        return "gm_pledgebill";
    }

    protected Map<String, String> getEntryNameAndEntryKey() {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        return entryMap;
    }

    protected String getModifyTabName() {
        return TABPAGE_HISTORY;
    }

    protected String getModifyEntryName() {
        return ENTRYENTITY;
    }

    protected List<String> getShowFieldProp() {
        String prefix = "a_";
        String suffix = ".id";
        ArrayList<String> show = new ArrayList<String>(16);
        show.add("h_version");
        show.add("h_id");
        show.add("h_applyid");
        show.add(prefix + "realrightpersontext");
        show.add(prefix + "attribute");
        show.add(prefix + "pledgetypeid" + suffix);
        show.add(prefix + "pledgename");
        show.add(prefix + "currencyid" + suffix);
        show.add(prefix + "currentappraisedvalue");
        show.add(prefix + "begindate");
        show.add(prefix + "enddate");
        show.add(prefix + "creator" + suffix);
        show.add(prefix + "modifier");
        show.add(prefix + "modifytime");
        return show;
    }

    protected String getClickVersion() {
        return "h_version";
    }

    protected String getClickApplyNo() {
        return "h_applybillno";
    }

    protected List<String> getHiddenButton() {
        return Arrays.asList(BAR_NEW, BAR_DELETE, BAR_SAVE, BAR_SUBMIT, BAR_AUDIT);
    }

    protected LocaleString getFormTitle() {
        return new LocaleString(ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269\u53d8\u66f4", (String)"PledgeBillHistoryVersionEdit_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
    }

    protected String getBizBillInfo() {
        DynamicObject pledgeBill = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"gm_pledgebill");
        return SerializationUtils.serializeToBase64((Object)pledgeBill);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (Objects.equals(evt.getOperateKey(), "submitchange") && evt.getOperationResult().isSuccess()) {
            this.initModifyInfo();
        }
    }

    protected void dealVsEntryInfo(DynamicObject[] historys, TableValueSetter vs, LinkedHashMap<String, String> maps) {
        for (DynamicObject history : historys) {
            ArrayList<Object> addRow = new ArrayList<Object>(16);
            DynamicObject applyBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)history);
            for (Map.Entry<String, String> map : maps.entrySet()) {
                String key = map.getKey();
                String value = map.getValue();
                if (this.hisHeadFields.contains(value)) {
                    addRow.add(history.get(key));
                    continue;
                }
                addRow.add(this.getRowVal(applyBill, key));
            }
            vs.addRow(addRow.toArray());
        }
    }

    private Object getRowVal(DynamicObject applyBill, String key) {
        return applyBill.get(key);
    }
}

