/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.pledgebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.PledgeSourceEnum;
import org.apache.commons.lang3.tuple.Pair;

public class PledgeBillNoF7Edit
extends AbstractBasePlugIn {
    private Map<String, Pair<String, String>> getFieldMap() {
        HashMap<String, Pair<String, String>> fieldMap = new HashMap<String, Pair<String, String>>(1);
        fieldMap.put("pledgetextno", Pair.of((Object)"pledgetypeid", (Object)"pledgeno"));
        return fieldMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Map<String, Pair<String, String>> fieldMap = this.getFieldMap();
        if (fieldMap != null && fieldMap.size() > 0) {
            Set<String> fields = fieldMap.keySet().stream().collect(Collectors.toSet());
            this.addClickListeners(fields.toArray(new String[0]));
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (this.getFieldMap().containsKey(key) && EmptyUtil.isNoEmpty((Object)e.getValue())) {
            String typePropDisplayName = this.getTypeDisplayName(key);
            String baseType = this.getBaseType(key);
            if (this.isNotOtherTypeValue(baseType)) {
                e.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u975e\u7a7a\u6765\u6e90\uff0c\u4e0d\u80fd\u76f4\u63a5\u8f93\u5165\uff0c\u8bf7\u901a\u8fc7\u70b9\u51fb\u9009\u62e9\u3002", (String)"PledgeBillNoF7Edit_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]), typePropDisplayName));
                this.getView().updateView(key);
            }
        }
    }

    private String getTypeDisplayName(String key) {
        String typeField = (String)this.getFieldMap().get(key).getLeft();
        DynamicObject pledgeType = (DynamicObject)this.getModel().getValue(typeField);
        if (EmptyUtil.isEmpty((DynamicObject)pledgeType)) {
            return null;
        }
        for (PledgeSourceEnum pledgeSource : PledgeSourceEnum.values()) {
            if (!pledgeSource.getValue().equals(pledgeType.getString("source"))) continue;
            return pledgeSource.getName().loadKDString();
        }
        return null;
    }

    protected boolean isNotOtherTypeValue(String baseType) {
        for (PledgeSourceEnum pledgeSource : PledgeSourceEnum.values()) {
            if (!pledgeSource.getValue().equals(baseType)) continue;
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        String key = srcControl.getKey();
        if (this.getFieldMap().containsKey(key)) {
            Long realRightPersonId = (Long)this.getModel().getValue("realrightpersonid");
            if (EmptyUtil.isEmpty((Long)realRightPersonId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6743\u4eba\u3002", (String)"PledgeBillNoF7Edit_0", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                return;
            }
            String baseType = this.getBaseType(key);
            if (EmptyUtil.isEmpty((String)baseType)) {
                String typeField = (String)this.getFieldMap().get(key).getLeft();
                BasedataEdit pledgeTypeEdit = (BasedataEdit)this.getControl(typeField);
                LocaleString fieldName = pledgeTypeEdit.getProperty().getDisplayName();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7a7a\u6765\u6e90\uff0c\u4e0d\u80fd\u901a\u8fc7\u70b9\u51fb\u9009\u62e9\uff0c\u8bf7\u76f4\u63a5\u8f93\u5165\u3002", (String)"PledgeBillNoF7Edit_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]), fieldName));
                return;
            }
            if (this.isNotOtherTypeValue(baseType)) {
                this.showF7(key);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (this.getTypeField().contains(key)) {
            String textField = this.getKeyFromType(key);
            String idField = (String)this.getFieldMap().get(textField).getRight();
            this.getModel().setValue(textField, (Object)"");
            this.getModel().setValue(idField, (Object)0L);
        }
        if (this.getFieldMap().containsKey(key) && EmptyUtil.isEmpty((Object)(newValue = changeSet[0].getNewValue()))) {
            this.getModel().setValue((String)this.getFieldMap().get(key).getRight(), (Object)0L);
        }
    }

    private void showF7(String textField) {
        String baseType = this.getBaseType(textField);
        String f7FormId = this.getF7FormId(baseType);
        if (f7FormId == null) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)f7FormId, (boolean)false, (int)3, (boolean)true);
        this.addCustomFilter(textField, lsp);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, textField);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    protected void addCustomFilter(String textField, ListShowParameter lsp) {
        String source = this.getBaseType(textField);
        Long realRightPersonId = (Long)this.getModel().getValue("realrightpersonid");
        List qFilters = lsp.getListFilterParameter().getQFilters();
        if (PledgeSourceEnum.FIXED_ASSETS.getValue().equals(source)) {
            qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilters.add(new QFilter("org.id", "=", (Object)realRightPersonId));
        } else if (PledgeSourceEnum.DEPOSIT_MANAGEMENT.getValue().equals(source)) {
            qFilters.add(new QFilter("investvarieties.investtype", "in", (Object)InvestTypeEnum.getFixedGroup()));
            qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilters.add(new QFilter("bizstatus", "in", Arrays.asList("subscribe_done", "subscribe_part")));
            QFilter queryQFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            ArrayList<Long> paramIds = new ArrayList<Long>();
            DynamicObjectCollection releaseIds = QueryServiceHelper.query((String)"cim_release", (String)"sourcebillid", (QFilter[])queryQFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)releaseIds)) {
                for (Object releaseIdDo : releaseIds) {
                    paramIds.add(releaseIdDo.getLong("sourcebillid"));
                }
            }
            queryQFilter.and(new QFilter("isredepositgenerate", "=", (Object)Boolean.TRUE));
            DynamicObjectCollection depositIds = QueryServiceHelper.query((String)"cim_deposit", (String)"id", (QFilter[])queryQFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)depositIds)) {
                for (DynamicObject depositIdDo : depositIds) {
                    paramIds.add(depositIdDo.getLong("id"));
                }
            }
            qFilters.add(new QFilter("id", "not in", paramIds));
            qFilters.add(new QFilter("org.id", "=", (Object)realRightPersonId));
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cim_deposit", (String)"47150e89000000ac");
            qFilters.add(new QFilter("org.id", "in", (Object)orgIdList));
        } else if (PledgeSourceEnum.INVESTMENT_FINANCE.getValue().equals(source)) {
            qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            qFilters.add(new QFilter("finservicestatus", "in", Arrays.asList("subscribe_done", "subscribe_part")));
            QFilter queryQFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            ArrayList<Long> paramIds = new ArrayList<Long>();
            DynamicObjectCollection redeemIds = QueryServiceHelper.query((String)"cim_redeem", (String)"sourcebillid", (QFilter[])queryQFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)redeemIds)) {
                for (DynamicObject redeemIdDo : redeemIds) {
                    paramIds.add(redeemIdDo.getLong("sourcebillid"));
                }
            }
            qFilters.add(new QFilter("id", "not in", paramIds));
            qFilters.add(new QFilter("org.id", "=", (Object)realRightPersonId));
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cim_finsubscribe", (String)"47150e89000000ac");
            qFilters.add(new QFilter("org.id", "in", (Object)orgIdList));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String type = e.getActionId();
        if (this.getFieldMap().containsKey(type)) {
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)e.getReturnData();
            if (selectedRowCol == null) {
                return;
            }
            Long selectPk = (Long)selectedRowCol.get(0).getPrimaryKeyValue();
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)((String)this.getFieldMap().get(type).getRight()), (Object)selectPk);
            String source = this.getBaseType(type);
            if (PledgeSourceEnum.FIXED_ASSETS.getValue().equals(source)) {
                QFilter qFilter = new QFilter("id", "=", (Object)selectPk);
                DynamicObject cardRealBaseDo = QueryServiceHelper.queryOne((String)PledgeSourceEnum.FIXED_ASSETS.getFormId(), (String)"number,assetname", (QFilter[])qFilter.toArray());
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)type, (Object)cardRealBaseDo.getString("number"));
                this.getModel().setValue("pledgename", cardRealBaseDo.get("assetname"));
                this.getView().setEnable(Boolean.TRUE, new String[]{"originalvalue", "initialappraisedvalue"});
            } else if (PledgeSourceEnum.DEPOSIT_MANAGEMENT.getValue().equals(source)) {
                QFilter qFilter = new QFilter("id", "=", (Object)selectPk);
                DynamicObject depositDo = QueryServiceHelper.queryOne((String)PledgeSourceEnum.DEPOSIT_MANAGEMENT.getFormId(), (String)"number,investvarieties.name,surplusamount,intdate,expiredate", (QFilter[])qFilter.toArray());
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)type, (Object)depositDo.getString("number"));
                this.getModel().setValue("pledgename", depositDo.get("investvarieties.name"));
                this.getModel().setValue("originalvalue", depositDo.get("surplusamount"));
                this.getModel().setValue("initialappraisedvalue", depositDo.get("surplusamount"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"begindate", (Object)depositDo.get("intdate"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)depositDo.get("expiredate"));
                TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"originalvalue", "initialappraisedvalue"});
            } else if (PledgeSourceEnum.INVESTMENT_FINANCE.getValue().equals(source)) {
                QFilter qFilter = new QFilter("id", "=", (Object)selectPk);
                DynamicObject finSubscribeDo = QueryServiceHelper.queryOne((String)PledgeSourceEnum.INVESTMENT_FINANCE.getFormId(), (String)"number,investvarieties.name,redeemway,surplusamount,surpluscopies,iopv,intdate,expiredate", (QFilter[])qFilter.toArray());
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)type, (Object)finSubscribeDo.getString("number"));
                this.getModel().setValue("pledgename", finSubscribeDo.get("investvarieties.name"));
                if ("amount_redeem".equals(finSubscribeDo.getString("redeemway"))) {
                    this.getModel().setValue("originalvalue", finSubscribeDo.get("surplusamount"));
                    this.getModel().setValue("initialappraisedvalue", finSubscribeDo.get("surplusamount"));
                } else {
                    this.getModel().setValue("originalvalue", (Object)finSubscribeDo.getBigDecimal("surpluscopies").multiply(finSubscribeDo.getBigDecimal("iopv")));
                    this.getModel().setValue("initialappraisedvalue", (Object)finSubscribeDo.getBigDecimal("surpluscopies").multiply(finSubscribeDo.getBigDecimal("iopv")));
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"begindate", (Object)finSubscribeDo.get("intdate"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)finSubscribeDo.get("expiredate"));
                TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"originalvalue", "initialappraisedvalue"});
            }
        }
    }

    protected String getF7FormId(String type) {
        for (PledgeSourceEnum value : PledgeSourceEnum.values()) {
            if (!value.getValue().equals(type)) continue;
            return value.getFormId();
        }
        return null;
    }

    private String getBaseType(String textField) {
        String typeField = (String)this.getFieldMap().get(textField).getLeft();
        DynamicObject pledgeType = (DynamicObject)this.getModel().getValue(typeField);
        if (EmptyUtil.isEmpty((DynamicObject)pledgeType)) {
            return null;
        }
        return pledgeType.getString("source");
    }

    private Set<String> getTypeField() {
        Map<String, Pair<String, String>> fieldMap = this.getFieldMap();
        if (fieldMap == null) {
            return Collections.EMPTY_SET;
        }
        return fieldMap.entrySet().stream().map(o -> (String)((Pair)o.getValue()).getLeft()).collect(Collectors.toSet());
    }

    private String getKeyFromType(String type) {
        Map<String, Pair<String, String>> fieldMap = this.getFieldMap();
        if (EmptyUtil.isEmpty((String)type) || fieldMap == null) {
            return null;
        }
        for (Map.Entry<String, Pair<String, String>> field : fieldMap.entrySet()) {
            if (!type.equals(field.getValue().getLeft())) continue;
            return field.getKey();
        }
        return null;
    }
}

