/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.pledgebill;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;

public class PledgeBillUseEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static String[] PLEDGE_SELECT_PROPS = new String[]{"billno", "realright", "realrightpersonid", "realrightpersontext", "pledgetypeid", "pledgestatus", "pledgename", "currencyid", "currentappraisedvalue", "pledgerate", "totalpledgevalue", "pledgevalue"};
    private static String[] CONTRACT_SELECT_PROPS = new String[]{"billno", "bizstatus", "guarantee", "guaranteeorgtext", "guaranteedorgtext", "creditortext", "currency", "begindate", "enddate"};

    DynamicObject[] getContractByMortgageId(Long id) {
        QFilter qFilter = new QFilter("morentity.m_pleg.id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        return TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)(String.join((CharSequence)",", CONTRACT_SELECT_PROPS) + ",morentity.m_pleg,morentity.m_amount"), (QFilter[])qFilter.toArray());
    }

    DynamicObject[] getContractByPledgeId(Long id) {
        QFilter qFilter = new QFilter("pletgageentity.p_pleg.id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        return TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)(String.join((CharSequence)",", CONTRACT_SELECT_PROPS) + ",pletgageentity.p_pleg,pletgageentity.p_amount"), (QFilter[])qFilter.toArray());
    }

    DynamicObject[] getCountorContractByMortgageId(Long id) {
        QFilter qFilter = new QFilter("cmorentity.cm_pleg.id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        return TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)(String.join((CharSequence)",", CONTRACT_SELECT_PROPS) + ",cmorentity.cm_pleg,cmorentity.cm_amount"), (QFilter[])qFilter.toArray());
    }

    DynamicObject[] getCountorContractByPledgeId(Long id) {
        QFilter qFilter = new QFilter("cpletgageentity.cp_pleg.id", "=", (Object)id);
        qFilter.and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        return TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)(String.join((CharSequence)",", CONTRACT_SELECT_PROPS) + ",cmorentity.cp_pleg,cpletgageentity.cp_amount"), (QFilter[])qFilter.toArray());
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection gcPletgageentitys;
        DynamicObjectCollection gcMorentitys;
        int i;
        super.afterCreateNewData(e);
        Object idObject = this.getView().getFormShowParameter().getCustomParam("id");
        if (EmptyUtil.isEmpty((Object)idObject)) {
            return;
        }
        Long id = Long.parseLong(idObject.toString());
        DynamicObject pledgeBillData = TmcDataServiceHelper.loadSingle((Object)idObject, (String)"gm_pledgebill", (String)String.join((CharSequence)",", PLEDGE_SELECT_PROPS));
        this.getModel().setValue("id", idObject);
        this.getModel().setValue("billno", pledgeBillData.get("billno"));
        this.getModel().setValue("realright", pledgeBillData.get("realright"));
        this.getModel().setValue("realrightpersonid", pledgeBillData.get("realrightpersonid"));
        this.getModel().setValue("realrightpersontext", pledgeBillData.get("realrightpersontext"));
        this.getModel().setValue("pledgetypeid", pledgeBillData.get("pledgetypeid"));
        this.getModel().setValue("pledgename", pledgeBillData.get("pledgename"));
        this.getModel().setValue("currencyid", pledgeBillData.get("currencyid"));
        this.getModel().setValue("currentappraisedvalue", pledgeBillData.get("currentappraisedvalue"));
        this.getModel().setValue("pledgerate", pledgeBillData.get("pledgerate"));
        this.getModel().setValue("totalpledgevalue", pledgeBillData.get("totalpledgevalue"));
        this.getModel().setValue("pledgevalue", pledgeBillData.get("pledgevalue"));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.forceClearNoDataRow();
        Object[] morentitys = this.getContractByMortgageId(id);
        Object[] pletgageentitys = this.getContractByPledgeId(id);
        Object[] cmorentitys = this.getCountorContractByMortgageId(id);
        Object[] cpletgageentitys = this.getCountorContractByPledgeId(id);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.beginInit();
        vs.addField("et_pledgeamount", new Object[0]);
        vs.addField("et_pledgestatus", new Object[0]);
        vs.addField("et_guaranteecontract", new Object[0]);
        vs.addField("et_guaranteevarieties", new Object[0]);
        vs.addField("et_guaranteeorg", new Object[0]);
        vs.addField("et_guaranteedorg", new Object[0]);
        vs.addField("et_creditor", new Object[0]);
        vs.addField("et_currency", new Object[0]);
        vs.addField("et_begindate", new Object[0]);
        vs.addField("et_enddate", new Object[0]);
        vs.addField("et_dutyamount", new Object[0]);
        if (EmptyUtil.isNoEmpty((Object[])morentitys)) {
            for (i = 0; i < morentitys.length; ++i) {
                Object morentityObject = morentitys[i];
                gcMorentitys = morentityObject.getDynamicObjectCollection("morentity");
                for (DynamicObject morentity : gcMorentitys) {
                    if (!id.equals(morentity.getDynamicObject("m_pleg").getLong("id"))) continue;
                    vs.addRow(this.setRowData(morentity.get("m_amount"), (DynamicObject)morentityObject));
                }
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])pletgageentitys)) {
            for (i = 0; i < pletgageentitys.length; ++i) {
                Object pletGageEntity = pletgageentitys[i];
                gcPletgageentitys = pletGageEntity.getDynamicObjectCollection("pletgageentity");
                for (DynamicObject pletgageentity : gcPletgageentitys) {
                    if (!id.equals(pletgageentity.getDynamicObject("p_pleg").getLong("id"))) continue;
                    vs.addRow(this.setRowData(pletgageentity.get("p_amount"), (DynamicObject)pletGageEntity));
                }
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])cmorentitys)) {
            for (i = 0; i < cmorentitys.length; ++i) {
                Object cmorentityObject = cmorentitys[i];
                gcMorentitys = cmorentityObject.getDynamicObjectCollection("cmorentity");
                for (DynamicObject morentity : gcMorentitys) {
                    if (!id.equals(morentity.getDynamicObject("cm_pleg").getLong("id"))) continue;
                    vs.addRow(this.setRowData(morentity.get("cm_amount"), (DynamicObject)cmorentityObject));
                }
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])cpletgageentitys)) {
            for (i = 0; i < cpletgageentitys.length; ++i) {
                Object cpletGageEntity = cpletgageentitys[i];
                gcPletgageentitys = cpletGageEntity.getDynamicObjectCollection("cpletgageentity");
                for (DynamicObject pletgageentity : gcPletgageentitys) {
                    if (!id.equals(pletgageentity.getDynamicObject("cp_pleg").getLong("id"))) continue;
                    vs.addRow(this.setRowData(pletgageentity.get("cp_amount"), (DynamicObject)cpletGageEntity));
                }
            }
        }
        model.batchCreateNewEntryRow("pledgeuseentity", vs);
        model.endInit();
        this.getView().updateView("pledgeuseentity");
    }

    public Object[] setRowData(Object amount, DynamicObject data) {
        return new Object[]{amount, data.getString("bizstatus"), data.get("billno"), data.getDynamicObject("guarantee") == null ? null : data.getDynamicObject("guarantee").getPkValue(), data.getString("guaranteeorgtext"), data.getString("guaranteedorgtext"), data.getString("creditortext"), data.getDynamicObject("currency") == null ? null : data.getDynamicObject("currency").getPkValue(), data.get("begindate"), data.get("enddate"), GuaranteeContractHelper.getContractDutyAmt((Long)data.getLong("id"))};
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pledgeuseentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("et_guaranteecontract".equals(fieldName)) {
            String billno = (String)this.getModel().getValue("et_guaranteecontract");
            QFilter filter = new QFilter("billno", "=", (Object)billno);
            DynamicObject contractBill = TmcDataServiceHelper.loadSingle((String)"gm_guaranteecontract", (String)"id", (QFilter[])new QFilter[]{filter});
            BillShowParameter fp = new BillShowParameter();
            fp.setPkId((Object)contractBill.getLong("id"));
            fp.setFormId("gm_guaranteecontract");
            fp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fp.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)fp);
        }
    }
}

