/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.formplugin.quota;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.CtrlLimitEnum;
import kd.tmc.gm.common.helper.GuaranteeHelper;

public class GuaranteeQuotaEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)orgDyn)) {
            Long baseCurrencyID = GuaranteeHelper.getCurrencyByOrg((long)orgDyn.getLong("id"));
            this.getModel().setValue("currency", (Object)baseCurrencyID);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkIsFromChange();
        this.initCtrlLimit();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("entry_guaranteedorg".equals(entryName)) {
            BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"q_limitamount", (Object)totalAmount, (int)e.getRowDataEntities()[0].getRowIndex());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (property) {
            case "totalamount": {
                BigDecimal usedQuota = (BigDecimal)this.getModel().getValue("usedquota");
                BigDecimal advanceQuota = (BigDecimal)this.getModel().getValue("advancequota");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"availablequota", (Object)((BigDecimal)newValue).subtract(usedQuota).subtract(advanceQuota));
                DynamicObjectCollection guaranteedOrgEntryList = this.getModel().getEntryEntity("entry_guaranteedorg");
                for (int i = 0; i < guaranteedOrgEntryList.size(); ++i) {
                    BigDecimal qLimitAmount = ((DynamicObject)guaranteedOrgEntryList.get(i)).getBigDecimal("q_limitamount");
                    if (!EmptyUtil.isEmpty((BigDecimal)qLimitAmount) && qLimitAmount.compareTo((BigDecimal)newValue) <= 0) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"q_limitamount", (Object)newValue, (int)i);
                }
                break;
            }
            case "q_limitamount": {
                BigDecimal qUsedQuota = (BigDecimal)this.getModel().getValue("q_usedquota");
                BigDecimal qAdvanceQuota = (BigDecimal)this.getModel().getValue("q_advancequota");
                this.getModel().setValue("q_availablequota", (Object)((BigDecimal)newValue).subtract(qUsedQuota).subtract(qAdvanceQuota), e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "begindate": {
                this.getModel().setValue("enddate", null);
                break;
            }
            case "ctrllimit": {
                this.initCtrlLimit();
                break;
            }
        }
    }

    private void initCtrlLimit() {
        String ctrlLimit = (String)this.getModel().getValue("ctrllimit");
        if (CtrlLimitEnum.GUARANTEE_ORG.getValue().equals(ctrlLimit)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"gdadvconap"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"q_reguaranteetype", "q_guaranteedorgtext", "q_limitamount"});
            this.getModel().deleteEntryData("entry_guaranteedorg");
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"gdadvconap"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"q_reguaranteetype", "q_guaranteedorgtext", "q_limitamount"});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIdx = e.getRowIndex();
        Object value = e.getValue();
        switch (key) {
            case "totalamount": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u603b\u989d\u5ea6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeQuotaEdit_4", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView("totalamount");
                    return;
                }
                BigDecimal usedQuota = (BigDecimal)this.getModel().getValue("usedquota");
                if (new BigDecimal(value.toString()).compareTo(usedQuota) >= 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"GuaranteeQuotaEdit_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("totalamount");
                break;
            }
            case "q_limitamount": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9650\u5b9a\u989d\u5ea6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeQuotaEdit_5", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView("q_limitamount", rowIdx);
                    return;
                }
                BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
                if (EmptyUtil.isEmpty((BigDecimal)totalAmount)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u201c\u603b\u989d\u5ea6\u201d\u3002", (String)"GuaranteeQuotaEdit_6", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView("q_limitamount", rowIdx);
                    return;
                }
                BigDecimal qUsedQuota = (BigDecimal)this.getModel().getValue("q_usedquota");
                if (new BigDecimal(value.toString()).compareTo(totalAmount) > 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9650\u5b9a\u989d\u5ea6\u4e0d\u80fd\u5927\u4e8e\u603b\u989d\u5ea6\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"GuaranteeQuotaEdit_7", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView("q_limitamount", rowIdx);
                    break;
                }
                if (new BigDecimal(value.toString()).compareTo(qUsedQuota) >= 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9650\u5b9a\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"GuaranteeQuotaEdit_8", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("q_limitamount", rowIdx);
                break;
            }
            case "enddate": {
                if (!EmptyUtil.isNoEmpty((Object)value)) break;
                Date beginDate = (Date)this.getModel().getValue("begindate");
                if (DateUtils.stringToDate((String)String.valueOf(value), (String)"yyyy-MM-dd").compareTo(beginDate) > 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u9009\u62e9\u5927\u4e8e\u751f\u6548\u65e5\u671f\u7684\u65e5\u671f\u3002", (String)"GuaranteeQuotaEdit_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("enddate");
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().deleteEntryData("entry");
        this.getModel().setValue("availablequota", this.getModel().getValue("totalamount"));
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        String billEntity = (String)this.getModel().getValue("gmbilltype", rowIndex);
        BillShowParameter param = new BillShowParameter();
        param.setFormId(billEntity);
        param.setPkId(this.getModel().getValue("gmbillid", rowIndex));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeBindData(EventObject e) {
        Map paraMap;
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.EDIT == status && (paraMap = showParameter.getCustomParams()).containsKey("fromchange")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_update"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_disable"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "update": {
                if (this.isDataChanged() && !this.updateValidate()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (Arrays.asList("update", "submit", "unsubmit", "audit", "unaudit").contains(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().updateView();
            this.getModel().setDataChanged(false);
        }
    }

    private boolean updateValidate() {
        BigDecimal usedQuota;
        Date beginDate = (Date)this.getModel().getValue("begindate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (endDate != null && endDate.compareTo(beginDate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u9009\u62e9\u5927\u4e8e\u751f\u6548\u65e5\u671f\u7684\u65e5\u671f\u3002", (String)"GuaranteeQuotaEdit_1", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        if (totalAmount.compareTo(usedQuota = (BigDecimal)this.getModel().getValue("usedquota")) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"GuaranteeQuotaEdit_2", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isDataChanged() {
        if (!this.getModel().getDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"GuaranteeQuotaEdit_3", (String)"tmc-gm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkIsFromChange() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("fromchange")) {
            if (customParams.containsKey("openHistoryId")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"ctrllimit", "org", "reguaranteetype", "guaranteedorgtext", "quotaproperty", "currency", "gdadvconap"});
            } else {
                String status = (String)this.getModel().getValue("status");
                this.getView().setEnable(Boolean.valueOf(BillStatusEnum.SAVE.getValue().equals(status)), new String[]{"fs_baseinfo", "gdadvconap"});
            }
        }
    }
}

