/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.contract;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;

public class GuaranteeUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(GuaranteeUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                result.setLog("start upgrade guarantee type and value");
                this.dataUpgrade("t_gm_guaranteeapply");
                this.dataUpgrade("t_gm_guarcontract");
                result.setLog("end upgrade guarantee type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void dataUpgrade(String tableName) {
        List paramSplit;
        Object paramSplitList;
        Object[] params;
        String applyQuerySql = "select fid, fguaranteetype, fguaranteeorgid, fguaranteeorgtext, freguaranteetype, fguaranteedorgid, fguaranteedorgtext, famount from " + tableName;
        DataSet guaranteeData = DB.queryDataSet((String)"GuaranteeUpgradeService", (DBRoute)DBRouteConst.TMC, (String)applyQuerySql);
        if (guaranteeData.isEmpty()) {
            return;
        }
        ArrayList<Long> existIds = new ArrayList<Long>();
        for (Row guaranteeDatum : guaranteeData.copy()) {
            existIds.add(guaranteeDatum.getLong("fid"));
        }
        logger.info("existIds:{}", (Object)existIds.stream().map(String::valueOf).collect(Collectors.joining()));
        Set<Long> fidEntrySet = this.getEntryMap(existIds, "select fid from t_gm_guarantee_entry where fid in (%s)");
        long[] entryIds = DB.genLongIds((String)"t_gm_guarantee_entry", (int)(existIds.size() - fidEntrySet.size()));
        int i = 0;
        ArrayList<String> upgradeIds = new ArrayList<String>();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (Object guaranteeDatum : guaranteeData.copy()) {
            if (fidEntrySet.contains(guaranteeDatum.getLong("fid"))) continue;
            params = new Object[]{guaranteeDatum.getLong("fid"), entryIds[i], 1, guaranteeDatum.getString("fguaranteetype"), guaranteeDatum.getLong("fguaranteeorgid"), guaranteeDatum.getString("fguaranteeorgtext"), 100, guaranteeDatum.getBigDecimal("famount")};
            paramList.add(params);
            upgradeIds.add(guaranteeDatum.getString("fid"));
            ++i;
        }
        if (!paramList.isEmpty()) {
            Object guaranteeDatum;
            paramSplitList = ListUtils.splitList(paramList, (long)1000L);
            guaranteeDatum = paramSplitList.iterator();
            while (guaranteeDatum.hasNext()) {
                paramSplit = (List)guaranteeDatum.next();
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"insert into t_gm_guarantee_entry(fid, fentryid, fseq, fguaranteetype, fguaranteeorgid, fguaranteeorgtext, fgratio, fgamount) values (?, ?, ?, ?, ?, ?, ?, ?)", (List)paramSplit);
            }
        }
        fidEntrySet = this.getEntryMap(existIds, "select fid from t_gm_guaranteed_entry where fid in (%s)");
        entryIds = DB.genLongIds((String)"t_gm_guaranteed_entry", (int)(existIds.size() - fidEntrySet.size()));
        i = 0;
        paramList = new ArrayList();
        for (Row guaranteedDatum : guaranteeData.copy()) {
            if (fidEntrySet.contains(guaranteedDatum.getLong("fid"))) continue;
            params = new Object[]{guaranteedDatum.getLong("fid"), entryIds[i], 1, guaranteedDatum.getString("freguaranteetype"), guaranteedDatum.getLong("fguaranteedorgid"), guaranteedDatum.getString("fguaranteedorgtext"), 100, guaranteedDatum.getBigDecimal("famount")};
            paramList.add(params);
            upgradeIds.add(guaranteedDatum.getString("fid"));
            ++i;
        }
        if (!paramList.isEmpty()) {
            paramSplitList = ListUtils.splitList(paramList, (long)1000L);
            Iterator iterator = paramSplitList.iterator();
            while (iterator.hasNext()) {
                paramSplit = (List)iterator.next();
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"insert into t_gm_guaranteed_entry(fid, fentryid, fseq, freguaranteetype, fguaranteedorgid, fguaranteedorgtext, fgratio, fgamount) values (?, ?, ?, ?, ?, ?, ?, ?)", (List)paramSplit);
            }
        }
        logger.info("upgrade upgradeIds:{}", (Object)String.join((CharSequence)",", upgradeIds));
    }

    private Set<Long> getEntryMap(List<Long> ids, String querySql) {
        StringJoiner sj = new StringJoiner(",");
        ids.forEach(v -> sj.add(v.toString()));
        DataSet beneficiaryDataSet = DB.queryDataSet((String)"getEntryMap", (DBRoute)DBRouteConst.TMC, (String)String.format(querySql, sj.toString()));
        HashSet<Long> fidSet = new HashSet<Long>();
        if (EmptyUtil.isEmpty((Object)beneficiaryDataSet)) {
            return fidSet;
        }
        for (Row row : beneficiaryDataSet.copy()) {
            Long fid = row.getLong("fid");
            fidSet.add(fid);
        }
        return fidSet;
    }
}

