/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.contract;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class GuaranteeUseBankUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(GuaranteeUseBankUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                result.setLog("start upgrade guaranteeusebank type and value");
                this.dataUpgradeLoanContract();
                result.setLog("end upgrade guaranteeusebank type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private int dataUpgradeLoanContract() {
        String loanQuerySql;
        DataSet loanData;
        Long fid;
        String slGcQuerySql = "select tgg1.fid as fgcid,tclb.fid,tgg.fguaranteecontractid,tgg.fgratio,tclb.fbankrole,tclb.ffinorginfoid,tclb.fcreditlimitid,tclb.fshareamount,tclb.floanamount from t_gm_guaranteeuse tgg,t_cfm_loancontractbill_ba tclb,t_gm_guaranteeuse tgg1 where tgg.fgsrcbillid=tclb.fcreditlimitid and tgg.fgsrcbilltype='cfm_creditlimit' and tgg1.fgsrcbillid=tclb.fid and tgg1.fgsrcbilltype in ('cfm_loancontract_bl_l','cfm_loancontractbill','cfm_loanbill_b_l','cfm_loanbill')  and tgg1.fguaranteecontractid=tgg.fguaranteecontractid and (tgg1.fgcreditortype is null or tgg1.fgcreditortype = ' ') and (tgg1.fgcreditorid is null or tgg1.fgcreditorid=0)";
        DataSet slGcData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)slGcQuerySql);
        HashMap<Long, ArrayList<Row>> slGcMap = new HashMap<Long, ArrayList<Row>>();
        HashSet<Long> finOrgInfoIdSet = new HashSet<Long>();
        if (!slGcData.isEmpty()) {
            for (Row slGcDatum : slGcData.copy()) {
                Long fid2 = slGcDatum.getLong("fid");
                List<Object> listTemp = (List)slGcMap.get(fid2);
                if (listTemp == null) {
                    listTemp = new ArrayList<Row>();
                }
                listTemp.add(slGcDatum);
                slGcMap.put(fid2, (ArrayList<Row>)listTemp);
                finOrgInfoIdSet.add(slGcDatum.getLong("ffinorginfoid"));
            }
        }
        String bondGcQuerySql = "select tgg1.fid as fgcid,tclbv.fid,tgg.fguaranteecontractid,tgg.fgratio,tclbv.finvestortype,tclbv.finvestorid,tclbv.finvestorname,tclbv.fcreditlimitid,tclbv.finvestamount from t_gm_guaranteeuse tgg,t_cfm_loanbill_bond_vr tclbv,t_gm_guaranteeuse tgg1 where tgg.fgsrcbillid=tclbv.fcreditlimitid and tgg.fgsrcbilltype='cfm_creditlimit' and tgg1.fgsrcbillid=tclbv.fid and tgg1.fgsrcbilltype in ('cfm_loancontract_bo','cfm_loanbill_bond') and tgg1.fguaranteecontractid=tgg.fguaranteecontractid and (tgg1.fgcreditortype is null or tgg1.fgcreditortype = ' ') and (tgg1.fgcreditorid is null or tgg1.fgcreditorid=0)";
        DataSet bondGcData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)bondGcQuerySql);
        HashMap<Long, ArrayList<Row>> bondGcMap = new HashMap<Long, ArrayList<Row>>();
        if (!bondGcData.isEmpty()) {
            for (Row bondGcDatum : bondGcData.copy()) {
                Long fid3 = bondGcDatum.getLong("fid");
                List<Object> listTemp = (List)bondGcMap.get(fid3);
                if (listTemp == null) {
                    listTemp = new ArrayList<Row>();
                }
                listTemp.add(bondGcDatum);
                bondGcMap.put(fid3, (ArrayList<Row>)listTemp);
            }
        }
        String factoryQuerySql = "select tcle.fid,tclf.fissyncdraw,tcp.fisloancommit from t_cfm_loancontractbill_e tcle left join t_cfm_loancontractbill_f tclf on tcle.fid=tclf.fid left join t_cfm_productfactory tcp on tcle.fproductfactoryid=tcp.fid";
        DataSet factoryData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)factoryQuerySql);
        HashMap<Long, Boolean> factoryMap = new HashMap<Long, Boolean>();
        if (!factoryData.isEmpty()) {
            for (Row factoryDatum : factoryData.copy()) {
                boolean isContractOccupy = factoryDatum.getBoolean("fisloancommit") != null && factoryDatum.getBoolean("fisloancommit") != false;
                boolean isLoanAmount = factoryDatum.getBoolean("fissyncdraw") != false && !isContractOccupy;
                factoryMap.put(factoryDatum.getLong("fid"), isLoanAmount);
            }
        }
        DynamicObjectCollection finOrgCol = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", finOrgInfoIdSet)});
        HashMap<Long, String> finOrgDsMap = new HashMap<Long, String>();
        for (DynamicObject finOrgInfo : finOrgCol) {
            finOrgDsMap.put(finOrgInfo.getLong("id"), finOrgInfo.getString("name"));
        }
        for (Map.Entry entry : slGcMap.entrySet()) {
            fid = (Long)entry.getKey();
            for (Row slGcDatum : (List)entry.getValue()) {
                BigDecimal bizAmount = factoryMap.get(fid) != null && (Boolean)factoryMap.get(fid) != false ? slGcDatum.getBigDecimal("floanamount") : slGcDatum.getBigDecimal("fshareamount");
                this.updateGcSql(slGcDatum, bizAmount, fid, (String)finOrgDsMap.get(slGcDatum.getLong("ffinorginfoid")));
            }
        }
        for (Map.Entry entry : bondGcMap.entrySet()) {
            fid = (Long)entry.getKey();
            for (Row bondGcDatum : (List)entry.getValue()) {
                this.updateGcSql(bondGcDatum, fid);
            }
        }
        String loanContractQuerySql = "select tcle.fid,tcle.fcreditortype,tcle.fcreditorid,tcle.ftextcreditor from t_cfm_loancontractbill_e tcle,t_gm_guaranteeuse tgg where tcle.fid=tgg.fgsrcbillid and tcle.fcreditortype is not null and tcle.fcreditortype != ' ' and tcle.fcreditorid is not null and tcle.fcreditorid != 0 and (tgg.fgcreditortype is null or tgg.fgcreditortype = ' ') and (tgg.fgcreditorid is null or tgg.fgcreditorid=0)";
        DataSet loanContractData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)loanContractQuerySql);
        if (!loanContractData.isEmpty()) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            for (Row loanContractDatum : loanContractData.copy()) {
                Object[] params = new Object[]{loanContractDatum.getString("fcreditortype"), loanContractDatum.getLong("fcreditorid"), loanContractDatum.getString("ftextcreditor"), loanContractDatum.getLong("fid")};
                paramList.add(params);
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_gm_guaranteeuse set fgcreditortype=?,fgcreditorid=?,fgcreditortext=? where fgsrcbillid=? and (fgcreditortype is null or fgcreditortype = ' ') and (fgcreditorid is null or fgcreditorid=0)", paramList);
            }
        }
        if (!(loanData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)(loanQuerySql = "select tcle.fid,tcle.fcreditortype,tcle.fcreditorid,tcle.ftextcreditor from t_cfm_loanbill_e tcle,t_gm_guaranteeuse tgg where tcle.fid=tgg.fgsrcbillid and tcle.fcreditortype is not null and tcle.fcreditortype != ' ' and tcle.fcreditorid is not null and tcle.fcreditorid != 0 and (tgg.fgcreditortype is null or tgg.fgcreditortype = ' ') and (tgg.fgcreditorid is null or tgg.fgcreditorid=0)"))).isEmpty()) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            for (Row loanDatum : loanData.copy()) {
                Object[] params = new Object[]{loanDatum.getString("fcreditortype"), loanDatum.getLong("fcreditorid"), loanDatum.getString("ftextcreditor"), loanDatum.getLong("fid")};
                paramList.add(params);
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)"update t_gm_guaranteeuse set fgcreditortype=?,fgcreditorid=?,fgcreditortext=? where fgsrcbillid=? and (fgcreditortype is null or fgcreditortype = ' ') and (fgcreditorid is null or fgcreditorid=0)", paramList);
            }
        }
        return 1;
    }

    private void updateGcSql(Row gcRow, BigDecimal bizAmount, Long fid, String creditorText) {
        String creditorType = gcRow.getString("fbankrole");
        Long creditorId = gcRow.getLong("ffinorginfoid");
        Long guaranteeContractId = gcRow.getLong("fguaranteecontractid");
        BigDecimal gRatio = gcRow.getBigDecimal("fgratio");
        BigDecimal gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED);
        String gcQuerySql = "select fid from t_gm_guaranteeuse where fgsrcbilltype in ('cfm_loancontract_bl_l','cfm_loancontractbill','cfm_loanbill_b_l','cfm_loanbill') and fgsrcbillid=" + fid + " and fguaranteecontractid=" + guaranteeContractId + " and (fgcreditortype is null or fgcreditortype = ' ' or fgcreditortype = '" + creditorType + "') and (fgcreditorid is null or fgcreditorid = 0 or fgcreditorid = " + creditorId + ")";
        DataSet gcData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)gcQuerySql);
        if (!gcData.isEmpty()) {
            Row gcDatum = gcData.copy().next();
            Object[] params = new Object[]{gRatio, gAmount, gAmount, gAmount, bizAmount, creditorType, creditorId, creditorText, gcDatum.getLong("fid")};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)"update t_gm_guaranteeuse set fgratio=?, fgamount=?, fgdebtamount=?, fgdebtbalance=?, fgsrcbillbizamount=?, fgcreditortype=?, fgcreditorid=?, fgcreditortext=? where fid=?", (Object[])params);
        } else {
            String querySql = "select fid,fgsrcbilltype,fgsrcbillid,fguaranteecontractid,fbillstatus,fgamount,fgratio,fgdebtbalance,fgdebtamount,fgdebtcurrency,fgcparty,fgexchrate,fgsrcbillno,fgsrcbillbizamount,fgdebtorg,fgdebtorgtext from t_gm_guaranteeuse where fgsrcbilltype in ('cfm_loancontract_bl_l','cfm_loancontractbill','cfm_loanbill_b_l','cfm_loanbill') and fgsrcbillid=" + fid + " and fguaranteecontractid=" + guaranteeContractId;
            DataSet queryData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)querySql);
            Long id = DB.genLongId((String)"t_gm_guaranteeuse");
            if (queryData.isEmpty()) {
                return;
            }
            Row queryDatum = queryData.copy().next();
            String insertSql = "insert into t_gm_guaranteeuse(fid,fgsrcbilltype,fgsrcbillid,fguaranteecontractid,fbillstatus,fgamount,fgratio,fgdebtbalance,fgdebtamount,fgdebtcurrency,fgcparty,fgexchrate,fgsrcbillno,fgsrcbillbizamount,fgdebtorg,fgdebtorgtext,fgcreditortype,fgcreditorid,fgcreditortext) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
            Object[] params = new Object[]{id, queryDatum.getString("fgsrcbilltype"), fid, guaranteeContractId, queryDatum.getString("fbillstatus"), gAmount, gRatio, gAmount, gAmount, queryDatum.getLong("fgdebtcurrency"), queryDatum.getString("fgcparty"), queryDatum.getBigDecimal("fgexchrate"), queryDatum.getString("fgsrcbillno"), bizAmount, queryDatum.getLong("fgdebtorg"), queryDatum.getString("fgdebtorgtext"), creditorType, creditorId, creditorText};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSql, (Object[])params);
        }
    }

    private void updateGcSql(Row gcRow, Long fid) {
        String creditorType = gcRow.getString("finvestortype");
        Long creditorId = gcRow.getLong("finvestorid");
        BigDecimal bizAmount = gcRow.getBigDecimal("finvestamount");
        String creditorText = gcRow.getString("finvestorname");
        Long guaranteeContractId = gcRow.getLong("fguaranteecontractid");
        BigDecimal gRatio = gcRow.getBigDecimal("fgratio");
        BigDecimal gAmount = bizAmount.multiply(gRatio).divide(Constants.ONE_HUNDRED);
        String gcQuerySql = "select fid from t_gm_guaranteeuse where fgsrcbilltype in ('cfm_loancontract_bo','cfm_loanbill_bond') and fgsrcbillid = " + fid + " and fguaranteecontractid = " + guaranteeContractId + " and (fgcreditortype is null or fgcreditortype = ' ' or fgcreditortype = '" + creditorType + "') and (fgcreditorid is null or fgcreditorid = 0 or fgcreditorid = " + creditorId + ")";
        DataSet gcData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)gcQuerySql);
        if (!gcData.isEmpty()) {
            Row gcDatum = gcData.copy().next();
            Object[] params = new Object[]{gRatio, gAmount, gAmount, gAmount, bizAmount, creditorType, creditorId, creditorText, gcDatum.getLong("fid")};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)"update t_gm_guaranteeuse set fgratio=?, fgamount=?, fgdebtamount=?, fgdebtbalance=?, fgsrcbillbizamount=?, fgcreditortype=?, fgcreditorid=?, fgcreditortext=? where fid=?", (Object[])params);
        } else {
            String querySql = "select fid,fgsrcbilltype,fgsrcbillid,fguaranteecontractid,fbillstatus,fgamount,fgratio,fgdebtbalance,fgdebtamount,fgdebtcurrency,fgcparty,fgexchrate,fgsrcbillno,fgsrcbillbizamount,fgdebtorg,fgdebtorgtext from t_gm_guaranteeuse where fgsrcbilltype in ('cfm_loancontract_bo','cfm_loanbill_bond') and fgsrcbillid=" + fid + " and fguaranteecontractid=" + guaranteeContractId;
            DataSet queryData = DB.queryDataSet((String)"GuaranteeUseBankUpgradeService", (DBRoute)DBRouteConst.TMC, (String)querySql);
            Long id = DB.genLongId((String)"t_gm_guaranteeuse");
            if (queryData.isEmpty()) {
                return;
            }
            Row queryDatum = queryData.copy().next();
            String insertSql = "insert into t_gm_guaranteeuse(fid,fgsrcbilltype,fgsrcbillid,fguaranteecontractid,fbillstatus,fgamount,fgratio,fgdebtbalance,fgdebtamount,fgdebtcurrency,fgcparty,fgexchrate,fgsrcbillno,fgsrcbillbizamount,fgdebtorg,fgdebtorgtext,fgcreditortype,fgcreditorid,fgcreditortext) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
            Object[] params = new Object[]{id, queryDatum.getString("fgsrcbilltype"), fid, guaranteeContractId, queryDatum.getString("fbillstatus"), gAmount, gRatio, gAmount, gAmount, queryDatum.getLong("fgdebtcurrency"), queryDatum.getString("fgcparty"), queryDatum.getBigDecimal("fgexchrate"), queryDatum.getString("fgsrcbillno"), bizAmount, queryDatum.getLong("fgdebtorg"), queryDatum.getString("fgdebtorgtext"), creditorType, creditorId, creditorText};
            DB.execute((DBRoute)DBRouteConst.TMC, (String)insertSql, (Object[])params);
        }
    }
}

