/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.contract;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class GuaranteeUseUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(GuaranteeUseUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            try {
                result.setLog("start upgrade guaranteeuse type and value");
                this.dataUpgrade("t_gm_guaranteeuse");
                result.setLog("end upgrade guaranteeuse type and value");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private int dataUpgrade(String tableName) {
        String applyQuerySql = "select fid, fgsrcbilltype, fgsrcbillid from " + tableName;
        DataSet guaranteeQuotaData = DB.queryDataSet((String)"GuaranteeUseUpgradeService", (DBRoute)DBRouteConst.TMC, (String)applyQuerySql);
        if (guaranteeQuotaData.isEmpty()) {
            return 0;
        }
        int i = 0;
        ArrayList<String> upgradeIds = new ArrayList<String>();
        for (Row guaranteeQuotaDatum : guaranteeQuotaData.copy()) {
            DynamicObject currencyDO;
            String formId = guaranteeQuotaDatum.getString("fgsrcbilltype");
            if (EmptyUtil.isEmpty((String)formId)) continue;
            String entityName = formId;
            ProductTypeEnum productTypeEnum = ProductTypeEnum.getEnumByFormId((String)formId);
            if (productTypeEnum != null) {
                entityName = productTypeEnum.getEntity();
            }
            if ("ifm_loancontractbill".equals(formId)) {
                entityName = "cfm_loancontractbill";
            }
            Long pkValue = guaranteeQuotaDatum.getLong("fgsrcbillid");
            String orgPropName = GuaranteeUseHelper.getBizPropName((String)entityName, (String)"debtor");
            orgPropName = orgPropName == null ? "org" : orgPropName;
            QFilter pkFilter = new QFilter("id", "=", (Object)pkValue);
            try {
                currencyDO = QueryServiceHelper.queryOne((String)entityName, (String)(orgPropName + ".id," + orgPropName + ".name"), (QFilter[])pkFilter.toArray());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            if (EmptyUtil.isEmpty((DynamicObject)currencyDO) || EmptyUtil.isEmpty((Long)currencyDO.getLong(orgPropName + ".id"))) continue;
            String updateSql = "update " + tableName + " set fgdebtorg = ?, fgdebtorgtext = ? where fid = ?";
            if ("gm_debt_register".equals(entityName)) {
                String debtQuerySql = "select freguaranteetype, fguaranteedorg, fguaranteedorgtext from t_gm_debtregister where fid = " + pkValue;
                DataSet debtRegisterData = DB.queryDataSet((String)"DebtRegisterService", (DBRoute)DBRouteConst.TMC, (String)debtQuerySql);
                if (debtRegisterData.isEmpty()) continue;
                Row debtRegisterDatum = debtRegisterData.copy().next();
                Object[] params = new Object[]{debtRegisterDatum.getLong("fguaranteedorg"), debtRegisterDatum.getString("fguaranteedorgtext"), guaranteeQuotaDatum.getLong("fid")};
                DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql, (Object[])params);
            } else {
                Object[] params = new Object[]{currencyDO.getLong(orgPropName + ".id"), currencyDO.getString(orgPropName + ".name"), guaranteeQuotaDatum.getLong("fid")};
                DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql, (Object[])params);
            }
            upgradeIds.add(guaranteeQuotaDatum.getString("fid"));
            ++i;
        }
        logger.info("upgrade upgradeIds:{}", (Object)String.join((CharSequence)",", upgradeIds));
        return i;
    }
}

