/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.guaranteeapply;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.BizRangeTypeEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.EntityMapFactory;
import kd.tmc.gm.common.enums.GmSourceBillTypeEnum;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.enums.GuaContractApplTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeHelper;
import kd.tmc.gm.common.helper.GuaranteeQuotaHelper;

public class GuaranteeApplyUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("currency");
        selector.add("guacontract");
        selector.add("ensureentity");
        selector.add("ensureentity.e_type");
        selector.add("ensureentity.e_ensuretext");
        selector.add("ensureentity.e_ensure");
        selector.add("ensureentity.e_amount");
        selector.add("ensureentity.e_ensurerate");
        selector.add("ensureentity.e_remarks");
        selector.add("ensureamtentity");
        selector.add("ensureamtentity.a_type");
        selector.add("ensureamtentity.a_ensuretext");
        selector.add("ensureamtentity.a_ensure");
        selector.add("ensureamtentity.a_ensurerate");
        selector.add("ensureamtentity.a_amount");
        selector.add("ensureamtentity.a_remarks");
        selector.add("morentity");
        selector.add("morentity.m_pleg");
        selector.add("morentity.m_pledgevalue");
        selector.add("morentity.m_totalpledgevalue");
        selector.add("morentity.m_amount");
        selector.add("morentity.m_remarks");
        selector.add("pletgageentity");
        selector.add("pletgageentity.p_pleg");
        selector.add("pletgageentity.p_pledgevalue");
        selector.add("pletgageentity.p_totalpledgevalue");
        selector.add("pletgageentity.m_amount");
        selector.add("pletgageentity.p_remarks");
        selector.add("entry_guaranteeorg");
        selector.add("entry_guaranteeorg.a_guaranteequota");
        selector.add("entry_guaranteeorg.a_gamount");
        selector.add("entry_guaranteedorg");
        selector.add("entry_guaranteedorg.b_guaranteequota");
        selector.add("entry_guaranteedorg.b_gamount");
        selector.add("entry_guaranteedorg.b_reguaranteetype");
        selector.add("entry_guaranteedorg.b_guaranteedorg");
        List extFields = EntityMapFactory.getDealService((String)BizRangeTypeEnum.CHANGE.getValue()).getExtSelectorProp("gm_guaranteeapply", "gm_guaranteecontract", BizRangeTypeEnum.CHANGE.getValue(), true);
        if (EmptyUtil.isNoEmpty((Object)extFields)) {
            selector.addAll(extFields);
        }
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> guaranteeContractList = new ArrayList<DynamicObject>(10);
        for (DynamicObject applyBill : dataEntities) {
            String applyType = applyBill.getString("applytype");
            GuaranteeQuotaHelper.cancelWriteBackQuota((DynamicObject)applyBill, (String)GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue());
            if (GuaContractApplTypeEnum.isAddApply((String)applyType) && !applyBill.getBoolean("ishascontract")) continue;
            DynamicObjectCollection contracts = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("applybill", "=", applyBill.getPkValue())});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)contracts)) {
                Object[] contractIs = contracts.stream().filter(o -> BillStatusEnum.SAVE.getValue().equals(o.getString("billstatus"))).map(o -> o.get("id")).toArray();
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"gm_guaranteecontract", (Object[])contractIs, (OperateOption)OperateOption.create());
            }
            if (GuaContractApplTypeEnum.isChangeApply((String)applyType)) {
                DynamicObject guaContract = applyBill.getDynamicObject("guacontract");
                Long guaContractId = (Long)guaContract.getPkValue();
                DynamicObject guaranteeContract = TmcDataServiceHelper.loadSingle((Object)guaContractId, (String)"gm_guaranteecontract");
                DynamicObject oldGuaranteeContract = BillChangeHistoryHelper.genDelChangeHistory((Long)guaContractId, (String)"gm_guaranteecontract");
                List extFields = EntityMapFactory.getDealService((String)BizRangeTypeEnum.CHANGE.getValue()).getExtSelectorProp("gm_guaranteeapply", "gm_guaranteecontract", BizRangeTypeEnum.CHANGE.getValue(), false);
                extFields.addAll(GuaranteeContractHelper.CHANGEFIELDS);
                GuaranteeHelper.copyValue((DynamicObject)oldGuaranteeContract, (DynamicObject)guaranteeContract, (List)extFields, (List)GuaranteeContractHelper.CONTRACT_ENTRY_NAMES);
                guaranteeContract.set("bizstatus", (Object)GuaConBizStatusEnum.CHANGING.getValue());
                guaranteeContractList.add(guaranteeContract);
                GuaranteeQuotaHelper.cancelWriteBackChangeApplyQuota((DynamicObject)guaranteeContract, (DynamicObject)oldGuaranteeContract);
            }
            if (guaranteeContractList.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])guaranteeContractList.toArray(new DynamicObject[0]));
        }
    }
}

