/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguaapply;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.enums.LetterOfGuaApplyBizTypeEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeHelper;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaApplyAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("currency");
        selector.add("amount");
        selector.add("startdate");
        selector.add("expiredate");
        selector.add("guaranteeterm");
        selector.add("contractno");
        selector.add("contractamount");
        selector.add("description");
        selector.add("comprehfeerate");
        selector.add("estimatedtotalfee");
        selector.add("feepaymentmethod");
        selector.add("isrevokableinadv");
        selector.add("hasunfrozenfund");
        selector.add("unfrozenfundbank");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> letterOfGuaranteeList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject letterOfGuaApply : dataEntities) {
            if (!LetterOfGuaApplyBizTypeEnum.isChangeLetter((String)letterOfGuaApply.getString("biztype"))) continue;
            DynamicObject letterOfGuaranteeF7 = letterOfGuaApply.getDynamicObject("letterofguarantee");
            Long letterOfGuaranteeId = (Long)letterOfGuaranteeF7.getPkValue();
            DynamicObject letterOfGuarantee = GuaranteeContractHelper.getLetterOfGua((Long)letterOfGuaranteeId);
            this.saveHistory(letterOfGuarantee, letterOfGuaApply);
            GuaranteeHelper.copyValue((DynamicObject)letterOfGuaApply, (DynamicObject)letterOfGuarantee, (List)LetterOfGuaranteeHelper.CHANGEFIELDS, Collections.singletonList("entry_gcontract"));
            letterOfGuarantee.set("bizstatus", (Object)BizStatusEnum.REGISTERED.getValue());
            letterOfGuaranteeList.add(letterOfGuarantee);
            LetterOfGuaranteeHelper.changeCreditLimit((DynamicObject)letterOfGuarantee, (DynamicObject)letterOfGuaApply, (boolean)true);
            LetterOfGuaranteeHelper.changeSuretyBill((DynamicObject)letterOfGuarantee, (DynamicObject)letterOfGuaApply);
        }
        DynamicObject[] letterOfGuarantees = letterOfGuaranteeList.toArray(new DynamicObject[0]);
        LetterOfGuaranteeHelper.saveGuaranteeUse((DynamicObject[])letterOfGuarantees);
        List bizIdSet = letterOfGuaranteeList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        GuaranteeUseHelper.confirmGuaranteeUse(bizIdSet);
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("history", "true");
        TmcOperateServiceHelper.execOperate((String)"save", (String)"gm_letterofguarantee", (DynamicObject[])letterOfGuarantees, (OperateOption)operate);
    }

    private void saveHistory(DynamicObject letterOfGua, DynamicObject apply) {
        BillChangeHistoryHelper.addChangeHistory((Long)((Long)apply.getPkValue()), (String)apply.getDataEntityType().getName(), (String)apply.getString("billno"), (String)apply.getString("description"), (String)"GH", (DynamicObject)letterOfGua);
    }
}

