/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguarantee;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaranteeClaimService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("creditlimit");
        sl.add("amount");
        sl.add("claimdate");
        sl.add("bizstatus");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String date = (String)this.operationVariable.get("date");
        for (DynamicObject lgDO : dataEntities) {
            lgDO.set("claimdate", (Object)DateUtils.stringToDate((String)date, (String)"yyyy-MM-dd"));
            lgDO.set("bizstatus", (Object)BizStatusEnum.CLAIMED.getValue());
            LetterOfGuaranteeHelper.returnCreditlimit((DynamicObject)lgDO);
            LetterOfGuaranteeHelper.updateSuretyStatus((DynamicObject)lgDO, (String)BizStatusEnum.CLAIMED.getValue());
        }
        this.releaseGuaranteeUse(dataEntities);
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void releaseGuaranteeUse(DynamicObject[] letters) {
        ArrayList<GuaranteeUseReturnBean> returnGuList = new ArrayList<GuaranteeUseReturnBean>(letters.length);
        for (DynamicObject letter : letters) {
            Long lgId = letter.getLong("id");
            String billtype = letter.getDataEntityType().getName();
            BigDecimal retAmt = letter.getBigDecimal("amount");
            GuaranteeUseReturnBean returnBean = new GuaranteeUseReturnBean();
            returnBean.setBizBillId(lgId);
            returnBean.setReturnBillId(lgId);
            returnBean.setReturnBillType(billtype);
            returnBean.setReturnAmount(retAmt);
            returnGuList.add(returnBean);
        }
        GuaranteeUseHelper.returnGuaranteeUse(returnGuList);
    }
}

