/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.opservice.letterofguarantee;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.gm.common.enums.BizStatusEnum;
import kd.tmc.gm.common.helper.LetterOfGuaranteeHelper;

public class LetterOfGuaranteeSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("creditlimit");
        sl.add("currency");
        sl.add("amount");
        sl.add("billstatus");
        sl.add("entry_gcontract");
        sl.add("bizstatus");
        sl.add("entryentity");
        sl.add("entryentity.e_beneficiarytype");
        sl.add("entryentity.e_beneficiary");
        sl.add("entryentity.e_textbeneficiary");
        sl.add("beneficiarytype");
        sl.add("beneficiary");
        sl.add("textbeneficiary");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        boolean fromEdit = this.getOperationVariable().containsKey("op_from_edit_form");
        boolean isFormImport = this.getOperationVariable().containsKey("importtag_of_datasource");
        boolean isFromImportType = this.getOperationVariable().containsKey("importtype");
        if (fromEdit || isFormImport || isFromImportType) {
            LetterOfGuaranteeHelper.saveGuaranteeUse((DynamicObject[])dataEntities);
            ArrayList<Long> bizIdSet = new ArrayList<Long>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                if (!BillStatusEnum.SUBMIT.getValue().equals(dataEntity.getString("billstatus")) && !BillStatusEnum.AUDIT.getValue().equals(dataEntity.getString("billstatus"))) continue;
                bizIdSet.add(dataEntity.getLong("id"));
            }
            GuaranteeUseHelper.confirmGuaranteeUse(bizIdSet);
        }
        if (!this.isFromIsc()) {
            LetterOfGuaranteeHelper.preUseCreditLimit((DynamicObject[])dataEntities);
        }
        LetterOfGuaranteeHelper.updateBeneficiaryType((DynamicObject[])dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        this.handleOpFromIsc(dataEntities);
    }

    private void handleOpFromIsc(DynamicObject[] dataEntities) {
        if (this.isFromIsc()) {
            ArrayList<Long> confirmBizIdSet = new ArrayList<Long>(dataEntities.length);
            for (DynamicObject letter : dataEntities) {
                if (!BillStatusEnum.AUDIT.getValue().equals(letter.getString("billstatus"))) continue;
                confirmBizIdSet.add(letter.getLong("id"));
            }
            if (!confirmBizIdSet.isEmpty()) {
                GuaranteeUseHelper.confirmGuaranteeUse(confirmBizIdSet);
            }
            this.releaseGuaranteeUse(dataEntities);
        }
    }

    private void releaseGuaranteeUse(DynamicObject[] letters) {
        ArrayList<GuaranteeUseReturnBean> returnGuList = new ArrayList<GuaranteeUseReturnBean>(letters.length);
        for (DynamicObject letter : letters) {
            if (!BizStatusEnum.CANCELLED.getValue().equals(letter.getString("bizstatus"))) continue;
            Long lgId = letter.getLong("id");
            String billtype = letter.getDataEntityType().getName();
            BigDecimal retAmt = letter.getBigDecimal("amount");
            GuaranteeUseReturnBean returnBean = new GuaranteeUseReturnBean();
            returnBean.setBizBillId(lgId);
            returnBean.setReturnBillId(lgId);
            returnBean.setReturnBillType(billtype);
            returnBean.setReturnAmount(retAmt);
            returnGuList.add(returnBean);
        }
        if (!returnGuList.isEmpty()) {
            GuaranteeUseHelper.returnGuaranteeUse(returnGuList);
        }
    }

    private boolean isFromIsc() {
        return Boolean.parseBoolean((String)this.operationVariable.get("op_from_isc"));
    }
}

