/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.contract;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.CtrlLimitEnum;
import kd.tmc.gm.common.enums.GmSourceBillTypeEnum;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;
import kd.tmc.gm.common.enums.PledgeStatusEnum;
import kd.tmc.gm.common.helper.GuaranteeContractHelper;
import kd.tmc.gm.common.helper.GuaranteeQuotaHelper;

public class GuaranteeContractSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sl = new ArrayList<String>(10);
        sl.add("amount");
        sl.add("billno");
        sl.add("currency");
        sl.add("guaranteeway");
        sl.add("ensureentity");
        sl.add("ensureamtentity");
        sl.add("morentity");
        sl.add("enddate");
        sl.add("begindate");
        sl.add("sourcebillid");
        sl.add("applybill");
        sl.add("pletgageentity");
        sl.add("ensureentity.e_ensurerate");
        sl.add("ensureentity.e_amount");
        sl.add("ensureentity.e_ensurerate");
        sl.add("ensureentity.e_amount");
        sl.add("ensureamtentity.a_amount");
        sl.add("ensureamtentity.a_ensurerate");
        sl.add("morentity.m_amount");
        sl.add("morentity.m_pleg");
        sl.add("pletgageentity.p_amount");
        sl.add("pletgageentity.p_pleg");
        sl.add("isneedreg");
        sl.add("creditor");
        sl.add("entry_guaranteeorg");
        sl.add("entry_guaranteedorg");
        sl.add("entry_guaranteeorg.a_guaranteetype");
        sl.add("entry_guaranteedorg.b_reguaranteetype");
        sl.add("creditortype");
        sl.add("entry_guaranteeorg.a_guaranteeorgtext");
        sl.add("entry_guaranteedorg.b_guaranteedorgtext");
        sl.add("creditortext");
        sl.add("entry_guaranteeorg.a_guaranteeorg");
        sl.add("entry_guaranteedorg.b_guaranteedorg");
        sl.add("entry_guaranteeorg.a_gamount");
        sl.add("entry_guaranteedorg.b_gamount");
        sl.add("entry_guaranteeorg.a_guaranteequota");
        sl.add("entry_guaranteedorg.b_guaranteequota");
        sl.add("creditor");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            DynamicObject currency = info.getDynamicObject("currency");
            DynamicObjectCollection guaOrgCollection = info.getDynamicObjectCollection("entry_guaranteeorg");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)guaOrgCollection)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeContractSubmitValidator_7", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            DynamicObject applyBill = GuaranteeQuotaHelper.handleApplyBackQuota((DynamicObject)info, (String)GmSourceBillTypeEnum.GUARANTEE_CONTRACT.getValue());
            this.validateGuaOrgQuota(extendedDataEntity, guaOrgCollection, currency, applyBill);
            DynamicObjectCollection reGuaCollection = info.getDynamicObjectCollection("entry_guaranteedorg");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)reGuaCollection)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GuaranteeContractSubmitValidator_8", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            this.validateReGuaQuota(extendedDataEntity, reGuaCollection, currency, applyBill);
            GuaranteeContractHelper.handleEntryByWay((DynamicObject)info);
            DynamicObjectCollection ensuEntitys = info.getDynamicObjectCollection("ensureentity");
            DynamicObjectCollection ensuAmtEntitys = info.getDynamicObjectCollection("ensureamtentity");
            DynamicObjectCollection morEntitys = info.getDynamicObjectCollection("morentity");
            DynamicObjectCollection pleEntitys = info.getDynamicObjectCollection("pletgageentity");
            BigDecimal eAmt = ensuEntitys.stream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal aAmt = ensuAmtEntitys.stream().map(o -> o.getBigDecimal("a_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal morAmt = morEntitys.stream().map(o -> o.getBigDecimal("m_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal pleAmt = pleEntitys.stream().map(o -> o.getBigDecimal("p_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalAmt = eAmt.add(aAmt).add(morAmt).add(pleAmt);
            if ((EmptyUtil.isNoEmpty((DynamicObjectCollection)ensuEntitys) || EmptyUtil.isNoEmpty((DynamicObjectCollection)ensuAmtEntitys) || EmptyUtil.isNoEmpty((DynamicObjectCollection)morEntitys) || EmptyUtil.isNoEmpty((DynamicObjectCollection)pleEntitys)) && totalAmt.compareTo(info.getBigDecimal("amount")) != 0) {
                this.addWarningMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4fe1\u606f\u4e2d\u7684\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u62c5\u4fdd\u5408\u7ea6\u91d1\u989d\u3002", (String)"GuaranteeContractSubmitValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (morEntitys.size() > 0) {
                long mCount = morEntitys.stream().filter(o -> EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("m_pleg"))).count();
                if (mCount > 0L) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4fe1\u606f\u4e2d\u7684\u62b5\u8d28\u62bc\u7269\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"GuaranteeContractSubmitValidator_4", (String)"tmc-gm-business", (Object[])new Object[0]));
                    continue;
                }
                morEntitys.forEach(m -> {
                    DynamicObject pledgeBill = QueryServiceHelper.queryOne((String)"gm_pledgebill", (String)String.join((CharSequence)",", "pledgevalue", "billno"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)m.getDynamicObject("m_pleg").getLong("id"))});
                    if (EmptyUtil.isNoEmpty((DynamicObject)pledgeBill) && m.getBigDecimal("m_amount").compareTo(pledgeBill.getBigDecimal("pledgevalue")) > 0) {
                        this.addWarningMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269%s\u7684\u53ef\u62b5\u62bc\u4ef7\u503c\u5c0f\u4e8e\u5f53\u524d\u62b5\u62bc\u4ef7\u503c\u3002", (String)"GuaranteeContractSubmitValidator_15", (String)"tmc-gm-business", (Object[])new Object[]{pledgeBill.getString("billno")}));
                    }
                });
            }
            if (pleEntitys.size() > 0) {
                long pCount = pleEntitys.stream().filter(o -> EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("p_pleg"))).count();
                if (pCount > 0L) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4fe1\u606f\u4e2d\u7684\u62b5\u8d28\u62bc\u7269\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"GuaranteeContractSubmitValidator_4", (String)"tmc-gm-business", (Object[])new Object[0]));
                    continue;
                }
                pleEntitys.forEach(m -> {
                    DynamicObject pledgeBill = QueryServiceHelper.queryOne((String)"gm_pledgebill", (String)String.join((CharSequence)",", "pledgevalue", "billno"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)m.getDynamicObject("p_pleg").getLong("id"))});
                    if (EmptyUtil.isNoEmpty((DynamicObject)pledgeBill) && m.getBigDecimal("p_amount").compareTo(pledgeBill.getBigDecimal("pledgevalue")) > 0) {
                        this.addWarningMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62b5\u8d28\u62bc\u7269%s\u7684\u53ef\u62b5\u62bc\u4ef7\u503c\u5c0f\u4e8e\u5f53\u524d\u62b5\u62bc\u4ef7\u503c\u3002", (String)"GuaranteeContractSubmitValidator_15", (String)"tmc-gm-business", (Object[])new Object[]{pledgeBill.getString("billno")}));
                    }
                });
            }
            String creditType = info.getString("creditortype");
            boolean isOther = GuaranteeTypeEnum.OTHER.getValue().equals(creditType);
            Long creditorId = info.getLong("creditor");
            for (int i = 0; i < reGuaCollection.size(); ++i) {
                if (isOther || !EmptyUtil.isNoEmpty((Long)creditorId) || ((DynamicObject)reGuaCollection.get(i)).getLong("b_guaranteedorg") != creditorId.longValue()) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u4e2d\u88ab\u62c5\u4fdd\u4eba\u548c\u503a\u6743\u4eba\u4e0d\u80fd\u76f8\u540c\u3002", (String)"GuaranteeContractSubmitValidator_6", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            Date beginDate = info.getDate("begindate");
            Date endDate = info.getDate("enddate");
            if (endDate != null && !endDate.after(beginDate)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u3002", (String)"GuaranteeApplySaveValidator_5", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            long morCount = morEntitys.stream().filter(o -> !BillStatusEnum.AUDIT.getValue().equals(o.getDynamicObject("m_pleg").getString("billstatus")) || PledgeStatusEnum.CACELPLEDGE.getValue().equals(o.getDynamicObject("m_pleg").getString("pledgestatus"))).count();
            long pleCount = pleEntitys.stream().filter(o -> !BillStatusEnum.AUDIT.getValue().equals(o.getDynamicObject("p_pleg").getString("billstatus")) || PledgeStatusEnum.CACELPLEDGE.getValue().equals(o.getDynamicObject("p_pleg").getString("pledgestatus"))).count();
            if (!EmptyUtil.isNoEmpty((Long)morCount) && !EmptyUtil.isNoEmpty((Long)pleCount)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4fe1\u606f\u4e2d\u6240\u9009\u7684\u62b5\u8d28\u62bc\u7269\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u6216\u5df2\u88ab\u6ce8\u9500\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"GuaranteeContractSubmitValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }

    private void validateReGuaQuota(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection reGuaCollection, DynamicObject currency, DynamicObject changeApplyBill) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reGuaCollection)) {
            return;
        }
        DynamicObject info = extendedDataEntity.getDataEntity();
        Long currencyId = currency.getLong("id");
        HashMap<Long, BigDecimal> reGuaQuotaMap = new HashMap<Long, BigDecimal>();
        for (int i = 0; i < reGuaCollection.size(); ++i) {
            BigDecimal beforeQuotaAmt;
            DynamicObjectCollection quotaUseList;
            BigDecimal quotaAmt;
            HashSet quotaReOrgIds;
            DynamicObject reGuaEntry = (DynamicObject)reGuaCollection.get(i);
            DynamicObject guaranteeQuota = reGuaEntry.getDynamicObject("b_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.getPkValue(), (String)"gm_guaranteequota", (String)GuaranteeQuotaHelper.QUOTA_PROP_NAME);
            String quotaEnable = guaranteeQuota.getString("enable");
            if (BaseEnableEnum.DISABLE.getValue().equals(quotaEnable) || !BillStatusEnum.AUDIT.getValue().equals(guaranteeQuota.getString("status"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u5df2\u5173\u95ed\u6216\u88ab\u53cd\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_10", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            String ctrlLimit = guaranteeQuota.getString("ctrllimit");
            DynamicObjectCollection guaranteedOrgCollection = guaranteeQuota.getDynamicObjectCollection("entry_guaranteedorg");
            Set<Object> set = quotaReOrgIds = EmptyUtil.isEmpty((DynamicObjectCollection)guaranteedOrgCollection) ? new HashSet(8) : guaranteedOrgCollection.stream().map(q -> q.getLong("q_guaranteedorg")).collect(Collectors.toSet());
            if (!CtrlLimitEnum.GUARANTEED_ORG.getValue().equals(ctrlLimit) || !quotaReOrgIds.contains(reGuaEntry.getLong("b_guaranteedorg"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u63a7\u5236\u5bf9\u8c61\u6216\u88ab\u62c5\u4fdd\u4eba\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_14", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            Date beginDate = guaranteeQuota.getDate("begindate");
            Date endDate = guaranteeQuota.getDate("enddate");
            if (beginDate.after(info.getDate("begindate")) || endDate != null && endDate.before(info.getDate("begindate"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u4e0d\u5728\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_11", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            if (EmptyUtil.isEmpty((BigDecimal)(quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal((DynamicObject)guaranteeQuota, (Long)currencyId, (BigDecimal)reGuaEntry.getBigDecimal("b_gamount"))))) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230%1$s\u5e01\u79cd\u548c%2$s\u5e01\u79cd\u7684\u8f6c\u6362\u6c47\u7387\u3002", (String)"GuaranteeApplySubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]), currency.getString("name"), guaranteeQuota.getDynamicObject("currency").getString("name")));
                continue;
            }
            BigDecimal changeApplyQuotaAmt = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObject)changeApplyBill)) {
                QFilter idFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.getPkValue());
                idFilter.and(new QFilter("gmorgtype", "=", (Object)reGuaEntry.getString("b_reguaranteetype")));
                idFilter.and(new QFilter("gmorgid", "=", (Object)reGuaEntry.getLong("b_guaranteedorg")));
                idFilter.and(new QFilter("gmbilltype", "=", (Object)GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue()));
                idFilter.and(new QFilter("gmbillid", "=", changeApplyBill.getPkValue()));
                quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)"gmactualquota,gmadvancequota", (QFilter[])new QFilter[]{idFilter});
                for (DynamicObject quotaUseDO : quotaUseList) {
                    changeApplyQuotaAmt = changeApplyQuotaAmt.add(quotaUseDO.getBigDecimal("gmadvancequota")).add(quotaUseDO.getBigDecimal("gmactualquota"));
                }
                quotaAmt = quotaAmt.subtract(changeApplyQuotaAmt);
            }
            if (EmptyUtil.isEmpty((BigDecimal)(beforeQuotaAmt = (BigDecimal)reGuaQuotaMap.get((Long)guaranteeQuota.getPkValue())))) {
                beforeQuotaAmt = BigDecimal.ZERO;
            }
            if (quotaAmt.add(beforeQuotaAmt).compareTo(guaranteeQuota.getBigDecimal("availablequota")) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_1", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
                continue;
            }
            DynamicObjectCollection entryList = guaranteeQuota.getDynamicObjectCollection("entry_guaranteedorg");
            Long reGuaOrgId = reGuaEntry.getLong("b_guaranteedorg");
            for (DynamicObject entry : entryList) {
                if (!reGuaOrgId.equals(entry.getLong("q_guaranteedorg"))) continue;
                QFilter qidFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.getPkValue());
                List<String> guaranteedOrgTypeList = Collections.singletonList(entry.getString("q_reguaranteetype"));
                if (GuaranteeTypeEnum.TMCORG.getValue().equals(entry.getString("q_reguaranteetype"))) {
                    guaranteedOrgTypeList = Arrays.asList(GuaranteeTypeEnum.ORG.getValue(), GuaranteeTypeEnum.TMCORG.getValue());
                }
                qidFilter.and(new QFilter("gmorgtype", "in", guaranteedOrgTypeList));
                qidFilter.and(new QFilter("gmorgid", "=", (Object)entry.getLong("q_guaranteedorg")));
                quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)"gmactualquota,gmadvancequota", (QFilter[])new QFilter[]{qidFilter});
                BigDecimal usedQuotaSum = BigDecimal.ZERO;
                BigDecimal advanceQuotaSum = BigDecimal.ZERO;
                for (DynamicObject quotaUseDO : quotaUseList) {
                    usedQuotaSum = usedQuotaSum.add(quotaUseDO.getBigDecimal("gmactualquota"));
                    advanceQuotaSum = advanceQuotaSum.add(quotaUseDO.getBigDecimal("gmadvancequota"));
                }
                entry.set("q_usedquota", (Object)usedQuotaSum);
                entry.set("q_advancequota", (Object)advanceQuotaSum);
                if (quotaAmt.add(beforeQuotaAmt).compareTo(GuaranteeQuotaHelper.getAvailableQuota((DynamicObject)entry)) <= 0) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_13", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
                break;
            }
            reGuaQuotaMap.put((Long)guaranteeQuota.getPkValue(), beforeQuotaAmt.add(quotaAmt));
        }
    }

    private void validateGuaOrgQuota(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection guaOrgCollection, DynamicObject currency, DynamicObject changeApplyBill) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaOrgCollection)) {
            return;
        }
        DynamicObject info = extendedDataEntity.getDataEntity();
        Long currencyId = currency.getLong("id");
        for (int i = 0; i < guaOrgCollection.size(); ++i) {
            BigDecimal quotaAmt;
            DynamicObject guaOrgEntry = (DynamicObject)guaOrgCollection.get(i);
            DynamicObject guaranteeQuota = guaOrgEntry.getDynamicObject("a_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.getPkValue(), (String)"gm_guaranteequota", (String)GuaranteeQuotaHelper.QUOTA_PROP_NAME);
            String quotaEnable = guaranteeQuota.getString("enable");
            if (BaseEnableEnum.DISABLE.getValue().equals(quotaEnable) || !BillStatusEnum.AUDIT.getValue().equals(guaranteeQuota.getString("status"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u5df2\u5173\u95ed\u6216\u88ab\u53cd\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_9", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            String ctrlLimit = guaranteeQuota.getString("ctrllimit");
            Long quotaOrgId = guaranteeQuota.getLong("org.id");
            if (!CtrlLimitEnum.GUARANTEE_ORG.getValue().equals(ctrlLimit) || !quotaOrgId.equals(guaOrgEntry.getLong("a_guaranteeorg"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u63a7\u5236\u5bf9\u8c61\u6216\u62c5\u4fdd\u4eba\u4e0d\u7b26\u5408\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_12", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            Date beginDate = guaranteeQuota.getDate("begindate");
            Date endDate = guaranteeQuota.getDate("enddate");
            if (beginDate.after(info.getDate("begindate")) || endDate != null && endDate.before(info.getDate("begindate"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5f00\u59cb\u65e5\u671f\u4e0d\u5728\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u5355\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_16", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
            }
            if (EmptyUtil.isEmpty((BigDecimal)(quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal((DynamicObject)guaranteeQuota, (Long)currencyId, (BigDecimal)guaOrgEntry.getBigDecimal("a_gamount"))))) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230%1$s\u5e01\u79cd\u548c%2$s\u5e01\u79cd\u7684\u8f6c\u6362\u6c47\u7387\u3002", (String)"GuaranteeApplySubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]), currency.getString("name"), guaranteeQuota.getDynamicObject("currency").getString("name")));
                continue;
            }
            BigDecimal changeApplyQuotaAmt = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((DynamicObject)changeApplyBill)) {
                QFilter idFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.getPkValue());
                idFilter.and(new QFilter("gmorgtype", "=", (Object)guaOrgEntry.getString("a_guaranteetype")));
                idFilter.and(new QFilter("gmorgid", "=", (Object)guaOrgEntry.getLong("a_guaranteeorg")));
                idFilter.and(new QFilter("gmbilltype", "=", (Object)GmSourceBillTypeEnum.GUARANTEE_APPLY.getValue()));
                idFilter.and(new QFilter("gmbillid", "=", changeApplyBill.getPkValue()));
                DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)"gmactualquota,gmadvancequota", (QFilter[])new QFilter[]{idFilter});
                for (DynamicObject quotaUseDO : quotaUseList) {
                    changeApplyQuotaAmt = changeApplyQuotaAmt.add(quotaUseDO.getBigDecimal("gmadvancequota")).add(quotaUseDO.getBigDecimal("gmactualquota"));
                }
                quotaAmt = quotaAmt.subtract(changeApplyQuotaAmt);
            }
            if (quotaAmt.compareTo(guaranteeQuota.getBigDecimal("availablequota")) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeContractSubmitValidator_5", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
        }
    }
}

