/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.contract;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.helper.GuaranteeQuotaHelper;

public class GuaranteeContractUnCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sl = new ArrayList<String>(10);
        sl.add("bizstatus");
        sl.add("oldbizstatus");
        sl.add("billstatus");
        sl.add("currency");
        sl.add("closeuser");
        sl.add("closetime");
        sl.add("ischange");
        sl.add("begindate");
        sl.add("enddate");
        sl.add("ensureentity.e_amount");
        sl.add("ensureamtentity.a_amount");
        sl.add("morentity.m_amount");
        sl.add("morentity.m_pleg");
        sl.add("pletgageentity.p_pleg");
        sl.add("pletgageentity.p_amount");
        sl.add("entry_guaranteeorg");
        sl.add("entry_guaranteedorg");
        sl.add("entry_guaranteeorg.a_guaranteetype");
        sl.add("entry_guaranteedorg.b_reguaranteetype");
        sl.add("entry_guaranteeorg.a_guaranteeorgtext");
        sl.add("entry_guaranteedorg.b_guaranteedorgtext");
        sl.add("entry_guaranteeorg.a_guaranteeorg");
        sl.add("entry_guaranteedorg.b_guaranteedorg");
        sl.add("entry_guaranteeorg.a_gamount");
        sl.add("entry_guaranteedorg.b_gamount");
        sl.add("entry_guaranteeorg.a_guaranteequota");
        sl.add("entry_guaranteedorg.b_guaranteequota");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject info = extendedDataEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(info.getString("billstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u975e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u5173\u95ed\u3002", (String)"GuaranteeContractUnCloseValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (!GuaConBizStatusEnum.CLOSED.getValue().equals(info.getString("bizstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u975e\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u53cd\u5173\u95ed\u3002", (String)"GuaranteeContractUnCloseValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (info.getBoolean("ischange")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u53d8\u66f4\u7684\u62c5\u4fdd\u5408\u540c\u4e0d\u5141\u8bb8\u53cd\u5173\u95ed\u3002", (String)"GuaranteeContractUnCloseValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            DynamicObject currency = info.getDynamicObject("currency");
            DynamicObjectCollection guaOrgCollection = info.getDynamicObjectCollection("entry_guaranteeorg");
            this.validateGuaOrgQuota(extendedDataEntity, guaOrgCollection, currency);
            DynamicObjectCollection reGuaCollection = info.getDynamicObjectCollection("entry_guaranteedorg");
            this.validateReGuaQuota(extendedDataEntity, reGuaCollection, currency);
        }
    }

    private void validateReGuaQuota(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection reGuaCollection, DynamicObject currency) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reGuaCollection)) {
            return;
        }
        Long currencyId = currency.getLong("id");
        HashMap<Long, BigDecimal> reGuaQuotaMap = new HashMap<Long, BigDecimal>();
        for (int i = 0; i < reGuaCollection.size(); ++i) {
            DynamicObject reGuaEntry = (DynamicObject)reGuaCollection.get(i);
            DynamicObject guaranteeQuota = reGuaEntry.getDynamicObject("b_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.getPkValue(), (String)"gm_guaranteequota", (String)GuaranteeQuotaHelper.QUOTA_PROP_NAME);
            String quotaEnable = guaranteeQuota.getString("enable");
            if (BaseEnableEnum.DISABLE.getValue().equals(quotaEnable)) continue;
            BigDecimal quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal((DynamicObject)guaranteeQuota, (Long)currencyId, (BigDecimal)reGuaEntry.getBigDecimal("b_gamount"));
            if (EmptyUtil.isEmpty((BigDecimal)quotaAmt)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230%1$s\u5e01\u79cd\u548c%2$s\u5e01\u79cd\u7684\u8f6c\u6362\u6c47\u7387\u3002", (String)"GuaranteeApplySubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]), currency.getString("name"), guaranteeQuota.getDynamicObject("currency").getString("name")));
                continue;
            }
            BigDecimal beforeQuotaAmt = (BigDecimal)reGuaQuotaMap.get((Long)guaranteeQuota.getPkValue());
            if (EmptyUtil.isEmpty((BigDecimal)beforeQuotaAmt)) {
                beforeQuotaAmt = BigDecimal.ZERO;
            }
            if (quotaAmt.add(beforeQuotaAmt).compareTo(guaranteeQuota.getBigDecimal("availablequota")) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_2", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
                continue;
            }
            DynamicObjectCollection entryList = guaranteeQuota.getDynamicObjectCollection("entry_guaranteedorg");
            Long reGuaOrgId = reGuaEntry.getLong("b_guaranteedorg");
            for (DynamicObject entry : entryList) {
                if (!reGuaOrgId.equals(entry.getLong("q_guaranteedorg"))) continue;
                QFilter qidFilter = new QFilter("gmguaranteequota", "=", guaranteeQuota.getPkValue());
                qidFilter.and(new QFilter("gmorgtype", "=", (Object)entry.getString("q_reguaranteetype")));
                qidFilter.and(new QFilter("gmorgid", "=", (Object)entry.getLong("q_guaranteedorg")));
                DynamicObjectCollection quotaUseList = QueryServiceHelper.query((String)"gm_guaranteequotause", (String)"gmactualquota,gmadvancequota", (QFilter[])new QFilter[]{qidFilter});
                BigDecimal usedQuotaSum = BigDecimal.ZERO;
                BigDecimal advanceQuotaSum = BigDecimal.ZERO;
                for (DynamicObject quotaUseDO : quotaUseList) {
                    usedQuotaSum = usedQuotaSum.add(quotaUseDO.getBigDecimal("gmactualquota"));
                    advanceQuotaSum = advanceQuotaSum.add(quotaUseDO.getBigDecimal("gmadvancequota"));
                }
                entry.set("q_usedquota", (Object)usedQuotaSum);
                entry.set("q_advancequota", (Object)advanceQuotaSum);
                if (quotaAmt.add(beforeQuotaAmt).compareTo(GuaranteeQuotaHelper.getAvailableQuota((DynamicObject)entry)) <= 0) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_2", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
                break;
            }
            reGuaQuotaMap.put((Long)guaranteeQuota.getPkValue(), beforeQuotaAmt.add(quotaAmt));
        }
    }

    private void validateGuaOrgQuota(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection guaOrgCollection, DynamicObject currency) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaOrgCollection)) {
            return;
        }
        Long currencyId = currency.getLong("id");
        for (int i = 0; i < guaOrgCollection.size(); ++i) {
            DynamicObject guaOrgEntry = (DynamicObject)guaOrgCollection.get(i);
            DynamicObject guaranteeQuota = guaOrgEntry.getDynamicObject("a_guaranteequota");
            if (EmptyUtil.isEmpty((DynamicObject)guaranteeQuota)) continue;
            guaranteeQuota = TmcDataServiceHelper.loadSingle((Object)guaranteeQuota.getPkValue(), (String)"gm_guaranteequota", (String)GuaranteeQuotaHelper.QUOTA_PROP_NAME);
            String quotaEnable = guaranteeQuota.getString("enable");
            if (BaseEnableEnum.DISABLE.getValue().equals(quotaEnable)) continue;
            BigDecimal quotaAmt = GuaranteeQuotaHelper.getQuotaBigDecimal((DynamicObject)guaranteeQuota, (Long)currencyId, (BigDecimal)guaOrgEntry.getBigDecimal("a_gamount"));
            if (EmptyUtil.isEmpty((BigDecimal)quotaAmt)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230%1$s\u5e01\u79cd\u548c%2$s\u5e01\u79cd\u7684\u8f6c\u6362\u6c47\u7387\u3002", (String)"GuaranteeApplySubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]), currency.getString("name"), guaranteeQuota.getDynamicObject("currency").getString("name")));
                continue;
            }
            if (quotaAmt.compareTo(guaranteeQuota.getBigDecimal("availablequota")) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u62c5\u4fdd\u4eba\u5206\u5f55\u7b2c%s\u884c\u62c5\u4fdd\u989d\u5ea6\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GuaranteeApplySubmitValidator_1", (String)"tmc-gm-business", (Object[])new Object[]{i + 1}));
        }
    }
}

