/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.debt;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.gm.common.enums.DebtChangeTypeEnum;

public class DebtRegisterUnAuditValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Set debtRegisterIdSet = Arrays.stream(dataEntity).map(r -> r.getDataEntity().getPkValue().toString()).collect(Collectors.toSet());
        QFilter debtFilter = new QFilter("changetype", "=", (Object)DebtChangeTypeEnum.DEBT_RELEASE.getValue()).and(new QFilter("rootid", "in", debtRegisterIdSet));
        DynamicObjectCollection releaseDebtCol = QueryServiceHelper.query((String)"gm_debt_register", (String)"rootid", (QFilter[])new QFilter[]{debtFilter});
        Set releaseDebtIdSet = releaseDebtCol.stream().map(r -> Long.parseLong(r.getString("rootid"))).collect(Collectors.toSet());
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject debtRegister = extendedDataEntity.getDataEntity();
            if (!releaseDebtIdSet.contains(debtRegister.getLong("id"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u503a\u52a1\u5360\u7528\u5b58\u5728\u91ca\u653e\u7684\u8bb0\u5f55\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DebtRegisterUnAuditValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

