/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.letterofguaapply;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.LetterOfGuaApplyBizTypeEnum;

public class LetterOfGuaApplyUnauditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("biztype");
        sl.add("billno");
        sl.add("letterofguarantee");
        return sl;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List idList = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        QFilter glQFilter = new QFilter("sourcebillid", "in", idList);
        glQFilter.and(new QFilter("sourcebilltype", "=", (Object)"gm_letterofguaapply"));
        glQFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()));
        DynamicObjectCollection glDOs = QueryServiceHelper.query((String)"gm_letterofguarantee", (String)"id,sourcebillid", (QFilter[])glQFilter.toArray());
        HashSet<Long> hasLgIds = new HashSet<Long>(16);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)glDOs)) {
            for (DynamicObject lgDO : glDOs) {
                hasLgIds.add(lgDO.getLong("sourcebillid"));
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject apply;
            DynamicObject letterOfGuarantee;
            QFilter[] qFilters;
            DynamicObjectCollection applys;
            if (hasLgIds.contains(dataEntity.getBillPkId())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u5f00\u51fd\u767b\u8bb0\u5355\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u6e38\u5355\u636e\u518d\u505a\u53cd\u5ba1\u6838\u3002", (String)"LetterOfGuaApplyUnauditValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            String bizType = (String)dataEntity.getValue("biztype");
            String billNo = (String)dataEntity.getValue("billno");
            if (!LetterOfGuaApplyBizTypeEnum.isChangeLetter((String)bizType) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)(applys = QueryServiceHelper.query((String)"gm_letterofguaapply", (String)"billno", (QFilter[])(qFilters = new QFilter[]{new QFilter("letterofguarantee.id", "=", (letterOfGuarantee = (DynamicObject)dataEntity.getValue("letterofguarantee")).getPkValue())}), (String)"createtime desc", (int)1))) || (apply = (DynamicObject)applys.get(0)).getString("billno").equals(billNo)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6539\u51fd\u7533\u8bf7\u53ea\u80fd\u53cd\u5ba1\u6838\u6700\u65b0\u7684\u8bb0\u5f55\u3002", (String)"LetterOfGuaApplyUnauditValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

