/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.letterofguarantee;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LetterOfGuaranteeSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("isreissue");
        sl.add("applybillno");
        sl.add("applyorg");
        sl.add("applyreissueorg");
        sl.add("localreissuebank");
        sl.add("reissuebankfeerate");
        sl.add("issuebankfeerate");
        sl.add("hasunfrozenfund");
        sl.add("unfrozenfundbank");
        sl.add("startdate");
        sl.add("creditlimit");
        sl.add("expiredate");
        sl.add("entryentity");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject letter = dataEntity.getDataEntity();
            DynamicObjectCollection beneficiaryCollection = letter.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)beneficiaryCollection)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4fdd\u51fd\u53d7\u76ca\u4eba\u201d\u3002", (String)"LetterOfGuaranteeSubmitValidator_5", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (letter.getBoolean("isreissue")) {
                BigDecimal issueBankFeeRate;
                BigDecimal reissueBankFeeRate;
                Object applyReissueOrgId;
                String applyBillNo = letter.getString("applybillno");
                Object object = applyReissueOrgId = EmptyUtil.isEmpty((DynamicObject)letter.getDynamicObject("applyreissueorg")) ? null : letter.getDynamicObject("applyreissueorg").getPkValue();
                if (EmptyUtil.isEmpty((String)applyBillNo) && EmptyUtil.isNoEmpty((DynamicObject)letter.getDynamicObject("applyorg")) && letter.getDynamicObject("applyorg").getPkValue().equals(applyReissueOrgId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u51fd\u65b0\u589e\u4e14\u8f6c\u5f00\u65f6\uff0c\u7533\u8bf7\u8f6c\u5f00\u516c\u53f8\u53ca\u4fdd\u51fd\u7533\u8bf7\u516c\u53f8\u4e0d\u80fd\u76f8\u540c\u3002", (String)"LetterOfGuaranteeSubmitValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)(reissueBankFeeRate = letter.getBigDecimal("reissuebankfeerate"))) || BigDecimal.ZERO.compareTo(reissueBankFeeRate) >= 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u8f6c\u5f00\u65f6,\u5f00\u7acb\u94f6\u884c\u4fdd\u51fd\u8d39\u7387\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LetterOfGuaranteeSubmitValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)(issueBankFeeRate = letter.getBigDecimal("issuebankfeerate"))) || BigDecimal.ZERO.compareTo(issueBankFeeRate) >= 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u8f6c\u5f00\u65f6,\u8f6c\u5f00\u94f6\u884c\u4fdd\u51fd\u8d39\u7387\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LetterOfGuaranteeSubmitValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
            }
            if (letter.getBoolean("hasunfrozenfund") && EmptyUtil.isEmpty((DynamicObject)letter.getDynamicObject("unfrozenfundbank"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u89e3\u6d3b\u8d44\u91d1\u4e3a\u662f\u65f6,\u89e3\u6d3b\u8d44\u91d1\u5bf9\u5e94\u94f6\u884c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LetterOfGuaranteeSubmitValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            Date startDate = letter.getDate("startdate");
            Date expireDate = letter.getDate("expiredate");
            if (startDate == null || expireDate == null || !startDate.after(expireDate)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u51fd\u5230\u671f\u65e5\u5e94\u665a\u4e8e\u7b49\u4e8e\u5f00\u51fd\u5f00\u59cb\u65e5\u3002", (String)"LetterOfGuaranteeSubmitValidator_4", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

