/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.letterofguarantee;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.BizStatusEnum;

public class LetterOfGuaranteeUnClaimOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("bizstatus");
        selector.add("payeebillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity exEntity : dataEntity) {
            Object[] payBills;
            Object[] payBillIds;
            DynamicObject data = exEntity.getDataEntity();
            String billStatus = data.getString("billstatus");
            String bizStatus = data.getString("bizstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !BizStatusEnum.CLAIMED.getValue().equals(bizStatus)) {
                this.addMessage(exEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u5df2\u7d22\u8d54\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u7d22\u8d54\u3002", (String)"LetterOfGuaranteeUnClaimOpValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((Object[])(payBillIds = TmcBotpHelper.getTargetBillIds((String)"gm_letterofguarantee", (Object)data.getPkValue(), (String)"cas_paybill"))) || !EmptyUtil.isNoEmpty((Object[])(payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)payBillIds), new QFilter("billstatus", "!=", (Object)"G")})))) continue;
            String payBillNos = Arrays.stream(payBills).map(v -> v.getString("billno")).collect(Collectors.joining(","));
            this.addMessage(exEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u6709\u4e0b\u6e38\u4ed8\u6b3e\u5904\u7406\u5355\u636e[%s]\u3002", (String)"LetterOfGuaranteeClaimPayOpValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]), payBillNos));
        }
    }
}

