/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.letterofguarantee;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.gm.common.enums.BizStatusEnum;

public class LetterOfGuaranteeUnauditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("bizstatus");
        sl.add("creditlimit");
        return sl;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List idList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        QFilter rlQFilter = new QFilter("sourcebillid", "in", idList);
        rlQFilter.and(new QFilter("sourcebilltype", "=", (Object)"gm_letterofguarantee"));
        rlQFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()));
        DynamicObjectCollection rlDos = QueryServiceHelper.query((String)"gm_receiveletter", (String)"sourcebillid", (QFilter[])rlQFilter.toArray());
        Set hasIdSet = rlDos.stream().map(r -> r.getLong("sourcebillid")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject letter = dataEntity.getDataEntity();
            if (!BizStatusEnum.REGISTERED.getValue().equals(letter.getString("bizstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u767b\u8bb0\u7684\u5f00\u51fd\u5355\u624d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LetterOfGuaranteeUnauditValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            Object pkValue = letter.getPkValue();
            QFilter qFilter = new QFilter("letterofguarantee.id", "=", pkValue);
            if (TmcDataServiceHelper.exists((String)"gm_letterofguaapply", (QFilter[])new QFilter[]{qFilter})) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u6539\u51fd\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u505a\u53cd\u5ba1\u6838\u3002", (String)"LetterOfGuaranteeUnauditValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (!hasIdSet.contains(dataEntity.getBillPkId())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u975e\u6682\u5b58\u72b6\u6001\u7684\u6536\u51fd\u5355\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"LetterOfGuaranteeUnauditValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }
}

