/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.pledgebill;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.UseRangeEnum;

public class PledgeBillSubmitChangeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selectProperties = super.getSelector();
        selectProperties.add("usablerange");
        selectProperties.add("realrightpersonid");
        selectProperties.add("shareorgentry");
        selectProperties.add("shareorgentry.eorg");
        return selectProperties;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject pledgeBillFromDb;
            DynamicObject info = extendedDataEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(info.getString("billstatus"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"PledgeBillSubmitChangeValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(pledgeBillFromDb = TmcDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)"gm_pledgebill")))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u3002", (String)"PledgeBillSubmitChangeValidator_1", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            String usableRangeOrigin = pledgeBillFromDb.getString("usablerange");
            String usableRange = info.getString("usablerange");
            if ((UseRangeEnum.SPECIFY_SHARE.getValue().equals(usableRangeOrigin) || UseRangeEnum.SHARE.getValue().equals(usableRangeOrigin)) && UseRangeEnum.ORG.getValue().equals(usableRange)) {
                if (this.checkContract(info, info.getLong("realrightpersonid"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u8d28\u62bc\u7269\u5df2\u5728\u62c5\u4fdd\u5408\u540c\u4e2d\u88ab\u5176\u4ed6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PledgeBillSubmitChangeValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
                if (this.checkBackContract(info, info.getLong("realrightpersonid"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u8d28\u62bc\u7269\u5df2\u5728\u62c5\u4fdd\u5408\u540c\u53cd\u62c5\u4fdd\u4e2d\u88ab\u5176\u4ed6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PledgeBillSubmitChangeValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
            }
            DynamicObjectCollection shareOrg = info.getDynamicObjectCollection("shareorgentry");
            if (UseRangeEnum.SHARE.getValue().equals(usableRangeOrigin) && UseRangeEnum.SPECIFY_SHARE.getValue().equals(usableRange)) {
                if (this.checkContractExt(info, shareOrg)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u8d28\u62bc\u7269\u5df2\u5728\u62c5\u4fdd\u5408\u540c\u4e2d\u88ab\u5176\u4ed6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PledgeBillSubmitChangeValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
                if (this.checkBackContractExt(info, shareOrg)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u8d28\u62bc\u7269\u5df2\u5728\u62c5\u4fdd\u5408\u540c\u53cd\u62c5\u4fdd\u4e2d\u88ab\u5176\u4ed6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PledgeBillSubmitChangeValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
                }
            }
            DynamicObjectCollection shareOrgFromDb = pledgeBillFromDb.getDynamicObjectCollection("shareorgentry");
            if (!UseRangeEnum.SPECIFY_SHARE.getValue().equals(usableRangeOrigin) || !UseRangeEnum.SPECIFY_SHARE.getValue().equals(usableRange) || !this.isDelete(shareOrgFromDb, shareOrg)) continue;
            if (this.checkContractExt(info, shareOrg)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u8d28\u62bc\u7269\u5df2\u5728\u62c5\u4fdd\u5408\u540c\u4e2d\u88ab\u5176\u4ed6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PledgeBillSubmitChangeValidator_2", (String)"tmc-gm-business", (Object[])new Object[0]));
            }
            if (!this.checkBackContractExt(info, shareOrg)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u8d28\u62bc\u7269\u5df2\u5728\u62c5\u4fdd\u5408\u540c\u53cd\u62c5\u4fdd\u4e2d\u88ab\u5176\u4ed6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PledgeBillSubmitChangeValidator_3", (String)"tmc-gm-business", (Object[])new Object[0]));
        }
    }

    private boolean checkContract(DynamicObject info, Long realRightPersonId) {
        QFilter pFilter;
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter mFilter = new QFilter("morentity.m_pleg.id", "=", info.getPkValue());
        QFilter mpFilter = mFilter.or(pFilter = new QFilter("pletgageentity.p_pleg.id", "=", info.getPkValue()));
        DynamicObjectCollection contractBillList = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,billno,entry_guaranteeorg.a_guaranteeorg", (QFilter[])mpFilter.and(auditFilter).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractBillList)) {
            return false;
        }
        for (DynamicObject contractBill : contractBillList) {
            Long guaranteeOrg = contractBill.getLong("entry_guaranteeorg.a_guaranteeorg");
            if (!EmptyUtil.isNoEmpty((Long)guaranteeOrg) || guaranteeOrg.equals(realRightPersonId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkBackContract(DynamicObject info, Long realRightPersonId) {
        QFilter cpFilter;
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter cmFilter = new QFilter("cmorentity.cm_pleg.id", "=", info.getPkValue());
        QFilter cmpFilter = cmFilter.or(cpFilter = new QFilter("cpletgageentity.cp_pleg.id", "=", info.getPkValue()));
        DynamicObjectCollection contractBillList = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,billno,entry_guaranteedorg.b_guaranteedorg", (QFilter[])cmpFilter.and(auditFilter).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractBillList)) {
            return false;
        }
        for (DynamicObject contractBill : contractBillList) {
            Long guaranteedOrg = contractBill.getLong("entry_guaranteedorg.b_guaranteedorg");
            if (!EmptyUtil.isNoEmpty((Long)guaranteedOrg) || guaranteedOrg.equals(realRightPersonId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkContractExt(DynamicObject info, DynamicObjectCollection shareOrg) {
        QFilter pFilter;
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter mFilter = new QFilter("morentity.m_pleg.id", "=", info.getPkValue());
        QFilter mpFilter = mFilter.or(pFilter = new QFilter("pletgageentity.p_pleg.id", "=", info.getPkValue()));
        DynamicObjectCollection contractBillList = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,billno,entry_guaranteeorg.a_guaranteeorg", (QFilter[])mpFilter.and(auditFilter).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractBillList)) {
            return false;
        }
        List shareOrgIdList = shareOrg.stream().map(o -> (Long)o.getDynamicObject("eorg").getPkValue()).collect(Collectors.toList());
        for (DynamicObject contractBill : contractBillList) {
            Long guaranteeOrg = contractBill.getLong("entry_guaranteeorg.a_guaranteeorg");
            if (!EmptyUtil.isNoEmpty((Long)guaranteeOrg) || shareOrgIdList.contains(guaranteeOrg)) continue;
            return true;
        }
        return false;
    }

    private boolean checkBackContractExt(DynamicObject info, DynamicObjectCollection shareOrg) {
        QFilter cpFilter;
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter cmFilter = new QFilter("cmorentity.cm_pleg.id", "=", info.getPkValue());
        QFilter cmpFilter = cmFilter.or(cpFilter = new QFilter("cpletgageentity.cp_pleg.id", "=", info.getPkValue()));
        DynamicObjectCollection contractBillList = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)"id,billno,entry_guaranteedorg.b_guaranteedorg", (QFilter[])cmpFilter.and(auditFilter).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)contractBillList)) {
            return false;
        }
        List shareOrgIdList = shareOrg.stream().map(o -> (Long)o.getDynamicObject("eorg").getPkValue()).collect(Collectors.toList());
        for (DynamicObject contractBill : contractBillList) {
            Long guaranteedOrg = contractBill.getLong("entry_guaranteedorg.b_guaranteedorg");
            if (!EmptyUtil.isNoEmpty((Long)guaranteedOrg) || shareOrgIdList.contains(guaranteedOrg)) continue;
            return true;
        }
        return false;
    }

    private boolean isDelete(DynamicObjectCollection shareOrgFromDb, DynamicObjectCollection shareOrg) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)shareOrgFromDb)) {
            return false;
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)shareOrg)) {
            return true;
        }
        List dbList = shareOrgFromDb.stream().map(o -> o.getDynamicObject("eorg").getPkValue()).collect(Collectors.toList());
        List list = shareOrg.stream().map(o -> o.getDynamicObject("eorg").getPkValue()).collect(Collectors.toList());
        for (Object shareDb : dbList) {
            if (list.contains(shareDb)) continue;
            return true;
        }
        return false;
    }
}

