/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.business.validate.receiveletter;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.BizStatusEnum;

public class ReceiveLetterClaimRecOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("bizstatus");
        selector.add("recbillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity exEntity : dataEntity) {
            DynamicObject data = exEntity.getDataEntity();
            String billStatus = data.getString("billstatus");
            String bizStatus = data.getString("bizstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !BizStatusEnum.CLAIMED.getValue().equals(bizStatus)) {
                this.addMessage(exEntity, ResManager.loadResFormat((String)"\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u5df2\u7d22\u8d54\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u7d22\u8d54\u6536\u6b3e\u3002", (String)"ReceiveLetterClaimRecOpValidator_0", (String)"tmc-gm-business", (Object[])new Object[0]));
                return;
            }
            DynamicObject recbill = TmcBotpHelper.getTargetBill((String)"gm_receiveletter", (Object)data.getPkValue(), (String)"cas_recbill");
            String recbillno = data.getString("recbillno");
            if (!EmptyUtil.isNoEmpty((DynamicObject)recbill)) continue;
            this.addMessage(exEntity, ResManager.loadResFormat((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u6709\u4e0b\u6e38\u6536\u6b3e\u5904\u7406\u5355\u636e[%s]\u3002", (String)"ReceiveLetterClaimRecOpValidator_1", (String)"tmc-gm-business", (Object[])new Object[]{recbillno}));
        }
    }
}

