/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseReturnBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;

public class DebtRegisterUseHelper {
    private static String[] gcProps = new String[]{"gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gsrcbillid", "gsrcbilltype", "gsrcbillbizamount", "gexchrate", "gdebtamount", "gdebtbalance", "return_entry", "return_entry.e_returnamount", "return_entry.e_returnbillid", "return_entry.e_returnbilltype"};

    public static void saveGuaranteeUse(List<GuaranteeUseBean> gUseBeanList) {
        ArrayList<DynamicObject> gUseDOList = new ArrayList<DynamicObject>(gUseBeanList.size());
        ArrayList<Long> srcBillIds = new ArrayList<Long>(gUseBeanList.size());
        for (GuaranteeUseBean gUse : gUseBeanList) {
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"gm_guaranteeuse");
            newDO.set("gcontract", (Object)gUse.getgContractId());
            newDO.set("gratio", (Object)gUse.getgRatio());
            newDO.set("gcomment", (Object)gUse.getComment());
            newDO.set("gamount", (Object)gUse.getgAmount());
            newDO.set("gexchrate", (Object)gUse.getExchrate());
            newDO.set("gsrcbillbizamount", (Object)gUse.getBizAmount());
            BigDecimal debtAmt = gUse.getBizAmount().multiply(gUse.getgRatio()).divide(Constants.ONE_HUNDRED);
            newDO.set("gdebtamount", (Object)debtAmt);
            newDO.set("gdebtbalance", (Object)debtAmt);
            newDO.set("gdebtorg", (Object)gUse.getDebtOrgId());
            newDO.set("gdebtorgtext", (Object)gUse.getDebtOrgText());
            newDO.set("gdebtcurrency", (Object)gUse.getDebtCurrencyId());
            newDO.set("gdebtstartdate", (Object)gUse.getDebtStartDate());
            newDO.set("gdebtenddate", (Object)gUse.getDebtEndDate());
            newDO.set("gcparty", (Object)gUse.getCparty());
            newDO.set("gsrcbillid", (Object)gUse.getSrcBillId());
            newDO.set("gsrcbillno", (Object)gUse.getSrcBillNo());
            newDO.set("gsrcbilltype", (Object)gUse.getSrcBillType());
            gUseDOList.add(newDO);
            srcBillIds.add(gUse.getSrcBillId());
        }
        if (EmptyUtil.isNoEmpty(srcBillIds)) {
            DeleteServiceHelper.delete((String)"gm_guaranteeuse", (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "in", srcBillIds)});
        }
        if (EmptyUtil.isNoEmpty(gUseDOList)) {
            SaveServiceHelper.save((DynamicObject[])gUseDOList.toArray(new DynamicObject[0]));
        }
    }

    public static void confirmGuaranteeUse(List<Long> bizIds) {
        QFilter idFilter = new QFilter("gsrcbillid", "in", bizIds);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcontract", "billstatus"), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        HashSet<Long> contractIds = new HashSet<Long>(gcUseBills.length);
        for (Object gcUseBill : gcUseBills) {
            gcUseBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            contractIds.add(gcUseBill.getDynamicObject("gcontract").getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
        DebtRegisterUseHelper.updateGuaranteeContract(contractIds);
    }

    private static void updateGuaranteeContract(Set<Long> contractIds) {
        List useBills;
        Long contractId;
        QFilter idFilter = new QFilter("id", "in", contractIds);
        DynamicObject[] gContracts = TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)"bizstatus", (QFilter[])new QFilter[]{idFilter});
        QFilter gcUseFilter = new QFilter(String.join((CharSequence)".", "gcontract", "id"), "in", contractIds);
        gcUseFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcontract", "gdebtbalance", "gexchrate"), (QFilter[])new QFilter[]{gcUseFilter});
        HashMap<Long, List> contractIdToUseBills = new HashMap<Long, List>(16);
        for (DynamicObject gcUseBill : gcUseBills) {
            contractId = gcUseBill.getDynamicObject("gcontract").getLong("id");
            useBills = contractIdToUseBills.computeIfAbsent(contractId, k -> new ArrayList(10));
            useBills.add(gcUseBill);
        }
        for (DynamicObject contract : gContracts) {
            contractId = contract.getLong("id");
            useBills = (List)contractIdToUseBills.get(contractId);
            if (GuaConBizStatusEnum.CLOSED.getValue().equals(contract.getString("bizstatus")) || GuaConBizStatusEnum.CHANGING.getValue().equals(contract.getString("bizstatus"))) continue;
            if (!EmptyUtil.isEmpty((Collection)useBills) && !GuaConBizStatusEnum.DOING.getValue().equals(contract.getString("bizstatus"))) {
                contract.set("bizstatus", (Object)GuaConBizStatusEnum.DOING.getValue());
            }
            if (!EmptyUtil.isEmpty((Collection)useBills)) continue;
            contract.set("bizstatus", (Object)GuaConBizStatusEnum.REGISTED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])gContracts);
    }

    public static void returnGuaranteeUse(List<GuaranteeUseReturnBean> returns) {
        List gcUseList;
        if (EmptyUtil.isEmpty(returns)) {
            return;
        }
        ArrayList<Long> srcIdSet = new ArrayList<Long>(returns.size());
        for (GuaranteeUseReturnBean ret : returns) {
            srcIdSet.add(ret.getBizBillId());
        }
        QFilter idFilter = new QFilter("gsrcbillid", "in", srcIdSet);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", gcProps), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        HashMap<Long, ArrayList<Object>> idToDOMap = new HashMap<Long, ArrayList<Object>>(16);
        for (Object gcUse : gcUseBills) {
            Long srcBizBillId = gcUse.getLong("gsrcbillid");
            gcUseList = (ArrayList<Object>)idToDOMap.get(srcBizBillId);
            if (gcUseList == null) {
                gcUseList = new ArrayList<Object>();
                idToDOMap.put(srcBizBillId, (ArrayList<Object>)gcUseList);
            }
            gcUseList.add(gcUse);
        }
        for (GuaranteeUseReturnBean ret : returns) {
            Long bizId = ret.getBizBillId();
            String billType = ret.getReturnBillType();
            Long returnBillId = ret.getReturnBillId();
            gcUseList = (List)idToDOMap.get(bizId);
            if (gcUseList == null) continue;
            for (DynamicObject gcUse : gcUseList) {
                DynamicObjectCollection returnDC = gcUse.getDynamicObjectCollection("return_entry");
                Iterator retEntryIt = returnDC.iterator();
                while (retEntryIt.hasNext()) {
                    if (!returnBillId.equals(((DynamicObject)retEntryIt.next()).getLong("e_returnbillid"))) continue;
                    retEntryIt.remove();
                }
                DynamicObject newRet = returnDC.addNew();
                newRet.set("e_returnamount", (Object)ret.getReturnAmount());
                newRet.set("e_returnbillid", (Object)returnBillId);
                newRet.set("e_returnbilltype", (Object)billType);
                BigDecimal totalRet = BigDecimal.ZERO;
                for (DynamicObject retEntry : returnDC) {
                    totalRet = totalRet.add(retEntry.getBigDecimal("e_returnamount"));
                }
                BigDecimal debtAmt = gcUse.getBigDecimal("gdebtamount");
                BigDecimal balanceDebt = debtAmt.subtract(totalRet);
                gcUse.set("gdebtbalance", (Object)(balanceDebt.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : balanceDebt));
            }
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
    }

    public static void cancelGuaranteeUse(List<Long> bizIdSet) {
        QFilter idFilter = new QFilter("gsrcbillid", "in", bizIdSet);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcontract", "billstatus"), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        HashSet<Long> contractIds = new HashSet<Long>(gcUseBills.length);
        for (Object gcUseBill : gcUseBills) {
            gcUseBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            contractIds.add(gcUseBill.getDynamicObject("gcontract").getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
        DebtRegisterUseHelper.updateGuaranteeContract(contractIds);
    }

    public static void cancelReturnGuaranteeUse(List<GuaranteeUseReturnBean> returns) {
        ArrayList<Long> returnBillIdSet = new ArrayList<Long>(returns.size());
        for (GuaranteeUseReturnBean ret : returns) {
            returnBillIdSet.add(ret.getReturnBillId());
        }
        QFilter returnFilter = new QFilter("return_entry.e_returnbillid", "in", returnBillIdSet);
        Object[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", gcProps), (QFilter[])new QFilter[]{returnFilter});
        if (EmptyUtil.isEmpty((Object[])gcUseBills)) {
            return;
        }
        for (Object gcUse : gcUseBills) {
            DynamicObjectCollection returnDC = gcUse.getDynamicObjectCollection("return_entry");
            Iterator iter = returnDC.iterator();
            while (iter.hasNext()) {
                if (!returnBillIdSet.contains(((DynamicObject)iter.next()).getLong("e_returnbillid"))) continue;
                iter.remove();
            }
            BigDecimal totalRet = BigDecimal.ZERO;
            for (DynamicObject retEntry : returnDC) {
                totalRet = totalRet.add(retEntry.getBigDecimal("e_returnamount"));
            }
            BigDecimal debtAmt = gcUse.getBigDecimal("gdebtamount");
            BigDecimal balanceDebt = debtAmt.subtract(totalRet);
            gcUse.set("gdebtbalance", (Object)(balanceDebt.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : balanceDebt));
        }
        SaveServiceHelper.save((DynamicObject[])gcUseBills);
    }

    public static void deleteGuaranteeUse(List<Long> bizIdSet) {
        if (EmptyUtil.isEmpty(bizIdSet)) {
            return;
        }
        QFilter idFilter = new QFilter("gsrcbillid", "in", bizIdSet);
        DeleteServiceHelper.delete((String)"gm_guaranteeuse", (QFilter[])new QFilter[]{idFilter});
    }
}

