/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.common.helper;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.GuaranteeTypeEnum;

public class GuaranteeHelper {
    public static Long getCurrencyByOrg(long orgId) {
        DynamicObject standardCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)orgId);
        if (EmptyUtil.isNoEmpty((DynamicObject)standardCurrency)) {
            return standardCurrency.getLong("id");
        }
        Long bookInfoByOrg = GuaranteeHelper.getBookInfoCurByOrg(orgId);
        if (EmptyUtil.isEmpty((Long)bookInfoByOrg)) {
            return GuaranteeHelper.getAccountOrg(orgId);
        }
        return bookInfoByOrg;
    }

    public static Long getBookInfoCurByOrg(long orgId) {
        QFilter orgFilter = new QFilter("ORG.id", "=", (Object)orgId);
        QFilter orgBook = new QFilter("bookstype.accounttype", "=", (Object)"1");
        DynamicObject accountBooksInfo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,basecurrency.id", (QFilter[])new QFilter[]{orgFilter, orgBook});
        if (!EmptyUtil.isEmpty((DynamicObject)accountBooksInfo)) {
            return accountBooksInfo.getLong("basecurrency.id");
        }
        return null;
    }

    public static Long getAccountOrg(long orgId) {
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId);
        if (null == companyByOrg || companyByOrg.size() == 0) {
            return null;
        }
        Map accountOrgMap = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)companyByOrg.get("id")));
        if (null == accountOrgMap || accountOrgMap.size() == 0) {
            return null;
        }
        return (Long)accountOrgMap.get("baseCurrencyID");
    }

    private static DynamicObject getFieldRelation(DynamicObject guaranteeContract) {
        if (EmptyUtil.isEmpty((DynamicObject)guaranteeContract) || !"gm_guaranteecontract".equals(guaranteeContract.getDynamicObjectType().getName())) {
            return null;
        }
        QFilter filter = new QFilter("srcentity.number", "=", (Object)"gm_guaranteecontract");
        filter.and("tagentity.number", "=", (Object)"gm_guaranteeapply");
        filter.and("biztype", "=", (Object)"B");
        return TmcDataServiceHelper.loadSingleFromCache((String)"fbd_fieldrelation", (String)"number,ishasentry,entryentity,entryentity.srcfield,entryentity.targetfield", (QFilter[])filter.toArray());
    }

    public static void copyValue(DynamicObject fromObj, DynamicObject toObj, List<String> needCopyHeadField, List<String> entryNames) {
        DataEntityPropertyCollection fromProperties = fromObj.getDataEntityType().getProperties();
        for (IDataEntityProperty property : fromProperties) {
            String prop = property.getName();
            DataEntityPropertyCollection properties = toObj.getDataEntityType().getProperties();
            if (!properties.containsKey((Object)prop) || !needCopyHeadField.contains(prop)) continue;
            toObj.set(prop, fromObj.get(prop));
        }
        if (entryNames != null) {
            for (String entryName : entryNames) {
                boolean isMulGuarantee = "entry_guaranteeorg".equals(entryName) || "entry_guaranteedorg".equals(entryName);
                toObj.getDynamicObjectCollection(entryName).clear();
                if (!fromObj.containsProperty(entryName)) continue;
                for (DynamicObject entry_a : fromObj.getDynamicObjectCollection(entryName)) {
                    DynamicObject entry_l = toObj.getDynamicObjectCollection(entryName).addNew();
                    for (IDataEntityProperty property : entry_a.getDataEntityType().getProperties()) {
                        if (!entry_l.getDataEntityType().getProperties().containsKey((Object)property.getName())) continue;
                        entry_l.set(property, entry_a.get(property));
                    }
                    entry_l.set("id", entry_a.get("id"));
                    if (!isMulGuarantee) continue;
                    entry_l.set("id", (Object)DBServiceHelper.genGlobalLongId());
                }
            }
        }
    }

    public static boolean checkBaseIdFromName(DynamicObject info, String baseTypeProp, String baseNameProp, String baseIdProp) {
        String baseName = info.getString(baseNameProp).trim();
        if (EmptyUtil.isNoEmpty((Long)info.getLong(baseIdProp)) || EmptyUtil.isEmpty((String)baseName)) {
            return true;
        }
        String baseType = info.getString(baseTypeProp);
        String formId = GuaranteeTypeEnum.getFormId(baseType);
        if (EmptyUtil.isEmpty((String)formId)) {
            return true;
        }
        DynamicObject baseData = TmcDataServiceHelper.loadSingleFromCache((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)baseName)});
        if (EmptyUtil.isNoEmpty((DynamicObject)baseData)) {
            info.set(baseIdProp, baseData.getPkValue());
            return true;
        }
        return false;
    }

    public static Set<Long> getContractUseIds(List<Long> contractIds) {
        HashSet<Long> contractUseIds = new HashSet<Long>(contractIds.size());
        QFilter gcUseFilter = new QFilter("gcontract.id", "in", contractIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"getContractUseIds", (String)"gm_guaranteeuse", (String)"gcontract", (QFilter[])new QFilter[]{gcUseFilter}, null).groupBy(new String[]{"gcontract"}).finish();
        ds.forEach(d -> contractUseIds.add(d.getLong("gcontract")));
        return contractUseIds;
    }
}

