/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.model.surety.SuretyDebtEntryStatusInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.enums.BizStatusEnum;

public class LetterOfGuaranteeHelper {
    public static final List<String> NOTNEED_PERMISSIONOP = Arrays.asList("refresh", "modify", "new", "viewflowchart", "trackup", "trackdown", "printpreview", "printsetting");
    public static final List<String> CHANGEFIELDS = Arrays.asList("beneficiarytype", "beneficiary", "textbeneficiary", "currency", "contractno", "contractamount", "amount", "startdate", "expiredate", "guaranteeterm", "comprehfeerate", "estimatedtotalfee", "feepaymentmethod", "isrevokableinadv", "hasunfrozenfund", "unfrozenfundbank");

    public static void updateCancelRelFields(DynamicObject[] lgDOs, String op) {
        Long opUserId = RequestContext.get().getCurrUserId();
        Date opTime = new Date();
        String bizStatus = BizStatusEnum.CANCELLED.getValue();
        Long cancelledById = null;
        Date cancelledTime = null;
        if ("cancel".equals(op)) {
            cancelledById = opUserId;
            cancelledTime = opTime;
        } else {
            bizStatus = BizStatusEnum.REGISTERED.getValue();
        }
        for (DynamicObject lgDO : lgDOs) {
            lgDO.set("bizstatus", (Object)bizStatus);
            lgDO.set("cancelledby", (Object)cancelledById);
            lgDO.set("cancelledtime", (Object)cancelledTime);
            lgDO.set("modifier", (Object)opUserId);
            lgDO.set("modifytime", (Object)opTime);
            LetterOfGuaranteeHelper.updateSuretyStatus(lgDO, bizStatus);
        }
    }

    public static void returnCreditlimit(DynamicObject lgDO) {
        DynamicObject clDO = lgDO.getDynamicObject("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)clDO)) {
            CreditLimitServiceHelper.returnCreditLimit((DynamicObject)lgDO, (DynamicObject)lgDO, (boolean)false, (BigDecimal)lgDO.getBigDecimal("amount"), (Long)lgDO.getLong("id"), (boolean)true);
        }
    }

    public static void cancelReturnCreditlimit(DynamicObject lgDO) {
        DynamicObject clDO = lgDO.getDynamicObject("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)clDO)) {
            CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)lgDO, (DynamicObject)lgDO, (boolean)false, (BigDecimal)lgDO.getBigDecimal("amount"), (Long)lgDO.getLong("id"));
        }
    }

    public static void preUseCreditLimit(DynamicObject[] dataEntities) {
        for (DynamicObject lgDO : dataEntities) {
            boolean isPreUse = BillStatusEnum.SAVE.getValue().equals(lgDO.getString("billstatus"));
            Long applyId = lgDO.getLong("sourcebillid");
            String srcBillType = lgDO.getString("sourcebilltype");
            DynamicObject applyDO = null;
            if (EmptyUtil.isNoEmpty((Long)applyId) && "gm_letterofguaapply".equals(srcBillType)) {
                QFilter applyQFilter = new QFilter("id", "=", (Object)applyId);
                applyDO = TmcDataServiceHelper.loadSingle((String)"gm_letterofguaapply", (String)"id, billno, creditlimit, currency,amount", (QFilter[])applyQFilter.toArray());
            }
            if (applyDO != null && EmptyUtil.isNoEmpty((DynamicObject)applyDO.getDynamicObject("creditlimit")) && !LetterOfGuaranteeHelper.checkBillHasReturn(lgDO.getLong("id"), applyDO.getDynamicObject("creditlimit").getLong("id"))) {
                CreditLimitServiceHelper.returnCreditLimit((DynamicObject)lgDO, (DynamicObject)applyDO, (boolean)true, (BigDecimal)applyDO.getBigDecimal("amount"), (Long)lgDO.getLong("id"), (boolean)true);
            }
            LetterOfGuaranteeHelper.tryCreateCreditUse(lgDO, applyDO);
            DynamicObjectCollection lgFromDbDO = QueryServiceHelper.query((String)"gm_letterofguarantee", (String)"creditlimit", (QFilter[])new QFilter[]{new QFilter("id", "=", lgDO.getPkValue())});
            Long origClDO = null;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)lgFromDbDO)) {
                origClDO = ((DynamicObject)lgFromDbDO.get(0)).getLong("creditlimit");
            }
            DynamicObject clDO = lgDO.getDynamicObject("creditlimit");
            if (EmptyUtil.isEmpty(origClDO) && clDO != null) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)lgDO, null, (boolean)isPreUse);
                continue;
            }
            if (EmptyUtil.isNoEmpty((Long)origClDO) && clDO == null) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)lgDO, null, (boolean)isPreUse);
                continue;
            }
            if (!EmptyUtil.isNoEmpty((Long)origClDO) || clDO == null) continue;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)lgDO, null, (boolean)isPreUse);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)lgDO, null, (boolean)isPreUse);
        }
    }

    private static boolean checkBillHasReturn(Long returnId, Long creditLimitId) {
        QFilter returnIdFilter = new QFilter("returnentry.e_returnid", "=", (Object)returnId);
        QFilter creditLimitFilter = new QFilter("creditlimit", "=", (Object)creditLimitId);
        return TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{creditLimitFilter, returnIdFilter});
    }

    public static void useCreditLimit(DynamicObject[] dataEntities) {
        for (DynamicObject lgDO : dataEntities) {
            DynamicObject clDO = lgDO.getDynamicObject("creditlimit");
            Long applyId = lgDO.getLong("sourcebillid");
            DynamicObject applyDO = null;
            if (EmptyUtil.isNoEmpty((Long)applyId)) {
                QFilter applyQFilter = new QFilter("id", "=", (Object)applyId);
                applyDO = TmcDataServiceHelper.loadSingle((String)"gm_letterofguaapply", (String)"id, billno, creditlimit, currency,amount", (QFilter[])applyQFilter.toArray());
            }
            DynamicObjectCollection lgFromDbDO = QueryServiceHelper.query((String)"gm_letterofguarantee", (String)"creditlimit", (QFilter[])new QFilter[]{new QFilter("id", "=", lgDO.getPkValue())});
            Long origClDO = null;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)lgFromDbDO)) {
                origClDO = ((DynamicObject)lgFromDbDO.get(0)).getLong("creditlimit");
            }
            if (EmptyUtil.isEmpty(origClDO) && clDO == null) {
                if (applyDO == null || !EmptyUtil.isNoEmpty((DynamicObject)applyDO.getDynamicObject("creditlimit")) || LetterOfGuaranteeHelper.checkBillHasReturn(lgDO.getLong("id"), applyDO.getDynamicObject("creditlimit").getLong("id"))) continue;
                CreditLimitServiceHelper.returnCreditLimit((DynamicObject)lgDO, (DynamicObject)applyDO, (boolean)true, (BigDecimal)applyDO.getBigDecimal("amount"), (Long)lgDO.getLong("id"));
                continue;
            }
            if (EmptyUtil.isEmpty(origClDO) && clDO != null) {
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)lgDO, (DynamicObject)applyDO, (boolean)false);
                continue;
            }
            if (EmptyUtil.isNoEmpty((Long)origClDO) && clDO == null) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)lgDO, null, (boolean)true);
                continue;
            }
            if (!EmptyUtil.isNoEmpty((Long)origClDO) || clDO == null) continue;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)lgDO, null, (boolean)true);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)lgDO, null, (boolean)false);
        }
    }

    public static void change2PreUseCreditLimt(DynamicObject[] dataEntities) {
        for (DynamicObject lgDO : dataEntities) {
            DynamicObject clDO = lgDO.getDynamicObject("creditlimit");
            if (clDO == null) continue;
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)lgDO, null, (boolean)false);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)lgDO, null, (boolean)true);
        }
    }

    private static void tryCreateCreditUse(DynamicObject lgDO, DynamicObject applyDO) {
        DynamicObject clDO = lgDO.getDynamicObject("creditlimit");
        if (clDO == null) {
            return;
        }
        QFilter filter = new QFilter("sourcebillid", "=", (Object)lgDO.getLong("id"));
        DynamicObjectCollection creditUseBill = QueryServiceHelper.query((String)"cfm_credituse", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUseBill)) {
            return;
        }
        if (applyDO == null) {
            CreditLimitUseBean useBean = new CreditLimitUseBean();
            useBean.setPkId(Long.valueOf(lgDO.getLong("id")));
            useBean.setEntityName("gm_letterofguarantee");
            useBean.setOrgId(Long.valueOf(lgDO.getDynamicObject("applyorg").getLong("id")));
            useBean.setFinOrgId(Long.valueOf(lgDO.getDynamicObject("finorginfo").getLong("id")));
            useBean.setCurrencyId(Long.valueOf(lgDO.getDynamicObject("currency").getLong("id")));
            DynamicObject finProduct = lgDO.getDynamicObject("guaranteevariety");
            DynamicObject finVar = TmcDataServiceHelper.loadSingle((Object)finProduct.getPkValue(), (String)"cfm_financingvarieties");
            DynamicObject creditType = finVar.getDynamicObject("credittype");
            if (creditType == null) {
                creditType = TmcDataServiceHelper.loadSingle((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("iscomprehensive", "=", (Object)"1")});
            }
            Long creditTypeId = (Long)creditType.getPkValue();
            useBean.setCreditTypeId(creditTypeId);
            useBean.setCreditVariety(finProduct.getString("name"));
            useBean.setBizAmt(lgDO.getBigDecimal("amount"));
            useBean.setCreditRatio(Constants.ONE_HUNDRED);
            useBean.setMaxAmt(lgDO.getBigDecimal("amount"));
            useBean.setStartDate(lgDO.getDate("startdate"));
            useBean.setEndDate(lgDO.getDate("expiredate"));
            useBean.setCreditLimitNo(clDO.getString("number"));
            useBean.setSourceBillId(Long.valueOf(0L));
            useBean.setSourceType("");
            useBean.setPreOccupy(Boolean.TRUE);
            CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
            return;
        }
        DynamicObject applyClDO = applyDO.getDynamicObject("creditlimit");
        if (applyClDO == null) {
            return;
        }
        Long applyId = applyDO.getLong("id");
        Long clId = applyClDO.getLong("id");
        QFilter clQFilter = new QFilter("sourcebillid", "=", (Object)applyId);
        clQFilter.and("creditlimit.id", "=", (Object)clId);
        DynamicObjectCollection applyUseBills = QueryServiceHelper.query((String)"cfm_credituse", (String)"id,billno", (QFilter[])clQFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)applyUseBills)) {
            return;
        }
        DynamicObject applyUseBill = TmcDataServiceHelper.loadSingle((Object)((DynamicObject)applyUseBills.get(0)).getLong("id"), (String)"cfm_credituse");
        DynamicObject cl = applyUseBill.getDynamicObject("creditlimit");
        if (clDO.getLong("id") != cl.getLong("id")) {
            return;
        }
        DynamicObject newUseBill = TmcDataServiceHelper.clone((DynamicObject)applyUseBill);
        newUseBill.set("realamt", newUseBill.get("preamount"));
        newUseBill.set("returnamt", (Object)BigDecimal.ZERO);
        newUseBill.set("amount", (Object)BigDecimal.ZERO);
        newUseBill.set("sourcetype", (Object)"gm_letterofguarantee");
        newUseBill.set("sourcebillno", lgDO.get("billno"));
        newUseBill.set("sourcename", lgDO.getDataEntityType().getDisplayName() == null ? null : lgDO.getDataEntityType().getDisplayName().getLocaleValue());
        newUseBill.set("sourcebillid", (Object)lgDO.getLong("id"));
        newUseBill.set("sourcebillentryid", (Object)lgDO.getLong("id"));
        newUseBill.set("billstatus", (Object)"A");
        newUseBill.set("returnentry", null);
        newUseBill.set("createtime", (Object)new Date());
        newUseBill.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newUseBill});
    }

    public static void saveGuaranteeUse(DynamicObject[] dataEntities) {
        ArrayList<GuaranteeUseBean> gUseList = new ArrayList<GuaranteeUseBean>(dataEntities.length);
        ArrayList<Long> deleteBizIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject srcBill : dataEntities) {
            Long srcBillId = srcBill.getLong("id");
            DynamicObjectCollection gContractDC = srcBill.getDynamicObjectCollection("entry_gcontract");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)gContractDC)) {
                deleteBizIds.add(srcBillId);
                continue;
            }
            String srcBillType = srcBill.getDataEntityType().getName();
            String billNo = srcBill.getString("billno");
            DynamicObject cParty = srcBill.getDynamicObject("finorginfo");
            DynamicObject bizOrg = srcBill.getDynamicObject("applyorg");
            DynamicObject bizCurrency = srcBill.getDynamicObject("currency");
            Long debtOrgId = bizOrg == null ? 0L : bizOrg.getLong("id");
            String debtOrgText = bizOrg == null ? "" : bizOrg.getString("name");
            Long debtCcyId = bizCurrency == null ? 0L : bizCurrency.getLong("id");
            String cPartName = cParty == null ? "" : cParty.getString("name");
            Date startDate = srcBill.getDate("startdate");
            Date endDate = srcBill.getDate("expiredate");
            BigDecimal bizAmount = srcBill.getBigDecimal("amount");
            for (DynamicObject gc : gContractDC) {
                GuaranteeUseBean gUse = new GuaranteeUseBean();
                gUse.setSrcBillId(srcBillId);
                gUse.setSrcBillType(srcBillType);
                gUse.setSrcBillNo(billNo);
                gUse.setgContractId(Long.valueOf(gc.getDynamicObject("gcontract").getLong("id")));
                gUse.setComment(gc.getString("gcomment"));
                gUse.setBizAmount(bizAmount);
                gUse.setgAmount(gc.getBigDecimal("gamount"));
                gUse.setgRatio(gc.getBigDecimal("gratio"));
                gUse.setExchrate(gc.getBigDecimal("gexchrate"));
                gUse.setDebtOrgId(debtOrgId);
                gUse.setDebtOrgText(debtOrgText);
                gUse.setDebtCurrencyId(debtCcyId);
                gUse.setCparty(cPartName);
                gUse.setDebtStartDate(startDate);
                gUse.setDebtEndDate(endDate);
                gUseList.add(gUse);
            }
        }
        GuaranteeUseHelper.deleteGuaranteeUse(deleteBizIds);
        GuaranteeUseHelper.saveGuaranteeUse(gUseList);
    }

    public static void changeCreditLimit(DynamicObject bill, DynamicObject apply, boolean isAudit) {
        if (EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("creditlimit"))) {
            return;
        }
        CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)bill, null, (boolean)false);
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId(Long.valueOf(bill.getDynamicObject("applyorg").getLong("id")));
        useBean.setFinOrgId(Long.valueOf(bill.getDynamicObject("finorginfo").getLong("id")));
        useBean.setCurrencyId(Long.valueOf(bill.getDynamicObject("currency").getLong("id")));
        DynamicObject finProduct = bill.getDynamicObject("guaranteevariety");
        DynamicObject creditType = finProduct != null ? finProduct.getDynamicObject("credittype") : null;
        useBean.setCreditTypeId(Long.valueOf(creditType != null ? creditType.getLong("id") : 0L));
        useBean.setCreditVariety(finProduct != null ? finProduct.getString("name") : "");
        useBean.setStartDate(bill.getDate("startdate"));
        useBean.setEndDate(bill.getDate("expiredate"));
        if (isAudit) {
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)bill.getLong("id"), (String)bill.getDataEntityType().getName());
            useBean.setCreditRatio(creditUseBill != null ? creditUseBill.getBigDecimal("creditratio") : Constants.ONE_HUNDRED);
            apply.set("creditgratio", (Object)useBean.getCreditRatio());
        } else {
            BigDecimal creditRatio = apply.getBigDecimal("creditgratio");
            useBean.setCreditRatio(EmptyUtil.isEmpty((BigDecimal)creditRatio) ? Constants.ONE_HUNDRED : creditRatio);
        }
        useBean.setBizAmt(bill.getBigDecimal("amount"));
        useBean.setMaxAmt(bill.getBigDecimal("amount"));
        useBean.setCreditLimitNo(bill.getDynamicObject("creditlimit").getString("number"));
        useBean.setPreOccupy(Boolean.valueOf(false));
        useBean.setPart(true);
        CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
        CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)bill, null, (boolean)false);
    }

    public static void changeSuretyBill(DynamicObject bill, DynamicObject apply) {
        Long debtBillId = bill.getLong("id");
        QFilter idFilter = new QFilter("entry.debtbillid", "=", (Object)debtBillId);
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)String.join((CharSequence)",", "id", "entry.debtbillid", "entry.debtamt", "entry.debtstartdate", "entry.debtenddate"), (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
            return;
        }
        DynamicObjectCollection entry = suretyBill.getDynamicObjectCollection("entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        List debitEntries = entry.stream().filter(d -> d.getLong("debtbillid") == debtBillId.longValue()).collect(Collectors.toList());
        if (debitEntries.isEmpty()) {
            return;
        }
        DynamicObject debitEntry = (DynamicObject)debitEntries.get(0);
        debitEntry.set("debtstartdate", (Object)apply.getDate("startdate"));
        debitEntry.set("debtenddate", (Object)apply.getDate("expiredate"));
        debitEntry.set("debtamt", (Object)apply.getBigDecimal("amount"));
        SaveServiceHelper.update((DynamicObject)suretyBill);
    }

    public static boolean checkPermisionForIsreissue(List<Long> selectedIdList, String appId) {
        QFilter qFilter = new QFilter("id", "in", selectedIdList);
        DynamicObjectCollection letterOfGuarantees = QueryServiceHelper.query((String)"gm_letterofguarantee", (String)"isreissue,org,applyorg", (QFilter[])new QFilter[]{qFilter});
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"gm_letterofguarantee", (String)"47150e89000000ac");
        for (DynamicObject letterOfGuarantee : letterOfGuarantees) {
            long org = letterOfGuarantee.getLong("org");
            long applyOrg = letterOfGuarantee.getLong("applyorg");
            boolean isReissue = letterOfGuarantee.getBoolean("isreissue");
            if (!isReissue || !EmptyUtil.isNoEmpty((Long)applyOrg) || !comIdList.contains(applyOrg) || comIdList.contains(org)) continue;
            return false;
        }
        return true;
    }

    public static boolean isChangePropForEntryGrid(DynamicObject lastBill, DynamicObject nextBill, String entryName, String entryKey) {
        DynamicObjectCollection lastEntitys = lastBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection nextEntitys = nextBill.getDynamicObjectCollection(entryName);
        HashMap nextRecord = new HashMap(nextEntitys.size());
        if (lastEntitys.size() > 0) {
            for (DynamicObject nextEntity : nextEntitys) {
                Map nextjMap = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)nextEntity, (boolean)true);
                nextRecord.put(nextjMap.get(entryKey), nextjMap);
            }
        }
        boolean change = false;
        for (DynamicObject entry : lastEntitys) {
            Map lastObjMap = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)entry, (boolean)true);
            if (nextRecord.isEmpty()) continue;
            Map nextObjMap = (Map)nextRecord.get(lastObjMap.get(entryKey));
            if (CollectionUtils.isEmpty((Map)nextObjMap)) {
                change = true;
                continue;
            }
            Map entriesDiffering = DynamicObjectCompareHelper.entriesDiffering((Map)lastObjMap, (Map)nextObjMap);
            if (CollectionUtils.isEmpty((Map)entriesDiffering)) continue;
            entriesDiffering.remove("id");
            entriesDiffering.remove("seq");
            if (CollectionUtils.isEmpty((Map)entriesDiffering)) continue;
            change = true;
        }
        return change;
    }

    public static boolean isChangePropForEntryGrid(DynamicObject lastBill, DynamicObject nextBill, List<String> entryNames, List<String> entryKey) {
        if (entryNames != null && entryNames.size() > 0) {
            for (int i = 0; i < entryNames.size(); ++i) {
                if (!LetterOfGuaranteeHelper.isChangePropForEntryGrid(lastBill, nextBill, entryNames.get(i), entryKey.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateSuretyStatus(DynamicObject lgbill, String bizStatus) {
        SuretyDebtEntryStatusInfo param = new SuretyDebtEntryStatusInfo();
        param.setId(Long.valueOf(lgbill.getLong("id")));
        param.setEntityName(lgbill.getDataEntityType().getName());
        param.setBizStatus(bizStatus);
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbd", (String)"suretyService", (String)"updateDebtStatus", (Object[])new Object[]{param});
    }

    public static void updateBeneficiaryType(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection beneficiaryCollection = dataEntity.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)beneficiaryCollection)) {
                dataEntity.set("beneficiarytype", (Object)((DynamicObject)beneficiaryCollection.get(0)).getString("e_beneficiarytype"));
                dataEntity.set("beneficiary", (Object)((DynamicObject)beneficiaryCollection.get(0)).getString("e_beneficiary"));
                dataEntity.set("textbeneficiary", (Object)((DynamicObject)beneficiaryCollection.get(0)).getString("e_textbeneficiary"));
                if (beneficiaryCollection.size() <= 1) continue;
                dataEntity.set("textbeneficiary", (Object)(((DynamicObject)beneficiaryCollection.get(0)).getString("e_textbeneficiary") + LetterOfGuaranteeHelper.getEndFlag()));
                continue;
            }
            dataEntity.set("beneficiarytype", null);
            dataEntity.set("beneficiary", (Object)0L);
            dataEntity.set("textbeneficiary", null);
        }
    }

    public static String getEndFlag() {
        return ResManager.loadKDString((String)"...", (String)"LetterOfGuaranteeHelper_0", (String)"tmc-gm-common", (Object[])new Object[0]);
    }

    public static void createGuaranteeUseByCredit(DynamicObject letterOfGuaranteeBill) {
        DynamicObject creditLimitBill = letterOfGuaranteeBill.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)creditLimitBill)) {
            return;
        }
        DynamicObjectCollection guaranteeUseBills = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)String.join((CharSequence)",", "gcomment", "gcontract", "gamount", "gcontract.amount", "gcontract.currency", "gratio", "gexchrate"), (QFilter[])new QFilter[]{new QFilter("gsrcbillid", "=", creditLimitBill.getPkValue())}, (String)"id");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)guaranteeUseBills)) {
            return;
        }
        List gContractIds = guaranteeUseBills.stream().map(v -> v.getLong("gcontract")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", gContractIds);
        DynamicObject[] gContracts = TmcDataServiceHelper.load((String)"gm_guaranteecontract", (String)"id,currency", (QFilter[])new QFilter[]{idFilter});
        Map<Object, DynamicObject> gContractMap = Arrays.stream(gContracts).collect(Collectors.toMap(k -> k.get("id"), v -> v.getDynamicObject("currency")));
        BigDecimal ratioTotal = BigDecimal.ZERO;
        for (DynamicObject gUse : guaranteeUseBills) {
            ratioTotal = ratioTotal.add(gUse.getBigDecimal("gratio"));
        }
        Long srcBillId = letterOfGuaranteeBill.getLong("id");
        String srcBillType = letterOfGuaranteeBill.getDataEntityType().getName();
        String billNo = letterOfGuaranteeBill.getString("billno");
        DynamicObject bizOrg = letterOfGuaranteeBill.getDynamicObject("applyorg");
        DynamicObject bizCurrency = letterOfGuaranteeBill.getDynamicObject("currency");
        DynamicObject cParty = letterOfGuaranteeBill.getDynamicObject("finorginfo");
        Long debtOrgId = bizOrg == null ? 0L : bizOrg.getLong("id");
        String debtOrgText = bizOrg == null ? "" : bizOrg.getString("name");
        Long debtCcyId = bizCurrency == null ? 0L : bizCurrency.getLong("id");
        String cPartName = cParty == null ? "" : cParty.getString("name");
        Date startDate = letterOfGuaranteeBill.getDate("startdate");
        Date endDate = letterOfGuaranteeBill.getDate("expiredate");
        BigDecimal bizAmount = letterOfGuaranteeBill.getBigDecimal("amount");
        BigDecimal debtAmtTotal = BigDecimal.ZERO;
        ArrayList<DynamicObject> gUseDOList = new ArrayList<DynamicObject>(guaranteeUseBills.size());
        for (int i = 0; i < guaranteeUseBills.size(); ++i) {
            BigDecimal debtAmt;
            DynamicObject gc = (DynamicObject)guaranteeUseBills.get(i);
            DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"gm_guaranteeuse");
            newDO.set("gcontract", (Object)gc.getLong("gcontract"));
            DynamicObject currency = gContractMap.get(gc.getLong("gcontract"));
            newDO.set("gcurrency", (Object)currency);
            newDO.set("gratio", (Object)gc.getBigDecimal("gratio"));
            newDO.set("gcomment", (Object)gc.getString("gcomment"));
            BigDecimal gAmount = bizAmount.multiply(gc.getBigDecimal("gratio")).divide(Constants.ONE_HUNDRED, bizCurrency == null ? 6 : bizCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
            newDO.set("gamount", (Object)gAmount);
            newDO.set("gexchrate", (Object)gc.getBigDecimal("gexchrate"));
            newDO.set("gsrcbillbizamount", (Object)bizAmount);
            if (Constants.ONE_HUNDRED.compareTo(ratioTotal) == 0 && i == guaranteeUseBills.size() - 1) {
                debtAmt = bizAmount.subtract(debtAmtTotal);
            } else {
                debtAmt = gAmount;
                debtAmtTotal = debtAmtTotal.add(debtAmt);
            }
            newDO.set("gdebtamount", (Object)debtAmt);
            newDO.set("gdebtbalance", (Object)debtAmt);
            newDO.set("gdebtorg", (Object)debtOrgId);
            newDO.set("gdebtorgtext", (Object)debtOrgText);
            newDO.set("gdebtcurrency", (Object)debtCcyId);
            newDO.set("gdebtstartdate", (Object)startDate);
            newDO.set("gdebtenddate", (Object)endDate);
            newDO.set("gcparty", (Object)cPartName);
            newDO.set("gsrcbillid", (Object)srcBillId);
            newDO.set("gsrcbillno", (Object)billNo);
            newDO.set("gsrcbilltype", (Object)srcBillType);
            gUseDOList.add(newDO);
        }
        if (EmptyUtil.isNoEmpty(gUseDOList)) {
            SaveServiceHelper.save((DynamicObject[])gUseDOList.toArray(new DynamicObject[0]));
        }
        String billStatus = letterOfGuaranteeBill.getString("billstatus");
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus) || BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            GuaranteeUseHelper.confirmGuaranteeUse(Collections.singletonList(srcBillId));
        }
    }
}

