/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.gm.common.helper;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.gm.common.bean.BillIdAndBillNo;
import kd.tmc.gm.common.enums.GuaConBizStatusEnum;
import kd.tmc.gm.common.enums.PledgeSourceEnum;
import kd.tmc.gm.common.enums.RealRightEnum;

public class PledgeBillHelper {
    private static final Log logger = LogFactory.getLog(PledgeBillHelper.class);

    public static String checkGcByPledgeBill(Set<BillIdAndBillNo> billIdAndBillNos) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BillIdAndBillNo billIdAndBillNo : billIdAndBillNos) {
            Long id = billIdAndBillNo.getId();
            String pledgeBillNo = billIdAndBillNo.getBillNo();
            String selectProperties = new StringJoiner(",").add("id").add("bizstatus").add("billno").toString();
            String mFilterProperty = "morentity.m_pleg.id";
            QFilter mEntityQFilter = new QFilter(mFilterProperty, "=", (Object)id);
            QFilter bizStatusQFilter = new QFilter("bizstatus", "!=", (Object)GuaConBizStatusEnum.CLOSED.getValue());
            String pFilterQFilter = "pletgageentity.p_pleg.id";
            QFilter pEntityQFilter = new QFilter(pFilterQFilter, "=", (Object)id);
            QFilter gcBillQFilter = bizStatusQFilter.and(mEntityQFilter.or(pEntityQFilter));
            DynamicObjectCollection gcBills = QueryServiceHelper.query((String)"gm_guaranteecontract", (String)selectProperties, (QFilter[])new QFilter[]{gcBillQFilter});
            HashSet<String> gcBillNoSet = null;
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)gcBills)) continue;
            gcBillNoSet = new HashSet<String>(gcBills.size());
            for (DynamicObject gcBill : gcBills) {
                gcBillNoSet.add(gcBill.getString("billno"));
            }
            for (String gcBillNo : gcBillNoSet) {
                String info = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u62b5\u8d28\u62bc\u7269\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62c5\u4fdd\u5355\u201c%2$s\u201d\u8fd8\u672a\u5173\u95ed\u3002", (String)"PledgeBillCancel_01", (String)"tmc-gm-common", (Object[])new Object[0]), pledgeBillNo, gcBillNo);
                stringBuilder.append(info);
            }
        }
        if (EmptyUtil.isNoEmpty((String)stringBuilder.toString())) {
            stringBuilder.append(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PledgeBillCancel_02", (String)"tmc-gm-common", (Object[])new Object[0]));
        }
        return stringBuilder.toString();
    }

    public static void getUpdateDepositBizStatus(DynamicObject pledgeBill, List<DynamicObject> list) {
        QFilter idFilter;
        DynamicObject finSubscribeData;
        DynamicObject pledgeType = pledgeBill.getDynamicObject("pledgetypeid");
        Long pledgeNo = pledgeBill.getLong("pledgeno");
        if (EmptyUtil.isNoEmpty((DynamicObject)pledgeType) && EmptyUtil.isNoEmpty((Long)pledgeNo) && PledgeSourceEnum.DEPOSIT_MANAGEMENT.getValue().equals(pledgeType.getString("source"))) {
            QFilter idFilter2 = new QFilter("id", "=", (Object)pledgeNo);
            DynamicObject depositData = TmcDataServiceHelper.loadSingle((String)"cim_deposit", (String)"id, bizstatus", (QFilter[])idFilter2.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)depositData)) {
                depositData.set("bizstatus", (Object)"pledge_ing");
                list.add(depositData);
            }
        } else if (EmptyUtil.isNoEmpty((DynamicObject)pledgeType) && EmptyUtil.isNoEmpty((Long)pledgeNo) && PledgeSourceEnum.INVESTMENT_FINANCE.getValue().equals(pledgeType.getString("source")) && EmptyUtil.isNoEmpty((DynamicObject)(finSubscribeData = TmcDataServiceHelper.loadSingle((String)"cim_finsubscribe", (String)"id, finservicestatus", (QFilter[])(idFilter = new QFilter("id", "=", (Object)pledgeNo)).toArray())))) {
            finSubscribeData.set("finservicestatus", (Object)"pledge_ing");
            list.add(finSubscribeData);
        }
    }

    public static void getBackDepositBizStatus(DynamicObject pledgeBill, List<DynamicObject> list) {
        DynamicObject finSubscribeData;
        DynamicObject pledgeType = pledgeBill.getDynamicObject("pledgetypeid");
        Long pledgeNo = pledgeBill.getLong("pledgeno");
        logger.info("\u56de\u9000\u5b9a\u671f\u5b58\u6b3e\u4e1a\u52a1\u72b6\u6001\uff0cpledgeType={}\uff0cpledgeNo={}", (Object)pledgeType, (Object)pledgeNo);
        if (EmptyUtil.isNoEmpty((DynamicObject)pledgeType) && EmptyUtil.isNoEmpty((Long)pledgeNo) && PledgeSourceEnum.DEPOSIT_MANAGEMENT.getValue().equals(pledgeType.getString("source"))) {
            DynamicObject depositData = TmcDataServiceHelper.loadSingle((Object)pledgeNo, (String)"cim_deposit", (String)"id, bizstatus, redeemamount");
            if (EmptyUtil.isNoEmpty((DynamicObject)depositData) && "pledge_ing".equals(depositData.getString("bizstatus"))) {
                depositData.set("bizstatus", (Object)"subscribe_part");
                BigDecimal redeemAmount = depositData.getBigDecimal("redeemamount");
                if (redeemAmount.compareTo(BigDecimal.ZERO) == 0) {
                    depositData.set("bizstatus", (Object)"subscribe_done");
                }
                list.add(depositData);
            }
        } else if (EmptyUtil.isNoEmpty((DynamicObject)pledgeType) && EmptyUtil.isNoEmpty((Long)pledgeNo) && PledgeSourceEnum.INVESTMENT_FINANCE.getValue().equals(pledgeType.getString("source")) && EmptyUtil.isNoEmpty((DynamicObject)(finSubscribeData = TmcDataServiceHelper.loadSingle((Object)pledgeNo, (String)"cim_finsubscribe", (String)"id, finservicestatus, redeemamount"))) && "pledge_ing".equals(finSubscribeData.getString("finservicestatus"))) {
            finSubscribeData.set("finservicestatus", (Object)"subscribe_part");
            BigDecimal redeemAmount = finSubscribeData.getBigDecimal("redeemamount");
            if (redeemAmount.compareTo(BigDecimal.ZERO) == 0) {
                finSubscribeData.set("finservicestatus", (Object)"subscribe_done");
            }
            list.add(finSubscribeData);
        }
    }

    public static void handlePledgeBillImport(DynamicObject[] dynamicObjects) {
        for (DynamicObject data : dynamicObjects) {
            QFilter qFilter;
            Long realRightPersonId = data.getLong("realrightpersonid");
            if (EmptyUtil.isEmpty((Long)realRightPersonId)) {
                String realRightPersonText;
                String realRight = data.getString("realright");
                realRight = RealRightEnum.ORG.getValue().equals(realRight) ? RealRightEnum.USER_ORG.getValue() : realRight;
                DynamicObject realRightPersonDo = QueryServiceHelper.queryOne((String)realRight, (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)(realRightPersonText = data.getString("realrightpersontext")))});
                if (EmptyUtil.isNoEmpty((DynamicObject)realRightPersonDo)) {
                    data.set("realrightpersonid", (Object)realRightPersonDo.getLong("id"));
                }
            }
            DynamicObject pledgeType = data.getDynamicObject("pledgetypeid");
            Long pledgeNo = data.getLong("pledgeno");
            String pledgeTextNo = data.getString("pledgetextno");
            if (EmptyUtil.isEmpty((DynamicObject)pledgeType) || EmptyUtil.isEmpty((Long)pledgeNo)) continue;
            Object source = pledgeType.get("source");
            if (PledgeSourceEnum.FIXED_ASSETS.getValue().equals(source)) {
                data.set("pledgename", (Object)pledgeTextNo);
                continue;
            }
            if (PledgeSourceEnum.DEPOSIT_MANAGEMENT.getValue().equals(source)) {
                qFilter = new QFilter("id", "=", (Object)pledgeNo);
                DynamicObject depositDo = QueryServiceHelper.queryOne((String)"cim_deposit", (String)"investvarieties.name,surplusamount,intdate,expiredate", (QFilter[])qFilter.toArray());
                data.set("pledgename", depositDo.get("investvarieties.name"));
                data.set("originalvalue", depositDo.get("surplusamount"));
                data.set("initialappraisedvalue", depositDo.get("surplusamount"));
                data.set("begindate", depositDo.get("intdate"));
                data.set("enddate", depositDo.get("expiredate"));
                continue;
            }
            if (!PledgeSourceEnum.INVESTMENT_FINANCE.getValue().equals(source)) continue;
            qFilter = new QFilter("id", "=", (Object)pledgeNo);
            DynamicObject finSubscribeDo = QueryServiceHelper.queryOne((String)"cim_finsubscribe", (String)"investvarieties.name,redeemway,surplusamount,surpluscopies,iopv,intdate,expiredate", (QFilter[])qFilter.toArray());
            data.set("pledgename", finSubscribeDo.get("investvarieties.name"));
            if ("amount_redeem".equals(finSubscribeDo.getString("redeemway"))) {
                data.set("originalvalue", finSubscribeDo.get("surplusamount"));
                data.set("initialappraisedvalue", finSubscribeDo.get("surplusamount"));
            } else {
                data.set("originalvalue", (Object)finSubscribeDo.getBigDecimal("surpluscopies").multiply(finSubscribeDo.getBigDecimal("iopv")));
                data.set("initialappraisedvalue", (Object)finSubscribeDo.getBigDecimal("surpluscopies").multiply(finSubscribeDo.getBigDecimal("iopv")));
            }
            data.set("begindate", finSubscribeDo.get("intdate"));
            data.set("enddate", finSubscribeDo.get("expiredate"));
        }
    }
}

