/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.ifm.bean.AccountBalanceInfo;
import kd.tmc.ifm.bean.IntObjectInfo;

public class IntObjectCalcRequest
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Long currencyId;
    private List<AccountBalanceInfo> balanceList;
    private List<RateInfo> rateList;
    private Date beginDate;
    private Date endDate;
    private BigDecimal balance;
    private boolean isPreCallInt;
    private boolean isCalOverInt;
    private RepaymentWayEnum repaymentWay = RepaymentWayEnum.zhye;
    private IntObjectInfo intObjectInfo;

    public List<PlanCallResult> transPlanCallResultList() {
        ArrayList<PlanCallResult> list = new ArrayList<PlanCallResult>(this.balanceList.size());
        for (AccountBalanceInfo balanceInfo : this.balanceList) {
            PlanCallResult result = new PlanCallResult();
            result.setPayInt(balanceInfo.isPayInt());
            result.setPrinciple(balanceInfo.getPrinciple());
            result.setBizDate(balanceInfo.getBizDate());
            result.setFloatRate(balanceInfo.getFloatRate());
            list.add(result);
        }
        return list;
    }

    public IntObjectCalcRequest initBalanceList(List<PlanCallResult> callResultList) {
        this.balanceList = new ArrayList<AccountBalanceInfo>(callResultList.size());
        for (PlanCallResult balance : callResultList) {
            this.balanceList.add(AccountBalanceInfo.build(balance.isPayInt(), balance.getBizDate(), balance.getPrinciple(), balance.getFloatRate()));
        }
        return this;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public IntObjectCalcRequest setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
        return this;
    }

    public List<AccountBalanceInfo> getBalanceList() {
        return this.balanceList;
    }

    public IntObjectCalcRequest setBalanceList(List<AccountBalanceInfo> balanceList) {
        this.balanceList = balanceList;
        return this;
    }

    public List<RateInfo> getRateList() {
        return this.rateList;
    }

    public IntObjectCalcRequest setRateList(List<RateInfo> rateList) {
        this.rateList = rateList;
        return this;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public IntObjectCalcRequest setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public IntObjectCalcRequest setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public IntObjectCalcRequest setBalance(BigDecimal balance) {
        this.balance = balance;
        return this;
    }

    public boolean isPreCallInt() {
        return this.isPreCallInt;
    }

    public IntObjectCalcRequest setPreCallInt(boolean preCallInt) {
        this.isPreCallInt = preCallInt;
        return this;
    }

    public boolean isCalOverInt() {
        return this.isCalOverInt;
    }

    public IntObjectCalcRequest setCalOverInt(boolean calOverInt) {
        this.isCalOverInt = calOverInt;
        return this;
    }

    public RepaymentWayEnum getRepaymentWay() {
        return this.repaymentWay;
    }

    public IntObjectCalcRequest setRepaymentWay(RepaymentWayEnum repaymentWay) {
        this.repaymentWay = repaymentWay;
        return this;
    }

    public IntObjectInfo getIntObjectInfo() {
        return this.intObjectInfo;
    }

    public IntObjectCalcRequest setIntObjectInfo(IntObjectInfo intObjectInfo) {
        this.intObjectInfo = intObjectInfo;
        return this;
    }

    public IntObjectCalcRequest clone() {
        return (IntObjectCalcRequest)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)this), IntObjectCalcRequest.class);
    }
}

