/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.enums.InterTypeEnum;

public class PrincipleFloatRateInfo
implements Serializable {
    private static final BigDecimal FLOAT_RATE_UNIT = new BigDecimal("0.01");
    private static final BigDecimal MIN_PRINCIPLE = BigDecimal.ZERO;
    private static final BigDecimal MAX_PRINCIPLE = new BigDecimal("999999999999999");
    private BigDecimal beginPrinciple;
    private BigDecimal endPrinciple;
    private BigDecimal floatRate;
    private InterTypeEnum floatRateType = InterTypeEnum.normal;

    public static List<PrincipleFloatRateInfo> splitFloatRateByList(List<PrincipleFloatRateInfo> principleFloatRateInfos, BigDecimal principle) {
        boolean isNegate = PrincipleFloatRateInfo.compareZero(principle) < 0;
        InterTypeEnum interType = isNegate ? InterTypeEnum.overdue : InterTypeEnum.normal;
        List floatRateList = principleFloatRateInfos.stream().filter(f -> f.getFloatRateType().equals((Object)interType)).collect(Collectors.toList());
        if (floatRateList.isEmpty()) {
            return Collections.singletonList(new PrincipleFloatRateInfo().setBeginPrinciple(principle).setFloatRate(BigDecimal.ZERO));
        }
        ArrayList<PrincipleFloatRateInfo> list = new ArrayList<PrincipleFloatRateInfo>(16);
        BigDecimal initPrinciple = principle.abs();
        BigDecimal leftPrinciple = principle.abs();
        int size = floatRateList.size() - 1;
        for (int i = 0; i <= size; ++i) {
            PrincipleFloatRateInfo info;
            PrincipleFloatRateInfo floatRateInfo = (PrincipleFloatRateInfo)floatRateList.get(i);
            BigDecimal negate = isNegate ? BigDecimal.ONE.negate() : BigDecimal.ONE;
            BigDecimal beginPrinciple = floatRateInfo.getBeginPrinciple();
            BigDecimal endPrinciple = floatRateInfo.getEndPrinciple();
            BigDecimal diffPrinciple = endPrinciple.subtract(beginPrinciple);
            if (initPrinciple.compareTo(beginPrinciple) <= 0) break;
            if (leftPrinciple.compareTo(beginPrinciple) > 0) {
                info = new PrincipleFloatRateInfo().setFloatRate(floatRateInfo.getFloatRate().multiply(FLOAT_RATE_UNIT));
                if (leftPrinciple.compareTo(diffPrinciple) >= 0) {
                    info.setBeginPrinciple(diffPrinciple.multiply(negate));
                } else {
                    info.setBeginPrinciple(leftPrinciple.multiply(negate));
                }
                list.add(info);
                leftPrinciple = leftPrinciple.subtract(diffPrinciple);
                if (PrincipleFloatRateInfo.compareZero(leftPrinciple) <= 0) break;
                if (i != size) continue;
                list.add(new PrincipleFloatRateInfo().setFloatRate(BigDecimal.ZERO).setBeginPrinciple(leftPrinciple.multiply(negate)));
                break;
            }
            info = new PrincipleFloatRateInfo().setFloatRate(floatRateInfo.getFloatRate().multiply(FLOAT_RATE_UNIT)).setBeginPrinciple(leftPrinciple.multiply(negate));
            list.add(info);
            break;
        }
        return list;
    }

    private static Integer compareZero(BigDecimal value) {
        return value.compareTo(BigDecimal.ZERO);
    }

    public BigDecimal getBeginPrinciple() {
        return this.beginPrinciple != null ? this.beginPrinciple : MIN_PRINCIPLE;
    }

    public PrincipleFloatRateInfo setBeginPrinciple(BigDecimal beginPrinciple) {
        this.beginPrinciple = beginPrinciple;
        return this;
    }

    public BigDecimal getEndPrinciple() {
        return this.endPrinciple != null && this.endPrinciple.compareTo(BigDecimal.ZERO) > 0 ? this.endPrinciple : MAX_PRINCIPLE;
    }

    public PrincipleFloatRateInfo setEndPrinciple(BigDecimal endPrinciple) {
        this.endPrinciple = endPrinciple;
        return this;
    }

    public BigDecimal getFloatRate() {
        return this.floatRate;
    }

    public PrincipleFloatRateInfo setFloatRate(BigDecimal floatRate) {
        this.floatRate = floatRate;
        return this;
    }

    public InterTypeEnum getFloatRateType() {
        return this.floatRateType;
    }

    public PrincipleFloatRateInfo setFloatRateType(InterTypeEnum floatRateType) {
        this.floatRateType = floatRateType;
        return this;
    }
}

